/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui;

import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.PropertyWrapper;
import org.diylc.swing.gui.components.OverwritePromptFileChooser;
import org.diylc.swing.gui.editor.PropertyEditorDialog;
import org.diylc.swing.plugins.file.BomDialog;
import org.diylc.swing.plugins.online.view.LoginDialog;
import org.diylc.swing.plugins.online.view.NewUserDialog;
import org.diylc.swing.plugins.online.view.UploadDialog;
import org.diylc.swingframework.AboutDialog;
import org.diylc.swingframework.IFileChooserAccessory;
import org.diylc.swingframework.ProgressDialog;
import org.diylc.utils.BomEntry;

public class DialogFactory {
    private static DialogFactory instance;
    private static final String PATH_KEY = "lastPath";
    private JFrame mainFrame;
    private File lastDirectory;

    public static DialogFactory getInstance() {
        if (instance == null) {
            instance = new DialogFactory();
        }
        return instance;
    }

    private DialogFactory() {
    }

    public void initialize(JFrame jFrame) {
        this.mainFrame = jFrame;
        String string = ConfigurationManager.getInstance().readString(PATH_KEY, null);
        if (string != null) {
            this.lastDirectory = new File(string);
        }
    }

    public PropertyEditorDialog createPropertyEditorDialog(List<PropertyWrapper> list, String string) {
        PropertyEditorDialog propertyEditorDialog = new PropertyEditorDialog(this.mainFrame, list, string);
        return propertyEditorDialog;
    }

    public BomDialog createBomDialog(List<BomEntry> list) {
        BomDialog bomDialog = new BomDialog(this.mainFrame, list);
        return bomDialog;
    }

    public File showOpenDialog(FileFilter fileFilter, File file, String string, IFileChooserAccessory iFileChooserAccessory) {
        JFileChooser jFileChooser = new JFileChooser();
        this.initializeFileChooser(jFileChooser, fileFilter, file, string, iFileChooserAccessory);
        int n = jFileChooser.showOpenDialog(this.mainFrame);
        return this.processFileChooserResult(n, jFileChooser, string);
    }

    public File showSaveDialog(FileFilter fileFilter, File file, String string, IFileChooserAccessory iFileChooserAccessory) {
        OverwritePromptFileChooser overwritePromptFileChooser = new OverwritePromptFileChooser();
        this.initializeFileChooser(overwritePromptFileChooser, fileFilter, file, string, iFileChooserAccessory);
        int n = overwritePromptFileChooser.showSaveDialog(this.mainFrame);
        return this.processFileChooserResult(n, overwritePromptFileChooser, string);
    }

    private void initializeFileChooser(JFileChooser jFileChooser, FileFilter fileFilter, File file, String string, IFileChooserAccessory iFileChooserAccessory) {
        if (iFileChooserAccessory != null) {
            iFileChooserAccessory.install(jFileChooser);
        }
        for (FileFilter fileFilter2 : jFileChooser.getChoosableFileFilters()) {
            jFileChooser.removeChoosableFileFilter(fileFilter2);
        }
        if (jFileChooser instanceof OverwritePromptFileChooser) {
            ((OverwritePromptFileChooser)jFileChooser).setFileFilter(fileFilter, string);
        } else {
            jFileChooser.setFileFilter(fileFilter);
        }
        if (this.lastDirectory != null) {
            jFileChooser.setCurrentDirectory(this.lastDirectory);
        }
        jFileChooser.setSelectedFile(file);
    }

    private File processFileChooserResult(int n, JFileChooser jFileChooser, String string) {
        jFileChooser.setAccessory(null);
        if (n == 0) {
            this.lastDirectory = jFileChooser.getCurrentDirectory();
            ConfigurationManager.getInstance().writeValue(PATH_KEY, (Object)this.lastDirectory.getAbsolutePath());
            if (jFileChooser.getSelectedFile().getAbsolutePath().contains(".")) {
                return jFileChooser.getSelectedFile();
            }
            return new File(jFileChooser.getSelectedFile().getAbsoluteFile() + "." + string);
        }
        return null;
    }

    public AboutDialog createAboutDialog(String string, Icon icon, String string2, String string3, String string4, String string5, String string6) {
        AboutDialog aboutDialog = new AboutDialog(this.mainFrame, string, icon, string2, string3, string4, string5, string6);
        return aboutDialog;
    }

    public NewUserDialog createNewUserDialog() {
        NewUserDialog newUserDialog = new NewUserDialog(this.mainFrame);
        return newUserDialog;
    }

    public LoginDialog createLoginDialog() {
        LoginDialog loginDialog = new LoginDialog(this.mainFrame);
        return loginDialog;
    }

    public UploadDialog createUploadDialog() {
        UploadDialog uploadDialog = new UploadDialog(this.mainFrame);
        return uploadDialog;
    }

    public ProgressDialog createProgressDialog(String string, String[] stringArray, String string2, boolean bl) {
        ProgressDialog progressDialog = new ProgressDialog(this.mainFrame, string, stringArray, string2, bl);
        return progressDialog;
    }
}

