/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.toolbox;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.diylc.common.ComponentType;
import org.diylc.common.IPlugInPort;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Template;
import org.diylc.images.IconLoader;
import org.openide.awt.DropDownButtonFactory;

class ComponentButtonFactory {
    private static final long serialVersionUID = 1L;
    public static int MARGIN = 3;

    ComponentButtonFactory() {
    }

    public static JButton create(final IPlugInPort iPlugInPort, final ComponentType componentType, JPopupMenu jPopupMenu) {
        JButton jButton = DropDownButtonFactory.createDropDownButton((Icon)componentType.getIcon(), (JPopupMenu)jPopupMenu);
        jButton.setBorder(BorderFactory.createEmptyBorder(MARGIN + 1, MARGIN + 1, MARGIN, MARGIN));
        jButton.setToolTipText("<html><b>" + componentType.getName() + "</b><br>" + componentType.getDescription() + "<br>Author: " + componentType.getAuthor() + "<br><br>Right click to select all components of this type" + "</html>");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                iPlugInPort.setNewComponentTypeSlot(componentType, null);
            }
        });
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    List list = iPlugInPort.getCurrentProject().getComponents();
                    ArrayList<IDIYComponent> arrayList = new ArrayList<IDIYComponent>();
                    for (IDIYComponent iDIYComponent : list) {
                        if (!componentType.getInstanceClass().equals(iDIYComponent.getClass())) continue;
                        arrayList.add(iDIYComponent);
                    }
                    if (mouseEvent.isControlDown()) {
                        arrayList.addAll(iPlugInPort.getSelectedComponents());
                    }
                    iPlugInPort.updateSelection(arrayList);
                    iPlugInPort.setNewComponentTypeSlot(null, null);
                    iPlugInPort.refresh();
                }
            }
        });
        jButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                iPlugInPort.keyPressed(keyEvent.getKeyCode(), keyEvent.isControlDown(), keyEvent.isShiftDown(), keyEvent.isAltDown());
            }
        });
        return jButton;
    }

    public static JMenuItem createTemplateItem(final IPlugInPort iPlugInPort, final Template template, final ComponentType componentType) {
        final JMenuItem jMenuItem = new JMenuItem(template.getName()){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(dimension.width + 18, dimension.height);
            }
        };
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                iPlugInPort.setNewComponentTypeSlot(componentType, template);
            }
        });
        JLabel jLabel = new JLabel(IconLoader.Garbage.getIcon());
        jLabel.setToolTipText("Delete template");
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                Container container = jMenuItem.getParent();
                if (container != null && container instanceof JPopupMenu) {
                    JPopupMenu jPopupMenu = (JPopupMenu)container;
                    jPopupMenu.setVisible(false);
                }
                if ((n = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(jMenuItem), "Are you sure you want to delete template \"" + template.getName() + "\"", "Delete", 0, 2)) != 0) {
                    return;
                }
                iPlugInPort.deleteTemplate(componentType.getCategory(), componentType.getName(), template.getName());
                mouseEvent.consume();
            }
        });
        jMenuItem.setLayout(new FlowLayout(2, 0, 0));
        jMenuItem.add(jLabel);
        return jMenuItem;
    }
}

