/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.game;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import net.sf.gogui.game.ExtraInfo;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.MoreExtraInfo;
import net.sf.gogui.game.SetupInfo;
import net.sf.gogui.game.TimeInfo;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;

public final class Node {
    private byte[] m_comment;
    private ExtraInfo m_extraInfo;
    private Move m_move;
    private Node m_father;
    private Object m_children;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Node() {
    }

    public Node(Move move) {
        this.m_move = move;
    }

    public void append(Node node) {
        if (!$assertionsDisabled && node.m_father != null) {
            throw new AssertionError();
        }
        if (this.m_children == null) {
            this.m_children = node;
        } else if (this.m_children instanceof Node) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(this.m_children);
            arrayList.add(node);
            this.m_children = arrayList;
        } else {
            ((ArrayList)this.m_children).add(node);
        }
        node.m_father = this;
    }

    public void addBlack(GoPoint goPoint) {
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        this.createSetupInfo().m_black.add(goPoint);
    }

    public void addEmpty(GoPoint goPoint) {
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        this.createSetupInfo().m_empty.add(goPoint);
    }

    public void addMarked(GoPoint goPoint, MarkType markType) {
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        Map map = this.createMarked();
        ArrayList<GoPoint> arrayList = (ArrayList<GoPoint>)map.get(markType);
        if (arrayList == null) {
            arrayList = new ArrayList<GoPoint>(1);
            arrayList.add(goPoint);
            map.put(markType, arrayList);
        } else if (!arrayList.contains(goPoint)) {
            arrayList.add(goPoint);
        }
    }

    public void addSgfProperty(String string, String string2) {
        this.createSgfProperties().put(string, string2);
    }

    public void addWhite(GoPoint goPoint) {
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        this.createSetupInfo().m_white.add(goPoint);
    }

    public GoPoint getAddBlack(int n) {
        SetupInfo setupInfo = this.m_extraInfo.m_moreExtraInfo.m_setupInfo;
        return (GoPoint)setupInfo.m_black.get(n);
    }

    public GoPoint getAddEmpty(int n) {
        SetupInfo setupInfo = this.m_extraInfo.m_moreExtraInfo.m_setupInfo;
        return (GoPoint)setupInfo.m_empty.get(n);
    }

    public GoPoint getAddWhite(int n) {
        SetupInfo setupInfo = this.m_extraInfo.m_moreExtraInfo.m_setupInfo;
        return (GoPoint)setupInfo.m_white.get(n);
    }

    public Node getChild() {
        if (this.getNumberChildren() == 0) {
            return null;
        }
        return this.getChild(0);
    }

    public Node getChild(int n) {
        if (this.getNumberChildren() == 1) {
            return (Node)this.m_children;
        }
        return (Node)((ArrayList)this.m_children).get(n);
    }

    public int getChildIndex(Node node) {
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            if (this.getChild(i) != node) continue;
            return i;
        }
        return -1;
    }

    public String getComment() {
        if (this.m_comment == null) {
            return null;
        }
        try {
            return new String(this.m_comment, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.m_comment);
        }
    }

    public Node getFather() {
        return this.m_father;
    }

    public String getLabel(GoPoint goPoint) {
        Map map = this.getLabels();
        if (map == null || !map.containsKey(goPoint)) {
            return null;
        }
        return (String)map.get(goPoint);
    }

    public Map getLabels() {
        if (this.m_extraInfo == null || this.m_extraInfo.m_moreExtraInfo == null) {
            return null;
        }
        return this.m_extraInfo.m_moreExtraInfo.m_label;
    }

    public ArrayList getMarked(MarkType markType) {
        if (this.m_extraInfo == null || this.m_extraInfo.m_marked == null) {
            return null;
        }
        return (ArrayList)this.m_extraInfo.m_marked.get(markType);
    }

    public Move getMove() {
        return this.m_move;
    }

    public int getMovesLeft(GoColor goColor) {
        TimeInfo timeInfo = this.getTimeInfo();
        if (timeInfo == null) {
            return -1;
        }
        if (goColor == GoColor.BLACK) {
            return timeInfo.m_movesLeftBlack;
        }
        if (!$assertionsDisabled && goColor != GoColor.WHITE) {
            throw new AssertionError();
        }
        return timeInfo.m_movesLeftWhite;
    }

    public int getNumberAddBlack() {
        SetupInfo setupInfo = this.getSetupInfo();
        if (setupInfo == null) {
            return 0;
        }
        return setupInfo.m_black.size();
    }

    public int getNumberAddEmpty() {
        SetupInfo setupInfo = this.getSetupInfo();
        if (setupInfo == null) {
            return 0;
        }
        return setupInfo.m_empty.size();
    }

    public int getNumberAddWhite() {
        SetupInfo setupInfo = this.getSetupInfo();
        if (setupInfo == null) {
            return 0;
        }
        return setupInfo.m_white.size();
    }

    public int getNumberChildren() {
        if (this.m_children == null) {
            return 0;
        }
        if (this.m_children instanceof Node) {
            return 1;
        }
        return ((ArrayList)this.m_children).size();
    }

    public GoColor getPlayer() {
        SetupInfo setupInfo = this.getSetupInfo();
        if (setupInfo == null) {
            return GoColor.EMPTY;
        }
        return setupInfo.m_player;
    }

    public Map getSgfProperties() {
        if (this.m_extraInfo == null || this.m_extraInfo.m_moreExtraInfo == null) {
            return null;
        }
        return this.m_extraInfo.m_moreExtraInfo.m_sgfProperties;
    }

    public double getTimeLeft(GoColor goColor) {
        TimeInfo timeInfo = this.getTimeInfo();
        if (timeInfo == null) {
            return Double.NaN;
        }
        if (goColor == GoColor.BLACK) {
            return timeInfo.m_timeLeftBlack;
        }
        if (!$assertionsDisabled && goColor != GoColor.WHITE) {
            throw new AssertionError();
        }
        return timeInfo.m_timeLeftWhite;
    }

    public GoColor getToMove() {
        GoColor goColor = this.getPlayer();
        if (goColor != GoColor.EMPTY) {
            return goColor;
        }
        if (this.m_move != null) {
            return this.m_move.getColor().otherColor();
        }
        return GoColor.EMPTY;
    }

    public float getValue() {
        if (this.m_extraInfo == null) {
            return Float.NaN;
        }
        return this.m_extraInfo.m_value;
    }

    public boolean hasComment() {
        return this.m_comment != null;
    }

    public boolean hasSetup() {
        return this.getNumberAddBlack() > 0 || this.getNumberAddWhite() > 0 || this.getNumberAddEmpty() > 0;
    }

    public boolean isChildOf(Node node) {
        return node.getChildIndex(this) != -1;
    }

    public void makeMainVariation(Node node) {
        if (!$assertionsDisabled && !node.isChildOf(this)) {
            throw new AssertionError();
        }
        if (this.getNumberChildren() <= 1) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.m_children;
        arrayList.remove(node);
        arrayList.add(0, node);
    }

    public void removeChild(Node node) {
        if (!$assertionsDisabled && !node.isChildOf(this)) {
            throw new AssertionError();
        }
        int n = this.getNumberChildren();
        if (n == 1) {
            this.m_children = null;
        } else if (n >= 2) {
            ArrayList arrayList = (ArrayList)this.m_children;
            arrayList.remove(node);
            if (n == 2) {
                this.m_children = arrayList.get(0);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        node.m_father = null;
    }

    public void removeMarked(GoPoint goPoint, MarkType markType) {
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        Map map = this.createMarked();
        ArrayList arrayList = (ArrayList)map.get(markType);
        if (arrayList != null) {
            arrayList.remove(goPoint);
        }
    }

    public void removeVariations() {
        if (this.getNumberChildren() <= 1) {
            return;
        }
        Node node = this.getChild(0);
        this.m_children = node;
    }

    public void setComment(String string) {
        if (string == null || string.trim().equals("")) {
            this.m_comment = null;
            return;
        }
        try {
            this.m_comment = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_comment = string.getBytes();
        }
    }

    public void setFather(Node node) {
        this.m_father = node;
    }

    public void setLabel(GoPoint goPoint, String string) {
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        Map map = this.createLabel();
        map.remove(goPoint);
        if (string == null) {
            return;
        }
        if ((string = string.trim()).equals("")) {
            return;
        }
        map.put(goPoint, string);
    }

    public void setMove(Move move) {
        this.m_move = move;
    }

    public void setMovesLeftBlack(int n) {
        this.createTimeInfo().m_movesLeftBlack = n;
    }

    public void setMovesLeftWhite(int n) {
        this.createTimeInfo().m_movesLeftWhite = n;
    }

    public void setTimeLeftBlack(double d) {
        this.createTimeInfo().m_timeLeftBlack = d;
    }

    public void setTimeLeftWhite(double d) {
        this.createTimeInfo().m_timeLeftWhite = d;
    }

    public void setPlayer(GoColor goColor) {
        if (!$assertionsDisabled && goColor != GoColor.BLACK && goColor != GoColor.WHITE) {
            throw new AssertionError();
        }
        this.createSetupInfo().m_player = goColor;
    }

    public void setValue(float f) {
        this.createExtraInfo();
        this.m_extraInfo.m_value = f;
    }

    public Node variationAfter(Node node) {
        int n;
        int n2 = this.getNumberChildren();
        if (n2 == 1) {
            return null;
        }
        for (n = 0; n < n2 && this.getChild(n) != node; ++n) {
        }
        if (n == n2 - 1) {
            return null;
        }
        return this.getChild(n + 1);
    }

    public Node variationBefore(Node node) {
        int n;
        int n2 = this.getNumberChildren();
        if (n2 == 1) {
            return null;
        }
        for (n = 0; n < n2 && this.getChild(n) != node; ++n) {
        }
        if (n == 0) {
            return null;
        }
        return this.getChild(n - 1);
    }

    private void createExtraInfo() {
        if (this.m_extraInfo == null) {
            this.m_extraInfo = new ExtraInfo();
        }
    }

    private MoreExtraInfo createMoreExtraInfo() {
        this.createExtraInfo();
        if (this.m_extraInfo.m_moreExtraInfo == null) {
            this.m_extraInfo.m_moreExtraInfo = new MoreExtraInfo();
        }
        return this.m_extraInfo.m_moreExtraInfo;
    }

    private Map createLabel() {
        MoreExtraInfo moreExtraInfo = this.createMoreExtraInfo();
        if (moreExtraInfo.m_label == null) {
            moreExtraInfo.m_label = new TreeMap();
        }
        return moreExtraInfo.m_label;
    }

    private Map createMarked() {
        this.createExtraInfo();
        if (this.m_extraInfo.m_marked == null) {
            this.m_extraInfo.m_marked = new TreeMap();
        }
        return this.m_extraInfo.m_marked;
    }

    private SetupInfo createSetupInfo() {
        MoreExtraInfo moreExtraInfo = this.createMoreExtraInfo();
        if (moreExtraInfo.m_setupInfo == null) {
            moreExtraInfo.m_setupInfo = new SetupInfo();
        }
        return moreExtraInfo.m_setupInfo;
    }

    private Map createSgfProperties() {
        MoreExtraInfo moreExtraInfo = this.createMoreExtraInfo();
        if (moreExtraInfo.m_sgfProperties == null) {
            moreExtraInfo.m_sgfProperties = new TreeMap();
        }
        return moreExtraInfo.m_sgfProperties;
    }

    private TimeInfo createTimeInfo() {
        MoreExtraInfo moreExtraInfo = this.createMoreExtraInfo();
        if (moreExtraInfo.m_timeInfo == null) {
            moreExtraInfo.m_timeInfo = new TimeInfo();
        }
        return moreExtraInfo.m_timeInfo;
    }

    private SetupInfo getSetupInfo() {
        if (this.m_extraInfo == null || this.m_extraInfo.m_moreExtraInfo == null) {
            return null;
        }
        return this.m_extraInfo.m_moreExtraInfo.m_setupInfo;
    }

    private TimeInfo getTimeInfo() {
        if (this.m_extraInfo == null || this.m_extraInfo.m_moreExtraInfo == null) {
            return null;
        }
        return this.m_extraInfo.m_moreExtraInfo.m_timeInfo;
    }

    static {
        $assertionsDisabled = !Node.class.desiredAssertionStatus();
    }
}

