/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLInitializationException;
import org.gradle.api.NonNullApi;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.internal.resource.transport.http.SystemDefaultSSLContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultSslContextFactory
implements SslContextFactory {
    private static final Set<String> SSL_SYSTEM_PROPERTIES = ImmutableSet.of((Object)"ssl.TrustManagerFactory.algorithm", (Object)"javax.net.ssl.trustStoreType", (Object)"javax.net.ssl.trustStore", (Object)"javax.net.ssl.trustStoreProvider", (Object)"javax.net.ssl.trustStorePassword", (Object)"ssl.KeyManagerFactory.algorithm", (Object[])new String[]{"javax.net.ssl.keyStoreType", "javax.net.ssl.keyStore", "javax.net.ssl.keyStoreProvider", "javax.net.ssl.keyStorePassword", "java.home"});
    private final LoadingCache<Map<String, String>, SSLContext> cache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new SynchronizedSystemPropertiesCacheLoader());

    @Override
    public SSLContext createSslContext() {
        return (SSLContext)this.cache.getUnchecked(DefaultSslContextFactory.getCurrentProperties());
    }

    private static Map<String, String> getCurrentProperties() {
        return (Map)SystemProperties.getInstance().withSystemProperties(() -> {
            TreeMap<String, String> currentProperties = new TreeMap<String, String>();
            for (String prop : SSL_SYSTEM_PROPERTIES) {
                currentProperties.put(prop, System.getProperty(prop));
            }
            return currentProperties;
        });
    }

    @NonNullApi
    private static class SslContextLoader {
        private static final Logger LOGGER = LoggerFactory.getLogger(SslContextLoader.class);

        private SslContextLoader() {
        }

        public static SSLContext load(Map<String, String> props) {
            try {
                return SystemDefaultSSLContextFactory.create();
            }
            catch (Exception e) {
                LOGGER.error("Could not initialize SSL context. Used properties: {}", props);
                throw new SSLInitializationException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class SynchronizedSystemPropertiesCacheLoader
    extends CacheLoader<Map<String, String>, SSLContext> {
        private SynchronizedSystemPropertiesCacheLoader() {
        }

        public SSLContext load(Map<String, String> props) {
            return (SSLContext)SystemProperties.getInstance().withSystemProperties(props, () -> SslContextLoader.load(props));
        }
    }
}

