/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.constraints;

import java.math.BigDecimal;
import javax.validation.ConstraintValidator;
import javax.validation.constraints.DecimalMin;

public abstract class AbstractDecimalMinValidator<T>
implements ConstraintValidator<DecimalMin, T> {
    private BigDecimal min;

    public final void initialize(DecimalMin constraintAnnotation) {
        try {
            this.min = new BigDecimal(constraintAnnotation.value());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(constraintAnnotation.value() + " does not represent a valid BigDecimal format", e);
        }
    }

    protected final boolean isValid(BigDecimal bigValue) {
        return this.min.compareTo(bigValue) <= 0;
    }
}

