/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.LineIterator;
import it.unimi.dsi.lang.MutableString;
import java.io.Closeable;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.campagnelab.goby.alignments.AlignedSequence;
import org.campagnelab.goby.reads.QualityEncoding;

public class LastParser
implements Closeable {
    private LineIterator iterator;
    private boolean entryFound;
    private float score;
    private final ObjectArrayList<AlignedSequence> alignedSequences;
    private final ObjectArraySet<AlignedSequence> poolOfAlignedSequences;
    private double qualityScores;

    public LastParser(Reader reader) {
        this.iterator = new LineIterator(new FastBufferedReader(reader));
        this.alignedSequences = new ObjectArrayList();
        this.poolOfAlignedSequences = new ObjectArraySet();
    }

    public boolean hasNext() {
        if (this.entryFound) {
            return true;
        }
        this.readScore();
        this.readMatches();
        return this.entryFound;
    }

    private void readMatches() {
        AlignedSequence previousSeq = null;
        while (this.iterator.hasNext()) {
            String[] tokens;
            MutableString line = this.iterator.next();
            if (line.startsWith("#")) continue;
            if (line.startsWith("s")) {
                tokens = line.toString().split("[\\ ]+");
                AlignedSequence seq = this.getAvailableAlignedSequence();
                seq.sequenceIdentifier.setLength(0);
                seq.sequenceIdentifier.append(tokens[1]);
                seq.alignedStart = Integer.parseInt(tokens[2]);
                seq.alignedLength = Integer.parseInt(tokens[3]);
                seq.strand = tokens[4].charAt(0);
                seq.sequenceLength = Integer.parseInt(tokens[5]);
                seq.alignment.setLength(0);
                seq.alignment.append(tokens[6]);
                this.alignedSequences.add((Object)seq);
                previousSeq = seq;
                continue;
            }
            if (!line.startsWith("q")) break;
            tokens = line.toString().split("[\\ \t]+");
            String readId = tokens[1];
            if (previousSeq == null || !previousSeq.sequenceIdentifier.equals(readId)) continue;
            previousSeq.qualityScores.clear();
            String qualityString = tokens[2];
            for (int i = 0; i < qualityString.length(); ++i) {
                previousSeq.qualityScores.add(QualityEncoding.SANGER.asciiEncodingToPhredQualityScore(qualityString.charAt(i)));
            }
        }
    }

    private void readScore() {
        while (this.iterator.hasNext()) {
            MutableString line = this.iterator.next();
            if (line.startsWith("#") || !line.startsWith("a")) continue;
            String[] tokens = line.toString().split("[\\ ]+");
            this.score = Float.parseFloat(tokens[1].substring(6));
            this.poolOfAlignedSequences.addAll(this.alignedSequences);
            this.alignedSequences.clear();
            this.entryFound = true;
            return;
        }
    }

    public float getScore() {
        return this.score;
    }

    public void next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() cannot be called when hasNext returns false.");
        }
        this.entryFound = false;
    }

    public ObjectArrayList<AlignedSequence> getAlignedSequences() {
        return this.alignedSequences;
    }

    public synchronized AlignedSequence getAvailableAlignedSequence() {
        if (this.poolOfAlignedSequences.isEmpty()) {
            AlignedSequence seq = new AlignedSequence();
            return seq;
        }
        AlignedSequence seq = (AlignedSequence)this.poolOfAlignedSequences.iterator().next();
        this.poolOfAlignedSequences.remove((Object)seq);
        return seq;
    }

    @Override
    public void close() {
        this.iterator = null;
    }
}

