/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.rmi.CORBA;

import gnu.CORBA.CDR.BufferedCdrOutput;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.ObjectCreator;
import gnu.CORBA.Unexpected;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.StubDelegate;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class StubDelegateImpl
implements StubDelegate {
    public void connect(Stub stub, ORB oRB) throws RemoteException {
        StubDelegateImpl.connect(stub, oRB, null);
    }

    public static void connect(Stub stub, ORB oRB, POA pOA) throws RemoteException {
        Delegate delegate;
        Object object;
        Object object2 = null;
        try {
            object = stub._get_delegate();
            if (object != null) {
                object2 = ((Delegate)object).orb(stub);
            }
        }
        catch (Exception exception) {}
        if (object2 != null) {
            if (!object2.equals(oRB)) {
                throw new RemoteException("Stub " + stub + " is connected to another ORB, " + oRB);
            }
            return;
        }
        object = null;
        if (stub instanceof Remote) {
            object = Util.getTie((Remote)((Object)stub));
        }
        if (object == null) {
            object = StubDelegateImpl.getTieFromStub(stub);
        }
        if (object instanceof Servant) {
            try {
                if (pOA == null && (pOA = POAHelper.narrow(oRB.resolve_initial_references("RootPOA"))).the_POAManager().get_state().value() == 0) {
                    pOA.the_POAManager().activate();
                }
                ObjectImpl objectImpl = (ObjectImpl)pOA.servant_to_reference((Servant)object);
                delegate = objectImpl._get_delegate();
            }
            catch (Exception exception) {
                throw new Unexpected(exception);
            }
        } else if (object instanceof ObjectImpl) {
            ObjectImpl objectImpl = (ObjectImpl)object;
            oRB.connect(objectImpl);
            delegate = objectImpl._get_delegate();
        } else {
            throw new BAD_PARAM("The Tie must be either Servant or ObjectImpl");
        }
        stub._set_delegate(delegate);
    }

    public static Tie getTieFromStub(Object object) {
        Tie tie;
        String string = object.getClass().getName();
        if (!string.endsWith("_Stub")) {
            throw new BAD_PARAM("The stub name, " + string + ", does not match _*_Stub pattern");
        }
        String string2 = string.substring(0, string.length() - "_Stub".length()) + "Impl_Tie";
        Class clazz = null;
        try {
            clazz = ObjectCreator.forName(string2);
            tie = (Tie)clazz.newInstance();
            if (object instanceof Remote) {
                Util.registerTarget(tie, (Remote)object);
            }
        }
        catch (Exception exception) {
            BAD_PARAM bAD_PARAM = new BAD_PARAM("Unable to instantiate '" + string2 + '\'');
            bAD_PARAM.initCause(exception);
            throw bAD_PARAM;
        }
        return tie;
    }

    public boolean equals(Stub stub, Object object) {
        if (object instanceof ObjectImpl) {
            ObjectImpl objectImpl = (ObjectImpl)object;
            Delegate delegate = objectImpl._get_delegate();
            Delegate delegate2 = stub._get_delegate();
            if (delegate == null || delegate2 == null) {
                boolean bl = false;
                if (delegate == delegate2) {
                    bl = true;
                }
                return bl;
            }
            return delegate.equals(delegate2);
        }
        return false;
    }

    public int hashCode(Stub stub) {
        Delegate delegate = stub._get_delegate();
        int n = 0;
        if (delegate != null) {
            n = delegate.hashCode();
        }
        return n;
    }

    public String toString(Stub stub) {
        try {
            return stub._orb().object_to_string(stub);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void readObject(Stub stub, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.readObject(stub, objectInputStream, null);
    }

    public void readObject(Stub stub, ObjectInputStream objectInputStream, ORB oRB) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInputStream.readObject();
        BufferredCdrInput bufferredCdrInput = new BufferredCdrInput(byArray);
        if (oRB != null) {
            bufferredCdrInput.setOrb(oRB);
        }
        ObjectImpl objectImpl = (ObjectImpl)bufferredCdrInput.read_Object();
        stub._set_delegate(objectImpl._get_delegate());
    }

    public void writeObject(Stub stub, ObjectOutputStream objectOutputStream) throws IOException {
        this.writeObject(stub, objectOutputStream, null);
    }

    public void writeObject(Stub stub, ObjectOutputStream objectOutputStream, ORB oRB) throws IOException {
        BufferedCdrOutput bufferedCdrOutput = new BufferedCdrOutput();
        bufferedCdrOutput.setOrb(oRB == null ? stub._orb() : oRB);
        bufferedCdrOutput.write_Object(stub);
        objectOutputStream.writeObject(bufferedCdrOutput.buffer.toByteArray());
    }
}

