/*
 * Decompiled with CFR 0.152.
 */
package java.awt.color;

import gnu.java.awt.color.ProfileHeader;
import gnu.java.awt.color.TagEntry;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_ProfileGray;
import java.awt.color.ICC_ProfileRGB;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Hashtable;

public class ICC_Profile
implements Serializable {
    private static final long serialVersionUID = -3938515861990936766L;
    public static final int CLASS_INPUT = 0;
    public static final int CLASS_DISPLAY = 1;
    public static final int CLASS_OUTPUT = 2;
    public static final int CLASS_DEVICELINK = 3;
    public static final int CLASS_COLORSPACECONVERSION = 4;
    public static final int CLASS_ABSTRACT = 5;
    public static final int CLASS_NAMEDCOLOR = 6;
    public static final int icSigInputClass = 1935896178;
    public static final int icSigDisplayClass = 1835955314;
    public static final int icSigOutputClass = 1886549106;
    public static final int icSigLinkClass = 1818848875;
    public static final int icSigColorSpaceClass = 1936744803;
    public static final int icSigAbstractClass = 1633842036;
    public static final int icSigNamedColorClass = 1852662636;
    public static final int icSigXYZData = 1482250784;
    public static final int icSigLabData = 1281450528;
    public static final int icSigLuvData = 1282766368;
    public static final int icSigYCbCrData = 1497588338;
    public static final int icSigYxyData = 1501067552;
    public static final int icSigRgbData = 1380401696;
    public static final int icSigGrayData = 1196573017;
    public static final int icSigHsvData = 1213421088;
    public static final int icSigHlsData = 1212961568;
    public static final int icSigCmykData = 1129142603;
    public static final int icSigCmyData = 1129142560;
    public static final int icSigSpace2CLR = 843271250;
    public static final int icSigSpace3CLR = 860048466;
    public static final int icSigSpace4CLR = 876825682;
    public static final int icSigSpace5CLR = 893602898;
    public static final int icSigSpace6CLR = 910380114;
    public static final int icSigSpace7CLR = 927157330;
    public static final int icSigSpace8CLR = 943934546;
    public static final int icSigSpace9CLR = 960711762;
    public static final int icSigSpaceACLR = 1094929490;
    public static final int icSigSpaceBCLR = 1111706706;
    public static final int icSigSpaceCCLR = 1128483922;
    public static final int icSigSpaceDCLR = 1145261138;
    public static final int icSigSpaceECLR = 1162038354;
    public static final int icSigSpaceFCLR = 1178815570;
    public static final int icPerceptual = 0;
    public static final int icRelativeColorimetric = 1;
    public static final int icSaturation = 2;
    public static final int icAbsoluteColorimetric = 3;
    public static final int icSigAToB0Tag = 1093812784;
    public static final int icSigAToB1Tag = 1093812785;
    public static final int icSigAToB2Tag = 1093812786;
    public static final int icSigBlueColorantTag = 1649957210;
    public static final int icSigBlueTRCTag = 1649693251;
    public static final int icSigBToA0Tag = 1110589744;
    public static final int icSigBToA1Tag = 1110589745;
    public static final int icSigBToA2Tag = 1110589746;
    public static final int icSigCalibrationDateTimeTag = 1667329140;
    public static final int icSigCharTargetTag = 1952543335;
    public static final int icSigCopyrightTag = 1668313716;
    public static final int icSigCrdInfoTag = 1668441193;
    public static final int icSigDeviceMfgDescTag = 1684893284;
    public static final int icSigDeviceModelDescTag = 0x646D6464;
    public static final int icSigDeviceSettingsTag = 1684371059;
    public static final int icSigGamutTag = 1734438260;
    public static final int icSigGrayTRCTag = 1800688195;
    public static final int icSigGreenColorantTag = 1733843290;
    public static final int icSigGreenTRCTag = 1733579331;
    public static final int icSigLuminanceTag = 1819635049;
    public static final int icSigMeasurementTag = 1835360627;
    public static final int icSigMediaBlackPointTag = 1651208308;
    public static final int icSigMediaWhitePointTag = 0x77747074;
    public static final int icSigNamedColor2Tag = 1852009522;
    public static final int icSigOutputResponseTag = 1919251312;
    public static final int icSigPreview0Tag = 1886545200;
    public static final int icSigPreview1Tag = 1886545201;
    public static final int icSigPreview2Tag = 1886545202;
    public static final int icSigProfileDescriptionTag = 1684370275;
    public static final int icSigProfileSequenceDescTag = 1886610801;
    public static final int icSigPs2CRD0Tag = 1886610480;
    public static final int icSigPs2CRD1Tag = 1886610481;
    public static final int icSigPs2CRD2Tag = 1886610482;
    public static final int icSigPs2CRD3Tag = 1886610483;
    public static final int icSigPs2CSATag = 1886597747;
    public static final int icSigPs2RenderingIntentTag = 1886597737;
    public static final int icSigRedColorantTag = 1918392666;
    public static final int icSigRedTRCTag = 1918128707;
    public static final int icSigScreeningDescTag = 1935897188;
    public static final int icSigScreeningTag = 1935897198;
    public static final int icSigTechnologyTag = 1952801640;
    public static final int icSigUcrBgTag = 1650877472;
    public static final int icSigViewingCondDescTag = 1987405156;
    public static final int icSigViewingConditionsTag = 1986618743;
    public static final int icSigChromaticityTag = 1667789421;
    public static final int icSigHead = 1751474532;
    public static final int icHdrSize = 0;
    public static final int icHdrCmmId = 4;
    public static final int icHdrVersion = 8;
    public static final int icHdrDeviceClass = 12;
    public static final int icHdrColorSpace = 16;
    public static final int icHdrPcs = 20;
    public static final int icHdrDate = 24;
    public static final int icHdrMagic = 36;
    public static final int icHdrPlatform = 40;
    public static final int icHdrFlags = 44;
    public static final int icHdrManufacturer = 48;
    public static final int icHdrModel = 52;
    public static final int icHdrAttributes = 56;
    public static final int icHdrRenderingIntent = 64;
    public static final int icHdrIlluminant = 68;
    public static final int icHdrCreator = 80;
    public static final int icTagType = 0;
    public static final int icTagReserved = 4;
    public static final int icCurveCount = 8;
    public static final int icCurveData = 12;
    public static final int icXYZNumberX = 8;
    private static final int tagTableOffset = 128;
    private static final int iccProfileSerializedDataVersion = 1;
    private static final String copyrightNotice = "Generated by GNU Classpath.";
    private static final int TRC_POINTS = 1024;
    private static final float[] D50 = new float[]{0.96422f, 1.0f, 0.82521f};
    private transient int profileID;
    private transient ProfileHeader header;
    private transient Hashtable tagTable;

    protected void finalize() {
    }

    public static ICC_Profile getInstance(byte[] byArray) {
        ProfileHeader profileHeader = new ProfileHeader(byArray);
        profileHeader.verifyHeader(byArray.length);
        Hashtable hashtable = ICC_Profile.createTagTable(byArray);
        if (ICC_Profile.isRGBProfile(profileHeader, hashtable)) {
            return new ICC_ProfileRGB(byArray);
        }
        if (ICC_Profile.isGrayProfile(profileHeader, hashtable)) {
            return new ICC_ProfileGray(byArray);
        }
        return new ICC_Profile(profileHeader, hashtable);
    }

    public static ICC_Profile getInstance(int n) {
        if (n == 1000 || n == 1004) {
            return new ICC_ProfileRGB(n);
        }
        if (n == 1003) {
            return new ICC_ProfileGray(n);
        }
        return new ICC_Profile(n);
    }

    public static ICC_Profile getInstance(String string) throws IOException {
        return ICC_Profile.getInstance(new FileInputStream(string));
    }

    public static ICC_Profile getInstance(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[128];
        if (inputStream.read(byArray) != 128) {
            throw new IllegalArgumentException("Invalid profile header");
        }
        ProfileHeader profileHeader = new ProfileHeader(byArray);
        profileHeader.verifyHeader(-1);
        byte[] byArray2 = new byte[profileHeader.getSize()];
        System.arraycopy(byArray, 0, byArray2, 0, 128);
        if (inputStream.read(byArray2, 128, profileHeader.getSize() - 128) != profileHeader.getSize() - 128) {
            throw new IOException("Incorrect profile size");
        }
        return ICC_Profile.getInstance(byArray2);
    }

    public int getMajorVersion() {
        return this.header.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.header.getMinorVersion();
    }

    public int getProfileClass() {
        return this.header.getProfileClass();
    }

    public int getColorSpaceType() {
        return this.header.getColorSpace();
    }

    public int getPCSType() {
        return this.header.getProfileColorSpace();
    }

    public void write(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.write(fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.getData());
    }

    public byte[] getData() {
        int n = this.getSize();
        byte[] byArray = new byte[n];
        System.arraycopy(this.header.getData(n), 0, byArray, 0, 128);
        byte[] byArray2 = this.getTagTable();
        System.arraycopy(byArray2, 0, byArray, 128, byArray2.length);
        Enumeration enumeration = this.tagTable.elements();
        while (enumeration.hasMoreElements()) {
            TagEntry tagEntry = (TagEntry)enumeration.nextElement();
            System.arraycopy(tagEntry.getData(), 0, byArray, tagEntry.getOffset(), tagEntry.getSize());
        }
        return byArray;
    }

    public byte[] getData(int n) {
        if (n == 1751474532) {
            return this.header.getData(this.getSize());
        }
        TagEntry tagEntry = (TagEntry)this.tagTable.get(TagEntry.tagHashKey(n));
        if (tagEntry == null) {
            return null;
        }
        return tagEntry.getData();
    }

    public void setData(int n, byte[] byArray) {
        this.profileID = -1;
        if (n == 1751474532) {
            this.header = new ProfileHeader(byArray);
        } else {
            TagEntry tagEntry = new TagEntry(n, byArray);
            this.tagTable.put(tagEntry.hashKey(), tagEntry);
        }
    }

    public int getNumComponents() {
        int[] nArray = new int[50];
        nArray[0] = 5;
        nArray[1] = 3;
        nArray[2] = 11;
        nArray[3] = 3;
        nArray[4] = 9;
        nArray[5] = 4;
        nArray[6] = 6;
        nArray[7] = 1;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[11] = 3;
        nArray[12] = 1;
        nArray[13] = 3;
        nArray[14] = 7;
        nArray[15] = 3;
        nArray[16] = 12;
        nArray[17] = 2;
        nArray[18] = 2;
        nArray[19] = 3;
        nArray[20] = 4;
        nArray[21] = 3;
        nArray[22] = 8;
        nArray[23] = 3;
        nArray[24] = 13;
        nArray[25] = 3;
        nArray[26] = 14;
        nArray[27] = 4;
        nArray[28] = 15;
        nArray[29] = 5;
        nArray[30] = 16;
        nArray[31] = 6;
        nArray[32] = 17;
        nArray[33] = 7;
        nArray[34] = 18;
        nArray[35] = 8;
        nArray[36] = 19;
        nArray[37] = 9;
        nArray[38] = 20;
        nArray[39] = 10;
        nArray[40] = 21;
        nArray[41] = 11;
        nArray[42] = 22;
        nArray[43] = 12;
        nArray[44] = 23;
        nArray[45] = 13;
        nArray[46] = 24;
        nArray[47] = 14;
        nArray[48] = 25;
        nArray[49] = 15;
        int[] nArray2 = nArray;
        int n = 0;
        while (n < nArray2.length) {
            if (this.header.getColorSpace() == nArray2[n]) {
                return nArray2[n + 1];
            }
            n += 2;
        }
        return 3;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (ICC_Profile.isRGBProfile(this.header, this.tagTable)) {
            return new ICC_ProfileRGB(this.getData());
        }
        if (ICC_Profile.isGrayProfile(this.header, this.tagTable)) {
            return new ICC_ProfileGray(this.getData());
        }
        return this;
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        if (byArray != null) {
            this.header = new ProfileHeader(byArray);
            this.tagTable = ICC_Profile.createTagTable(byArray);
            this.profileID = -1;
        }
        if (string != null) {
            if ((string = string.intern()).equals("CS_sRGB")) {
                this.createProfile(1000);
            }
            if (string.equals("CS_LINEAR_RGB")) {
                this.createProfile(1004);
            }
            if (string.equals("CS_CIEXYZ")) {
                this.createProfile(1001);
            }
            if (string.equals("CS_GRAY")) {
                this.createProfile(1003);
            }
            if (string.equals("CS_PYCC")) {
                this.createProfile(1002);
            }
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.profileID == 1000) {
            objectOutputStream.writeObject("CS_sRGB");
        } else if (this.profileID == 1004) {
            objectOutputStream.writeObject("CS_LINEAR_RGB");
        } else if (this.profileID == 1001) {
            objectOutputStream.writeObject("CS_CIEXYZ");
        } else if (this.profileID == 1003) {
            objectOutputStream.writeObject("CS_GRAY");
        } else if (this.profileID == 1002) {
            objectOutputStream.writeObject("CS_PYCC");
        } else {
            objectOutputStream.writeObject(null);
            objectOutputStream.writeObject(this.getData());
            return;
        }
        objectOutputStream.writeObject(null);
    }

    private static final Hashtable createTagTable(byte[] byArray) throws IllegalArgumentException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = byteBuffer.getInt(128);
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while (n2 < n) {
            TagEntry tagEntry = new TagEntry(byteBuffer.getInt(128 + n2 * 12 + 4), byteBuffer.getInt(128 + n2 * 12 + 8), byteBuffer.getInt(128 + n2 * 12 + 12), byArray);
            if (hashtable.put(tagEntry.hashKey(), tagEntry) != null) {
                throw new IllegalArgumentException("Duplicate tag in profile:" + tagEntry);
            }
            ++n2;
        }
        return hashtable;
    }

    private final int getSize() {
        int n = 128;
        int n2 = 4 + this.tagTable.size() * 12;
        if ((n2 & 3) != 0) {
            n2 += 4 - (n2 & 3);
        }
        n += n2;
        Enumeration enumeration = this.tagTable.elements();
        while (enumeration.hasMoreElements()) {
            int n3 = ((TagEntry)enumeration.nextElement()).getSize();
            if ((n3 & 3) != 0) {
                n3 += 4 - (n3 & 3);
            }
            n += n3;
        }
        return n;
    }

    private final byte[] getTagTable() {
        int n = 4 + this.tagTable.size() * 12;
        if ((n & 3) != 0) {
            n += 4 - (n & 3);
        }
        int n2 = 4;
        int n3 = 128 + n;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byteBuffer.putInt(this.tagTable.size());
        Enumeration enumeration = this.tagTable.elements();
        while (enumeration.hasMoreElements()) {
            TagEntry tagEntry = (TagEntry)enumeration.nextElement();
            byteBuffer.putInt(n2, tagEntry.getSignature());
            byteBuffer.putInt(n2 + 4, n3);
            byteBuffer.putInt(n2 + 8, tagEntry.getSize());
            tagEntry.setOffset(n3);
            int n4 = tagEntry.getSize();
            if ((n4 & 3) != 0) {
                n4 += 4 - (n4 & 3);
            }
            n3 += n4;
            n2 += 12;
        }
        return byteBuffer.array();
    }

    private static final boolean isRGBProfile(ProfileHeader profileHeader, Hashtable hashtable) {
        if (profileHeader.getColorSpace() != 5) {
            return false;
        }
        if (hashtable.get(TagEntry.tagHashKey(1918392666)) == null) {
            return false;
        }
        if (hashtable.get(TagEntry.tagHashKey(1733843290)) == null) {
            return false;
        }
        if (hashtable.get(TagEntry.tagHashKey(1649957210)) == null) {
            return false;
        }
        if (hashtable.get(TagEntry.tagHashKey(1918128707)) == null) {
            return false;
        }
        if (hashtable.get(TagEntry.tagHashKey(1733579331)) == null) {
            return false;
        }
        if (hashtable.get(TagEntry.tagHashKey(1649693251)) == null) {
            return false;
        }
        boolean bl = false;
        if (hashtable.get(TagEntry.tagHashKey(0x77747074)) != null) {
            bl = true;
        }
        return bl;
    }

    private static final boolean isGrayProfile(ProfileHeader profileHeader, Hashtable hashtable) {
        if (profileHeader.getColorSpace() != 6) {
            return false;
        }
        if (hashtable.get(TagEntry.tagHashKey(1800688195)) == null) {
            return false;
        }
        boolean bl = false;
        if (hashtable.get(TagEntry.tagHashKey(0x77747074)) != null) {
            bl = true;
        }
        return bl;
    }

    short[] getCurve(int n) {
        byte[] byArray = this.getData(n);
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (byteBuffer.getInt(0) != 1668641398) {
            return null;
        }
        int n2 = byteBuffer.getInt(8);
        if (n2 == 0) {
            short[] sArray = new short[]{256};
            return sArray;
        }
        if (n2 == 1) {
            short[] sArray = new short[]{byteBuffer.getShort(12)};
            return sArray;
        }
        short[] sArray = new short[n2];
        int n3 = 0;
        while (n3 < n2) {
            sArray[n3] = byteBuffer.getShort(12 + n3 * 2);
            ++n3;
        }
        return sArray;
    }

    float[] getXYZData(int n) {
        byte[] byArray = this.getData(n);
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (byteBuffer.getInt(0) != 1482250784) {
            return null;
        }
        float[] fArray = new float[]{(float)byteBuffer.getInt(8) / 65536.0f, (float)byteBuffer.getInt(12) / 65536.0f, (float)byteBuffer.getInt(16) / 65536.0f};
        return fArray;
    }

    int isPredefined() {
        return this.profileID;
    }

    private final byte[] makeXYZData(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(20);
        byteBuffer.putInt(0, 1482250784);
        byteBuffer.putInt(4, 0);
        byteBuffer.putInt(8, (int)((double)fArray[0] * 65536.0));
        byteBuffer.putInt(12, (int)((double)fArray[1] * 65536.0));
        byteBuffer.putInt(16, (int)((double)fArray[2] * 65536.0));
        return byteBuffer.array();
    }

    private final byte[] makeTextTag(String string) {
        byte[] byArray;
        int n = string.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 + n + 1);
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = new byte[n];
        }
        byteBuffer.putInt(0, 1952807028);
        byteBuffer.putInt(4, 0);
        int n2 = 0;
        while (n2 < n) {
            byteBuffer.put(8 + n2, byArray[n2]);
            ++n2;
        }
        byteBuffer.put(8 + n, (byte)0);
        return byteBuffer.array();
    }

    private final byte[] makeDescTag(String string) {
        byte[] byArray;
        int n = string.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(90 + n + 1);
        byteBuffer.putInt(0, 1684370275);
        byteBuffer.putInt(4, 0);
        byteBuffer.putInt(8, n + 1);
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = new byte[n];
        }
        int n2 = 0;
        while (n2 < n) {
            byteBuffer.put(12 + n2, byArray[n2]);
            ++n2;
        }
        byteBuffer.put(12 + n, (byte)0);
        n2 = 0;
        while (n2 < 39) {
            byteBuffer.putShort(13 + n + n2 * 2, (short)0);
            ++n2;
        }
        return byteBuffer.array();
    }

    private final byte[] makeTRC() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12);
        byteBuffer.putInt(0, 1668641398);
        byteBuffer.putInt(4, 0);
        byteBuffer.putInt(8, 0);
        return byteBuffer.array();
    }

    private final byte[] makeTRC(float f) {
        short s = (short)(f * 256.0f);
        ByteBuffer byteBuffer = ByteBuffer.allocate(14);
        byteBuffer.putInt(0, 1668641398);
        byteBuffer.putInt(4, 0);
        byteBuffer.putInt(8, 1);
        byteBuffer.putShort(12, s);
        return byteBuffer.array();
    }

    private final byte[] makeTRC(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12 + 2 * fArray.length);
        byteBuffer.putInt(0, 1668641398);
        byteBuffer.putInt(4, 0);
        byteBuffer.putInt(8, fArray.length);
        int n = 0;
        while (n < fArray.length) {
            byteBuffer.putShort(12 + n * 2, (short)(fArray[n] * 65535.0f));
            ++n;
        }
        return byteBuffer.array();
    }

    private final byte[] makeIdentityClut() {
        int n;
        short s;
        int n2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(27700);
        byteBuffer.putInt(0, 1835430962);
        byteBuffer.putInt(4, 0);
        byteBuffer.put(8, (byte)3);
        byteBuffer.put(9, (byte)3);
        byteBuffer.put(10, (byte)16);
        byteBuffer.put(11, (byte)0);
        byteBuffer.putInt(12, 65536);
        byteBuffer.putInt(16, 0);
        byteBuffer.putInt(20, 0);
        byteBuffer.putInt(24, 0);
        byteBuffer.putInt(28, 65536);
        byteBuffer.putInt(32, 0);
        byteBuffer.putInt(36, 0);
        byteBuffer.putInt(40, 0);
        byteBuffer.putInt(44, 65536);
        byteBuffer.putShort(48, (short)256);
        byteBuffer.putShort(50, (short)256);
        int n3 = 0;
        while (n3 < 3) {
            n2 = 0;
            while (n2 < 256) {
                s = (short)(n2 << 8 | n2);
                byteBuffer.putShort(52 + (n3 * 256 + n2) * 2, s);
                ++n2;
            }
            ++n3;
        }
        n3 = 1588;
        n2 = 0;
        while (n2 < 16) {
            s = 0;
            while (s < 16) {
                n = 0;
                while (n < 16) {
                    int n4 = n3 + n * 2 * 3 + s * 16 * 2 * 3 + n2 * 16 * 16 * 2 * 3;
                    double d = (double)n2 / 15.0;
                    double d2 = (double)s / 15.0;
                    double d3 = (double)n / 15.0;
                    byteBuffer.putShort(n4, (short)(d * 65535.0));
                    byteBuffer.putShort(n4 + 2, (short)(d2 * 65535.0));
                    byteBuffer.putShort(n4 + 4, (short)(d3 * 65535.0));
                    ++n;
                }
                s = (short)(s + 1);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 3) {
            s = 0;
            while (s < 256) {
                n = (short)(s << 8 | s);
                byteBuffer.putShort(n3 + 24576 + (n2 * 256 + s) * 2, (short)n);
                s = (short)(s + 1);
            }
            ++n2;
        }
        return byteBuffer.array();
    }

    private final void createProfile(int n) throws IllegalArgumentException {
        this.profileID = n;
        this.header = new ProfileHeader();
        this.tagTable = new Hashtable();
        switch (n) {
            case 1000: {
                this.createRGBProfile();
                return;
            }
            case 1004: {
                this.createLinearRGBProfile();
                return;
            }
            case 1001: {
                this.createCIEProfile();
                return;
            }
            case 1003: {
                this.createGrayProfile();
                return;
            }
            case 1002: {
                this.createPyccProfile();
                return;
            }
        }
        throw new IllegalArgumentException("Not a predefined color space!");
    }

    private final void createRGBProfile() {
        this.header.setColorSpace(5);
        this.header.setProfileColorSpace(0);
        ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(this);
        float[] fArray = new float[3];
        fArray[0] = 1.0f;
        float[] fArray2 = fArray;
        float[] fArray3 = new float[3];
        fArray3[1] = 1.0f;
        float[] fArray4 = fArray3;
        float[] fArray5 = new float[3];
        fArray5[2] = 1.0f;
        float[] fArray6 = fArray5;
        float[] fArray7 = new float[3];
        float[] fArray8 = D50;
        fArray2 = iCC_ColorSpace.toCIEXYZ(fArray2);
        fArray4 = iCC_ColorSpace.toCIEXYZ(fArray4);
        fArray6 = iCC_ColorSpace.toCIEXYZ(fArray6);
        iCC_ColorSpace = new ICC_ColorSpace(ICC_Profile.getInstance(1004));
        float[] fArray9 = new float[1024];
        float[] fArray10 = new float[3];
        int n = 0;
        while (n < 1024) {
            fArray10[1] = fArray10[2] = (float)n / 1023.0f;
            fArray10[0] = fArray10[2];
            fArray10 = iCC_ColorSpace.fromRGB(fArray10);
            fArray9[n] = fArray10[0];
            ++n;
        }
        this.setData(1918392666, this.makeXYZData(fArray2));
        this.setData(1733843290, this.makeXYZData(fArray4));
        this.setData(1649957210, this.makeXYZData(fArray6));
        this.setData(0x77747074, this.makeXYZData(fArray8));
        this.setData(1651208308, this.makeXYZData(fArray7));
        this.setData(1918128707, this.makeTRC(fArray9));
        this.setData(1733579331, this.makeTRC(fArray9));
        this.setData(1649693251, this.makeTRC(fArray9));
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("Generic sRGB"));
        this.profileID = 1000;
    }

    private final void createLinearRGBProfile() {
        this.header.setColorSpace(5);
        this.header.setProfileColorSpace(0);
        ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(this);
        float[] fArray = new float[3];
        fArray[0] = 1.0f;
        float[] fArray2 = fArray;
        float[] fArray3 = new float[3];
        fArray3[1] = 1.0f;
        float[] fArray4 = fArray3;
        float[] fArray5 = new float[3];
        fArray5[2] = 1.0f;
        float[] fArray6 = fArray5;
        float[] fArray7 = new float[3];
        float[] fArray8 = D50;
        fArray2 = iCC_ColorSpace.toCIEXYZ(fArray2);
        fArray4 = iCC_ColorSpace.toCIEXYZ(fArray4);
        fArray6 = iCC_ColorSpace.toCIEXYZ(fArray6);
        this.setData(1918392666, this.makeXYZData(fArray2));
        this.setData(1733843290, this.makeXYZData(fArray4));
        this.setData(1649957210, this.makeXYZData(fArray6));
        this.setData(0x77747074, this.makeXYZData(fArray8));
        this.setData(1651208308, this.makeXYZData(fArray7));
        this.setData(1918128707, this.makeTRC());
        this.setData(1733579331, this.makeTRC());
        this.setData(1649693251, this.makeTRC());
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("Linear RGB"));
        this.profileID = 1004;
    }

    private final void createCIEProfile() {
        this.header.setColorSpace(0);
        this.header.setProfileColorSpace(0);
        this.header.setProfileClass(4);
        ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(this);
        float[] fArray = D50;
        this.setData(0x77747074, this.makeXYZData(fArray));
        this.setData(1093812784, this.makeIdentityClut());
        this.setData(1110589744, this.makeIdentityClut());
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("CIE XYZ identity profile"));
        this.profileID = 1001;
    }

    private final void createGrayProfile() {
        this.header.setColorSpace(6);
        this.header.setProfileColorSpace(0);
        float[] fArray = D50;
        this.setData(0x77747074, this.makeXYZData(fArray));
        this.setData(1800688195, this.makeTRC(1.0f));
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("Linear grayscale"));
        this.profileID = 1003;
    }

    private final void createPyccProfile() {
        this.header.setColorSpace(13);
        this.header.setProfileColorSpace(0);
        this.setData(1668313716, this.makeTextTag(copyrightNotice));
        this.setData(1684370275, this.makeDescTag("Photo YCC"));
        this.profileID = 1002;
    }

    ICC_Profile(int n) {
        this.header = null;
        this.tagTable = null;
        this.createProfile(n);
    }

    ICC_Profile(ProfileHeader profileHeader, Hashtable hashtable) throws IllegalArgumentException {
        this.header = profileHeader;
        this.tagTable = hashtable;
        this.profileID = -1;
    }

    ICC_Profile(byte[] byArray) throws IllegalArgumentException {
        this.header = new ProfileHeader(byArray);
        this.header.verifyHeader(byArray.length);
        this.tagTable = ICC_Profile.createTagTable(byArray);
        this.profileID = -1;
    }
}

