require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&LIBCBOR_COMMON_H)) {
    eval 'sub LIBCBOR_COMMON_H () {1;}' unless defined(&LIBCBOR_COMMON_H);
    require 'assert.ph';
    require 'stdbool.ph';
    require 'stddef.ph';
    require 'stdint.ph';
    require 'stdlib.ph';
    require 'cbor/configuration.ph';
    require './cbor/data.ph';
    if(defined(&__cplusplus)) {
	eval 'sub CBOR_RESTRICT_POINTER () {1;}' unless defined(&CBOR_RESTRICT_POINTER);
    } else {
	eval 'sub CBOR_RESTRICT_POINTER () { &CBOR_RESTRICT_SPECIFIER;}' unless defined(&CBOR_RESTRICT_POINTER);
    }
    eval 'sub CBOR_VERSION () { &TO_STR( &CBOR_MAJOR_VERSION) "."  &TO_STR( &CBOR_MINOR_VERSION) "."  &TO_STR( &CBOR_PATCH_VERSION);}' unless defined(&CBOR_VERSION);
    eval 'sub CBOR_HEX_VERSION () {(( &CBOR_MAJOR_VERSION << 16) | ( &CBOR_MINOR_VERSION << 8) |  &CBOR_PATCH_VERSION);}' unless defined(&CBOR_HEX_VERSION);
    if(defined(&DEBUG)) {
	require 'stdio.ph';
	eval 'sub debug_print () {( &fmt, ...)  &do {  &if ( &DEBUG)  &fprintf( &stderr, "%s:%d:%s(): "  &fmt,  &__FILE__,  &__LINE__,  &__func__,  &__VA_ARGS__); }  &while (0);}' unless defined(&debug_print);
    } else {
	eval 'sub debug_print () {( &fmt, ...)  &do { }  &while (0);}' unless defined(&debug_print);
    }
    eval 'sub TO_STR_ {
        my($x) = @_;
	    eval q($x);
    }' unless defined(&TO_STR_);
    eval 'sub TO_STR {
        my($x) = @_;
	    eval q( &TO_STR_($x));
    }' unless defined(&TO_STR);
    eval 'sub _CBOR_NOTNULL {
        my($cbor_item) = @_;
	    eval q( &do {  &if ($cbor_item ==  &NULL) {  &return  &NULL; } }  &while (0));
    }' unless defined(&_CBOR_NOTNULL);
    eval 'sub _CBOR_DEPENDENT_NOTNULL {
        my($cbor_item, $pointer) = @_;
	    eval q( &do {  &if ($pointer ==  &NULL) {  &_CBOR_FREE($cbor_item);  &return  &NULL; } }  &while (0));
    }' unless defined(&_CBOR_DEPENDENT_NOTNULL);
    if((defined(&CBOR_CUSTOM_ALLOC) ? &CBOR_CUSTOM_ALLOC : undef)) {
	eval 'sub _CBOR_MALLOC () { &_cbor_malloc;}' unless defined(&_CBOR_MALLOC);
	eval 'sub _CBOR_REALLOC () { &_cbor_realloc;}' unless defined(&_CBOR_REALLOC);
	eval 'sub _CBOR_FREE () { &_cbor_free;}' unless defined(&_CBOR_FREE);
    } else {
	eval 'sub _CBOR_MALLOC () { &malloc;}' unless defined(&_CBOR_MALLOC);
	eval 'sub _CBOR_REALLOC () { &realloc;}' unless defined(&_CBOR_REALLOC);
	eval 'sub _CBOR_FREE () { &free;}' unless defined(&_CBOR_FREE);
    }
    if(defined(&__cplusplus)) {
    }
}
1;
