#  Common.pm
#    - functions common to all of pgpenvelope
#
#  Copyright (C) 2000 Frank J. Tobin <ftobin@uiuc.edu>
#
#  This file is part of pgpenvelope
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, visit the following URL:
#  http://www.gnu.org/copyleft/gpl.html
#
#  $Id: Common.pm,v 1.25 2001/05/13 02:53:23 ftobin Exp $
#

package PGPEnvelope::Common;

use 5.005;

use strict;
use English;
use IO::File;
use vars qw/ $VERSION /;

use constant DEBUG => 0;

$VERSION = '2.10.2';

sub version
{
    return $VERSION;
}


sub prefs_filename
{
    return 'prefs';
}



sub die_gracefully
{
    my ( $self, @message ) = @_;
    print @message;
    exit 1;
}



sub check_and_create_dir
{
    my ( $self, $work_dir ) = @_;
    
    return 1 if -d $work_dir;
    
    print "Creating $work_dir ...\n";
    return 1 if mkdir $work_dir, 0777;
    
    print "error: can't create $work_dir: $ERRNO\n";
    return 0;
}



sub open_tempfile
{
    my $fh = IO::File->new_tmpfile()
      or die "unable to create a temporary file";
    return $fh;
}



sub write_zeros
{
    my ( $self, $fh, $bytes ) = @_;
    my $buffsize = 2048;
    my $zeros = ( chr 0 ) x $buffsize;
    for ( my $i = 0; $i < $bytes; $i += $buffsize )
    {
	print $fh $zeros;
    }
}



sub clear_fh
{
    my ( $self, $fh ) = @_;
    $fh->seek( SEEK_SET, 0 );
    PGPEnvelope::Common->write_zeros( $fh, -s $fh );
}



sub display_warranty
{
    my $version = PGPEnvelope::Common->version();
    
    print <<EOF;
pgpenvelope $version, a Pine-with-GnuPG interface
Copyright (C) 2000 Frank J. Tobin <ftobin\@uiuc.edu>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, visit the following URL:
http://www.gnu.org/copyleft/gpl.html
EOF
}





1;
