<?php
/**
 * @entity asp.DownloadCount
 */
abstract class DownloadCountDAO extends ASPSOY2DAO{

	abstract function insert(DownloadCount $bean);

	abstract function update(DownloadCount $bean);

	abstract function get();

	/**
	 * @index name
	 * @query date = 0
	 */
	abstract function getTotal();

	/**
	 * @index name
	 * @query date = :date
	 */
	abstract function getByMonth($date);

	/**
	 * @index name
	 * @query date = 0 and name like '%-all'
	 */
	abstract function getTotalPerVersion();

	/**
	 * @index date
	 * @query name = :name and date > 0
	 * @order date asc
	 */
	abstract function getByName($name);

	/**
	 * @index date
	 * @query name = :name and date > 0
	 * @order date desc
	 */
	abstract function getLatestByName($name);

	/**
	 * @return object
	 * @query date = 0 AND name = :name
	 */
	abstract function getTotalByName($name);

	/**
	 * @return column_sum
	 * @columns sum(count) as sum
	 * @query date > 0 AND name = :name
	 */
	abstract function getSumByName($name);

	/**
	 * @final
	 */
	function increment($name, $date = 0){
		try{
			//insert
			$bean = new DownloadCount();
			$bean->setName($name);
			$bean->setDate($date);
			$bean->setCount(1);
			$this->insert($bean);
		}catch(Exception $e){
			//update
			$this->executeUpdateQuery(
				"update download_count set count = count + 1 where name = :name and date = :date",
				array(
					":name" => $name,
					":date" => $date
				)
			);
		}
	}
}
