/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.util.ArrayList;

public final class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> boolean contains(T[] array, T value) {
        for (T v : array) {
            if (v == null && value == null) {
                return true;
            }
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArray(Object o) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException("Object is null: cannot determine if it is of array type.");
        }
        return o.getClass().isArray();
    }

    public static <T> T[] concat(T[] ... objs) {
        ArrayList<T> out = new ArrayList<T>();
        int i = 0;
        T[] pass = null;
        for (T[] o : objs) {
            for (int j = 0; j < o.length; ++j) {
                out.add(o[j]);
                ++i;
            }
            pass = o;
        }
        return out.toArray(pass);
    }

    public static short[] concat(short[] ... objs) {
        int count = 0;
        for (short[] o : objs) {
            count += o.length;
        }
        short[] out = new short[count];
        int i = 0;
        for (short[] o : objs) {
            for (int j = 0; j < o.length; ++j) {
                out[i] = o[j];
                ++i;
            }
        }
        return out;
    }

    public static int[] concat(int[] ... objs) {
        int count = 0;
        for (int[] o : objs) {
            count += o.length;
        }
        int[] out = new int[count];
        int i = 0;
        for (int[] o : objs) {
            for (int j = 0; j < o.length; ++j) {
                out[i] = o[j];
                ++i;
            }
        }
        return out;
    }

    public static long[] concat(long[] ... objs) {
        int count = 0;
        for (long[] o : objs) {
            count += o.length;
        }
        long[] out = new long[count];
        int i = 0;
        for (long[] o : objs) {
            for (int j = 0; j < o.length; ++j) {
                out[i] = o[j];
                ++i;
            }
        }
        return out;
    }

    public static byte[] concat(byte[] ... objs) {
        int count = 0;
        for (byte[] o : objs) {
            count += o.length;
        }
        byte[] out = new byte[count];
        int i = 0;
        for (byte[] o : objs) {
            for (int j = 0; j < o.length; ++j) {
                out[i] = o[j];
                ++i;
            }
        }
        return out;
    }

    public static char[] concat(char[] ... objs) {
        int count = 0;
        for (char[] o : objs) {
            count += o.length;
        }
        char[] out = new char[count];
        int i = 0;
        for (char[] o : objs) {
            for (int j = 0; j < o.length; ++j) {
                out[i] = o[j];
                ++i;
            }
        }
        return out;
    }

    public static float[] concat(float[] ... objs) {
        int count = 0;
        for (float[] o : objs) {
            count += o.length;
        }
        float[] out = new float[count];
        int i = 0;
        for (float[] o : objs) {
            for (int j = 0; j < o.length; ++j) {
                out[i] = o[j];
                ++i;
            }
        }
        return out;
    }

    public static double[] concat(double[] ... objs) {
        int count = 0;
        for (double[] o : objs) {
            count += o.length;
        }
        double[] out = new double[count];
        int i = 0;
        for (double[] o : objs) {
            for (int j = 0; j < o.length; ++j) {
                out[i] = o[j];
                ++i;
            }
        }
        return out;
    }

    public static boolean[] concat(boolean[] ... objs) {
        int count = 0;
        for (boolean[] o : objs) {
            count += o.length;
        }
        boolean[] out = new boolean[count];
        int i = 0;
        for (boolean[] o : objs) {
            for (int j = 0; j < o.length; ++j) {
                out[i] = o[j];
                ++i;
            }
        }
        return out;
    }

    public static <T> void reverse(T[] arr) {
        int left = 0;
        for (int right = arr.length - 1; left < right; ++left, --right) {
            T tmp = arr[left];
            arr[left] = arr[right];
            arr[right] = tmp;
        }
    }

    public static void reverse(boolean[] arr) {
        int left = 0;
        for (int right = arr.length - 1; left < right; ++left, --right) {
            boolean tmp = arr[left];
            arr[left] = arr[right];
            arr[right] = tmp;
        }
    }

    public static void reverse(byte[] arr) {
        int left = 0;
        for (int right = arr.length - 1; left < right; ++left, --right) {
            byte tmp = arr[left];
            arr[left] = arr[right];
            arr[right] = tmp;
        }
    }

    public static void reverse(char[] arr) {
        int left = 0;
        for (int right = arr.length - 1; left < right; ++left, --right) {
            char tmp = arr[left];
            arr[left] = arr[right];
            arr[right] = tmp;
        }
    }

    public static void reverse(short[] arr) {
        int left = 0;
        for (int right = arr.length - 1; left < right; ++left, --right) {
            short tmp = arr[left];
            arr[left] = arr[right];
            arr[right] = tmp;
        }
    }

    public static void reverse(int[] arr) {
        int left = 0;
        for (int right = arr.length - 1; left < right; ++left, --right) {
            int tmp = arr[left];
            arr[left] = arr[right];
            arr[right] = tmp;
        }
    }

    public static void reverse(long[] arr) {
        int left = 0;
        for (int right = arr.length - 1; left < right; ++left, --right) {
            long tmp = arr[left];
            arr[left] = arr[right];
            arr[right] = tmp;
        }
    }

    public static void reverse(float[] arr) {
        int left = 0;
        for (int right = arr.length - 1; left < right; ++left, --right) {
            float tmp = arr[left];
            arr[left] = arr[right];
            arr[right] = tmp;
        }
    }

    public static void reverse(double[] arr) {
        int left = 0;
        for (int right = arr.length - 1; left < right; ++left, --right) {
            double tmp = arr[left];
            arr[left] = arr[right];
            arr[right] = tmp;
        }
    }
}

