#
# daemon.rb
#
#   Copyright (c) 1999-2002 Minero Aoki <aamine@loveruby.net>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU Lesser General Public License version 2 or later.
#
#   $Id: daemon.rb,v 1.2 2002/01/05 06:19:34 aamine Exp $
#

require 'socket'


class Daemon

  def self.exec( port, dir, debug = $DEBUG )
    new(debug).exec port, dir
  end

  def initialize( debug = $DEBUG )
    @debug = $DEBUG
  end

  def exec( port, dir )
    if @debug then
      Dir.chdir dir
      wait 
      return
    end

    fork do
      Process.setsid
      fork do
        Dir.chdir dir
        $stdin.close
        $stdout.close
        $stderr.close

        wait
      end

      exit!
    end
    exit!
  end

  def wait
    s = TCPServer.new( 10070 )

    unless @debug then
      trap( 'SIGINT' ) { exit! }
      trap( 'SIGHUP' ) { exit! }
      trap( 'SIGTERM' ) { exit! }
    end

    while true do
      @sock = s.accept
      begin
        session
      ensure
        @sock.close
      end
    end
  end

  # abstract session

end
