package TDS::AccessLog::Counter;
# $Id: Counter.pm,v 1.20 2001/02/06 05:02:10 tom Exp $
################################################################

=head1 NAME

TDS::AccessLog::Counter - 󥿡

=head1 SYNOPSIS

 use TDS::AccessLog::Counter;

 $c = new TDS::AccessLog::Counter;
 $c->Increment;

=cut

################################################################    
use strict;
use ObjectTemplate;
use Fcntl ':flock';

use TDS::System;

use vars qw(@ISA
	    $Template);
@ISA = qw(ObjectTemplate);

attributes qw(num all_filename today_filename);
#attributes qw(all today);

=head1 STATIC VARIABLES

 $Template               ƥץ졼

=cut

$Template = "%all/%today(%times)" unless defined $Template;

=head1 FUNCTIONS

=cut


################################################################
sub initialize($)
{
    my $self = shift;

    $self->num({});
    require TDS::AccessLog::DirInfo;
    my $logdir = TDS::AccessLog::DirInfo::GetLogDir();
    $self->all_filename("$logdir/counter_all.dat");
    $self->today_filename("$logdir/counter_today.dat");

#    warn times, "counter newed";
#    require SimpleDB::Scalar;
#    tie $self->num->{all}, 'SimpleDB::Scalar', $self->all_filename;
#    tie $self->num->{today}, 'SimpleDB::Scalar', $self->today_filename;
#    return;
    if (open(F, $self->all_filename)){
	eval { flock(F, LOCK_SH); };
	$_ = <F>;
	chomp;
	$self->num->{all} = $_;
	close (F);
    }
    if (open(F, $self->today_filename)){
	eval { flock(F, LOCK_SH); };
	$_ = <F>;
	chomp;
	$self->num->{today} = $_;
	close (F);

	# if yesterday, today counter reset
	my $tz = $TDS::System::TZ;
	my $cnt_date = new DateTime::Date;
	$cnt_date->SetTime((stat($self->today_filename))[9], $tz);
	if ($cnt_date != $TDS::Status->start_time){
	    $self->num->{today} = 0;
	}
    }

    $self->SUPER::initialize;
}

#sub DESTROY ($)
sub Save($)
{
    my $self = shift;

#    warn times, " counter saved";
#    untie $self->num->{all};
#    untie $self->num->{today};

#    return;
    unless (open(F, "+<" . $self->all_filename)){
	open(F, ">" . $self->all_filename) || die $self->all_filename;
    }
    eval { flock(F, LOCK_EX); };
    truncate(F, 0);    # file size do NOT decrease
    seek(F, 0, 0);
    print F $self->num->{all};
    close (F);
    unless (open(F, "+<" . $self->today_filename)){
	open(F, ">" . $self->today_filename) || die $self->today_filename;
    }
    eval { flock(F, LOCK_EX); };
    truncate(F, 0);    # file size may be decrease, by changine day
    seek(F, 0, 0);
    print F $self->num->{today};
    close (F);
}

=head2 $c->Increment;

󥿡䤹

=cut

sub Increment ($)
{
    my $self = shift;
    
    $self->num->{all}++;
    $self->num->{today}++;
}

=head2 $c->All;

̻󥿤֤

=cut
sub All($)
{
    camma_digit(shift->num->{all});
}

=head2 $c->Today;

Υ󥿤֤

=cut

sub Today ($)
{
    camma_digit(shift->num->{today});
}
sub Set($$$)
{

    my ($self, $all, $today) = @_;
    
    $self->num->{all} = $all;
    $self->num->{today} = $today;
}
sub camma_digit($)
{
    $_ = shift;
    1 while s/^(\d+)(\d\d\d)/$1,$2/;
    return $_;
}

1;
