package TDS::Cache::Diary;
# $Id: Diary.pm,v 1.6 2001/02/06 05:02:11 tom Exp $
################################################################
# TDS::Cache::Diary  derived from TDS::Cache::Base
#
#  base class which use cache as diary
#   ex. daily, display, recent, part, month
#
################################################################

use strict;
use vars qw(@ISA @EXPORT);
use Exporter;

@ISA = qw(TDS::Cache::Base);
@EXPORT = qw(attributes);

use ObjectTemplate;
use CGI::QueryString;

use TDS::DirInfo;
use TDS::Cache::Base;

attributes qw(has_secret);

################################################################

# member functions
sub IsFresh ($)
{
    my $self = shift;

    unless ($TDS::Status->is_author){   # NOT author access
	# first, try secret cache file
	$self->has_secret(1);
	my $filename = $self->GetCacheFilename;
#	warn times, " search secret-cache file: $filename";
	unless (-f $filename){
	    # if secret cache does not exist
	    # use normal cache
	    $self->has_secret(0);
	} else {
	    # secret file exists
#	    warn times, " diary has SECRET";
	    # remove normal cache if exists
	    $self->has_secret(0);
	    $self->RemoveCache;
	    $self->has_secret(1);
	}
    } else {
	# on author access, do NOT check secret cache
    }
    my $is_fresh = $self->SUPER::IsFresh;
    unless ($is_fresh){
	# if not fresh, reset secret
	$self->has_secret(0);
    }
    return $is_fresh;
}
sub GetCacheFilename($)
{
    shift->create_cache_filename("cache");
}
sub create_cache_filename ($$)
{
    my ($self, $basename) = @_;

    # do NOT call function in super class,
    # because it do NOT consider of 'secret'
    require TDS::Cache::DirInfo;
    return sprintf("%s/%s%s.%s", TDS::Cache::DirInfo::CacheDir(),
		   $basename,
		   ($self->has_secret) ? '-s' : '',
		   $self->cache_suffix);
}
################################################################
sub NewerThanDatafile($)
{
    my $self = shift;

    # diary cache depends on its original datafile, and
    # some conf, other datafiles such as template.ph, url.dat,,

    return 0
	if $TDS::Status->data_last_modified > $self->GetCacheLastModified;
    return $self->SUPER::NewerThanDatafile;
}
# original function (not override)
sub newer_than_cache($)
{
    my ($self, $filename) = @_;

    my $cache_lm = $self->GetCacheLastModified;
    my $file_lm = (stat($filename))[9] || 0;

    return $file_lm > $cache_lm;
}
################################################################
sub ReadCache($)
{
    my $self = shift;

    # consider of secret and author access,
    return if ($self->has_secret && $TDS::Status->is_author);

    # and then call super class
    return $self->SUPER::ReadCache;
}
sub WriteCache($$)
{
    my ($self, $line) = @_;

    # if it's author and has secret, do NOT output to cache file
    return if ($TDS::Status->is_author && $self->has_secret);

    if ($self->has_secret){
#	warn times, " has secret on writing: "; # , $self->GetCacheFilename;
	# if has secret and not author access
	# then remove normal cache
	$self->has_secret(0);
	if (-f $self->GetCacheFilename){
	    $self->RemoveCache;
	}
	$self->has_secret(1);
    } else {
	# remove secret cache-file which is already old, if exists
	$self->has_secret(1);
	if (-f $self->GetCacheFilename){
#	    warn times, " remove old secret cache file: "; #, $self->GetCacheFilename;
	    $self->RemoveCache;
	}
	$self->has_secret(0);
    }

    # call super class
    $self->SUPER::WriteCache($line);
}
    
    
1;

