package TDS::Installer;
# $Id: Installer.pm,v 1.122.4.1 2001/02/13 00:48:06 tom Exp $
################################################################

use strict qw(vars);
use lib qw(lib);

use Exporter;
use File::Path;

use ObjectTemplate;
use Installer;
use Input;
use Password;
use FileSpec;

use TDS::System;
use TDS::Cache::Expire;
use TDS::Cache::DirInfo;
use TDS::AccessLog::DirInfo;
use TDS::Customizer;
use TDS::IdentInfo;
use TDS::Cookie;
use TDS::Cache;
use TDS::Mode;
use TDS::DirInfo;

use vars qw(@ISA @EXPORT);

@ISA = qw(Installer);
@EXPORT = qw(attributes);

attributes qw(unload_setupfile readonly_setupfile
	      ja
	      as_user_setup);

################################################################
sub initialize($)
{
    my $self = shift;

    $self->start_message("TomsoftDiarySystem $TDS::System::Version installation...

before installation, please read install document(doc/install.html).
");
    $self->SUPER::initialize;
}

sub AddDefaultItems ($)
{
    my $self = shift;
    my $ja = $self->ja;

    # classes
    $self->used_classes(['TDS::System', 'TDS::Cache', 'TDS::IdentInfo',
			 'TDS::Cookie', 'TDS::AccessLog', 'TDS::Mode',
			 'TDS::DirInfo', 'TDS']);
    # site setup
    my $data;
    $self->AddItem(name=>'PerlPath',
		   type=>'absolute_path',
		   comment=>($ja)?'Perl Хѥ': 'perl path',
		   data=>which('perl') || '/usr/local/bin/perl');
    
    $self->AddItem(name=>'SendmailPath',
		   type=>'absolute_path',
		   comment=>($ja)? 'sendmail ΥХ' : 'sendmail path',
		   data=>which('sendmail') || '/usr/lib/sendmail');
    $self->AddItem(name=>'CanUseCGI',
		   type=>'bool',
		   comment=>($ja)? 'CGI Ȥ뤫' : 'can use CGI ?',
		   data=>$TDS::System::CanUseCGI);
    $self->AddItem(name=>'CanUseSSI',
		   type=>'bool',
		   comment=>($ja)? 'SSI Ȥ뤫' : 'can use SSI ?',
		   data=>$TDS::System::CanUseSSI);
#    $self->AddItem(name=>'CGIasOwner',
#		   type=>'bool',
#		   comment=>($ja)? 'CGI ͭԸ¤ư' : 'CGI works in Owner ID ?',
#		   comment2=>'SuExec or cgiwrapper works or not',
#		   data=>$TDS::System::CGIasOwner);
#    $self->AddItem(name=>'EnableModPerl',
#		   type=>'bool',
#		   comment=>($ja)? 'mod perl Ȥ' : 'enable mod perl',
#		   data=>0);
    $self->AddItem(name=>'TZ',
		   type=>'string',
		   comment=>($ja)? 'ॾ' : 'time zone',
		   data=>$TDS::System::TZ);
    $self->AddItem(name=>'TDS_Root',
		   type=>'absolute_path',
		   comment=>($ja)? 'TDS 롼ȥǥ쥯ȥ' : 'TDS root dir',
		   unshow=>1,
		   data=>$TDS::System::TDS_Root);

    # Ŀ
    $self->AddItem(name=>'Title',
		   type=>'string',
		   class=>'TDS::IdentInfo',
		   data=>TDS::IdentInfo->Get('title'),
		   unsave=>1,
		   comment=>($ja)? 'ȥ' : 'title of diary');
    $self->AddItem(name=>'AuthorName',
		   type=>'string',
		   class=>'TDS::IdentInfo',
		   data=>TDS::IdentInfo->Get('author'),
		   unsave=>1,
		   comment=>($ja)? '̾' : 'author name');
    $self->AddItem(name=>'MailAddress',
		   type=>'mailaddress',
		   class=>'TDS::IdentInfo',
		   unsave=>1,
		   data=>TDS::IdentInfo->Get('address'),
		   comment=>($ja)? '᡼륢ɥ쥹' : 'mail address');
    $self->AddItem(name=>'DiaryURL',
		   type=>'string',
		   class=>'TDS::IdentInfo',
		   data=>TDS::IdentInfo->Get('url'),
		   unsave=>1,
		   comment=>($ja)? ' URL' : 'URL of diary');
    $self->AddItem(name=>'_WebDiaryDir',        # ѻߤ줿
		   type=>'absolute_path',
		   data=>$ENV{'HOME'} . "/public_html/diary",
		   unshow=>1,
		   unsave=>1,
		   comment=>($ja)? 'web ǥǥ쥯ȥ' : "web diary dir",
		   comment2=>"must be absolute path");
    $self->AddItem(name=>'WebDiaryDir',
		   type=>'absolute_path',
		   data=>$TDS::DirInfo::WebDiaryDir,
		   class=>'TDS::DirInfo',
		   comment=>($ja)? 'web ǥǥ쥯ȥ' : "web diary dir",
		   comment2=>"must be absolute path");
    $self->AddItem(name=>'CustomizeDir',
		   type=>'absolute_path',
		   data=>$TDS::DirInfo::CustomizeDir,
		   class=>'TDS::DirInfo',
		   comment=>($ja)? 'ޥեѥǥ쥯ȥ' : "customize dir");
    $self->AddItem(name=>'DiaryDir',
		   type=>'absolute_path',
		   class=>'TDS::DirInfo',
		   #type=>'path',
		   data=>$TDS::DirInfo::DiaryDir,
		   comment=>($ja)? 'ե֤ǥ쥯ȥ' : 'diary dir',
		   comment2=>'base dir is web diary dir.');
    $self->AddItem(name=>'_UseSharedLibrary',
		   type=>'bool',
		   comment=>($ja)? '饤֥궦ͭ򤹤뤫' : "use shared library",
		   data=>1);
    $self->AddItem(name=>'_LibDir',
		   unshow=>1,
		   type=>'absolute_path');
		   
    # ⡼
    # ߴΤ
    $self->AddItem(name=>'StaticMode',
		   type=>'bool',
		   unshow=>1,
		   unsave=>1,
		   comment=>($ja)? 'Ū⡼ɤѤ뤫' : 'static mode on ?',
		   data=>$TDS::System::StaticMode);
    $self->AddItem(name=>'Mode',
		   type=>'select',
		   class=>'TDS::Mode',
		   options=>['static', 'dynamic'],
		   data=>$TDS::Mode::Mode,
		   comment=>($ja)? 'ư⡼' : 'mode');
    
    $self->AddItem(name=>'EnableAccessLog',
		   type=>'bool',
		   data=>$TDS::AccessLog::EnableAccessLog,
		   class=>'TDS::AccessLog',
		   comment=>($ja)? '뤫' : 'enable accesslog');
    
    $self->AddItem(name=>'EnableCookie',
		   type=>'bool',
		   data=>$TDS::Cookie::Enable,
		   class=>'TDS::Cookie',
		   comment=>($ja)? 'å򿩤٤' : 'enable cookie');
    $self->AddItem(name=>'EnableCache',
		   type=>'bool',
		   data=>$TDS::Cache::EnableCache,
		   class=>'TDS::Cache',
		   comment=>($ja)? 'å嵡ǽȤ' : 'enable cache');

    # install option
    $self->AddItem(name=>'_HtaccessEnable',
		   type=>'bool',
		   data=>1,
		   unshow=>1,
		   comment=>($ja)? '.htaccess Ѳǽ' : '.htaccess enable');
    $self->AddItem(name=>'_HtaccessOverwrite',
		   type=>'bool',
		   data=>1,
		   unshow=>1,
		   comment=>($ja)? '.htaccess 񤭤뤫' : 'overwrite .htaccess');
    $self->AddItem(name=>'_UpdateStyles',
		   type=>'bool',
		   data=>1,
		   unshow=>1,
		   comment=>($ja)? '뷲򹹿뤫' : 'update styles/');
    $self->AddItem(name=>'_UpdateMakefile',
		   type=>'bool',
		   data=>1,
		   unshow=>1,
		   comment=>($ja)? 'Makefile 򹹿뤫' : 'update Makefile');
    $self->AddItem(name=>'_UpdateSkeltons',
		   type=>'bool',
		   data=>1,
		   unshow=>1,
		   comment=>($ja)? 'ȥ(template.ph, *skelton.html)򹹿뤫' : 'update skeltons(template.ph, *skelton.html)');

    $self->AddItem(name=>'_UpdateUserAgentConf',
		   type=>'bool',
		   data=>1,
		   unshow=>1,
		   comment=>($ja)? 'user agent ե򹹿뤫':  'update user agent config file');


    $self->AddItem(name=>'_ClearCache',
		   type=>'bool',
		   data=>1,
		   unshow=>1,
		   comment=>($ja)? 'å򥯥ꥢ뤫':  'clear cache');

#    $self->AddItem(name=>'_UseHinaDi',
#		   type=>'bool',
#		   data=>1,
#		   unshow=>1,
#		   comment=>($ja)? 'hina.di Ȥ' : 'use hina.di');

    unless ($self->as_user_setup){
	$self->GetItem("_UseSharedLibrary")->unshow(1);
    }
    
    # ɤ߹
    $self->LoadSetup($self->readonly_setupfile)
	unless $self->unload_setupfile;

    # ߴΤ
    unless ($self->Get('WebDiaryDir')){
	$self->Set('WebDiaryDir', $self->Get('_WebDiaryDir'));
    }
    if (!$self->first_install &&
	!$self->GetItem('CustomizeDir')->loaded){
	$self->Set('CustomizeDir', $self->Get('WebDiaryDir'));
    }
    for ('Title', 'AuthorName', 'MailAddress', 'DiaryURL'){
	$self->GetItem($_)->unshow(1)
	    if $self->GetItem($_)->loaded;
    }
    unless ($self->GetItem('Mode')->loaded){
	$self->Set('Mode', ($self->Get('StaticMode')) ? 'static' : 'dynamic');
    }
    # for site installation
    if ($self->as_user_setup){
	print STDERR "* site setup mode: read site-conf.ph\n";
	require 'site_conf.ph';
	for (qw(PerlPath SendmailPath CanUseCGI CanUseSSI TZ TDS_Root)){
	    my $var = "TDS::System::$_";
	    $self->Set($_, $$var);
	    $self->GetItem($_)->comment("! " . $self->GetItem($_)->comment);
	}
    } else {
	# reset TDS_Root for judgement site install or not
	$self->Set("TDS_Root", "");
    }
}

sub QuestionToUser ($)
{
    my $self = shift;
    
    while (!$self->Confirm){
	# 
	unless ($self->as_user_setup){
	    print "* Site Setting *\n";
	    $self->Input('PerlPath');
	    $self->Input('SendmailPath');
	    if ($self->Input('CanUseCGI')){
		$self->Input('CanUseSSI');
	    } else {
		$self->Attention("SSI is disable");
		$self->Set('CanUseSSI', 0);
	    }
	    $self->Input('TZ');
	}
	
	print "* Base Setting:\n";
	if ($self->first_install){
	    $self->Input('Title');
	    $self->Input('AuthorName');
	    $self->Input('MailAddress');
	    $self->Input('DiaryURL');
	}
	$self->Input('WebDiaryDir');
#	if (!$self->first_install &&
#	    !$self->GetItem('CustomizeDir')->loaded){
#	    $self->GetItem('CustomizeDir')->data($self->GetItem('WebDiaryDir')->data);
#	}
	$self->Input('DiaryDir');
	if ($self->first_install){
	    $self->GetItem('CustomizeDir')->data($self->GetItem('DiaryDir')->data . "/custom");
	}
	$self->Input('CustomizeDir');
	
	# 饤֥
	if ($self->as_user_setup){
	    $self->Input('_UseSharedLibrary');
	}
	# ŪưŪ
	print "* Mode Setting:\n";
	if ($self->Get('CanUseCGI')){
	    $self->Input('Mode');
	} else {                                   # CGI ǽ
	    $self->Attention("static mode selected");
	    $self->Set('Mode', 'static');
	}
	
	# 
	print "* Log, Cookie, Cache Setting:\n";
	if ($self->Get('Mode') eq 'dynamic' || # ưŪʤϤȤ
	    $self->Get('CanUseSSI')){    # Ū⡼ɤʤ SSI Ȥʤ㤤ʤ
	    if ($self->Input('EnableAccessLog')){
#		$self->Input('TDS::AccessLog::DirInfo::LogDir');
	    }
	    $self->Input('EnableCookie');
	} else {
	    $self->Attention("access log and cookie is disable.");
	    $self->Set('EnableAccessLog', 0);
	    $self->Set('EnableCookie', 0);
	}
	# cache
	$self->Input('EnableCache');
    }
    # libdir
    {
	my $wddlib = ($self->GetItem('WebDiaryDir')->data) . "/lib";
	if ($self->as_user_setup){
	    if ($self->GetItem('_UseSharedLibrary')->data){
		$self->GetItem('_LibDir')->data("$TDS::System::TDS_Root/web_diary_dir/lib");
	    } else {
		$self->GetItem('_LibDir')->data($wddlib);
	    }
	} else {
	    $self->GetItem('_LibDir')->data($wddlib);
	}
    }
    $self->SaveSetup
	unless $self->unload_setupfile;
    
    }

sub DoInstall($)
{
    my $self = shift;

    # start installation
    my $orig_dir = ($0 =~ m%(.*)/.*$%)[0] || ".";
    
    $Installer::PerlPath = $self->Get('PerlPath');
    my $orig_webdir = "$orig_dir/web_diary_dir";
    my $install_webdir = $self->Get('WebDiaryDir');
    my $orig_diarydir = "$orig_dir/diary_dir";
    my $install_diarydir = $self->Get('DiaryDir');
    if ($install_diarydir !~ m!^/! &&         # Хѥ
	$install_diarydir !~ m!^[a-z]:!i){
	$install_diarydir = "$install_webdir/$install_diarydir"; # $install_webdir Хѥ
    }
    $self->Set('DiaryDir', $install_diarydir);
    
    my $install_cusdir = FileSpec->rel2abs($self->Get('CustomizeDir'),
					   $install_webdir);
    my $orig_cusdir = "$orig_diarydir/custom";

    print "* installing...\n";
    print "$orig_webdir -> $install_webdir\n";
    print "$orig_diarydir -> $install_diarydir\n";
    print "$orig_cusdir -> $install_cusdir\n";
    ################
    # WEB_DIARY_DIR 
    {
	# 饤֥Υ󥹥ȡ
	print "install library...\n";

	if ($self->as_user_setup){       # ͭĶ
#	    $Installer::LibDir = $Installer::DefaultLibDir;    # ⤵ʤ
	    if ($self->Get('_UseSharedLibrary')){
		# Ť lib/ ĤäƤȡ˸ƤޤΤǾõ
		print " remove old lib/...\n";
		rmtree("$install_webdir/lib");
		$Installer::LibDir ="$TDS::System::TDS_Root/web_diary_dir/lib";
	    } else {
		$self->InstallDir("$orig_webdir/lib", "$install_webdir/lib", "FORCE");
		$Installer::LibDir = "$install_webdir/lib";
	    }
	} else {
	    $self->InstallDir("$orig_webdir/lib", "$install_webdir/lib", "FORCE");
	}
		
	# CGI, SSI Υ󥹥ȡ
	print "install script...\n";
	if (! -f "$install_webdir/Makefile" ||
	    $self->Input("_UpdateMakefile")){
	    $self->InstallFile("$orig_webdir/Makefile", $install_webdir, "BACKUP");
	} else {
	    print "$orig_webdir/Makefile: skipped\n";
	}

	if ($self->Get('Mode') eq 'static'){
	    $self->InstallCGI("$orig_webdir/static.pl", $install_webdir, 'FORCE');
	    
	    if ($self->Get('CanUseSSI')){
		# Ū⡼ɤǡSSI ͭλΤ߻Ȥ
		$self->InstallCGI(["$orig_webdir/counter.cgi",
				   "$orig_webdir/set-cookie.cgi",
				   "$orig_webdir/comment_show.cgi",
				   "$orig_webdir/comment_name.cgi"
				   ],
				  $install_webdir);
	    }
	}
	$self->InstallCGI(["$orig_webdir/split.pl",
			   "$orig_webdir/secure.pl"], $install_webdir);
	
	# CGI ͭʤȤ
	if ($self->Get('CanUseCGI')){
	    $self->InstallCGI(["$orig_webdir/TsDiary.cgi",
			       "$orig_webdir/summary.cgi",
			       "$orig_webdir/url.cgi",
			       "$orig_webdir/dictionary.cgi",
			       "$orig_webdir/title.cgi",
			       "$orig_webdir/search.cgi",
			       "$orig_webdir/power.cgi",
			       "$orig_webdir/update_sig.pl",
			       "$orig_webdir/comment.cgi"],
			      $install_webdir);
	    # admin tools
	    mkdir("$install_webdir/admin", 0755);
	    $self->InstallCGI(["$orig_webdir/admin/expire_cache.cgi",
			       "$orig_webdir/admin/editor.cgi",
			       "$orig_webdir/admin/customizer.cgi",
			       "$orig_webdir/admin/tdf_editor.cgi",
			       "$orig_webdir/admin/skelton_editor.cgi",
			       "$orig_webdir/admin/log.cgi",
			       "$orig_webdir/admin/update_log.cgi",
			       "$orig_webdir/admin/clear_log.cgi",
			       "$orig_webdir/admin/add_author_id.cgi",
			       "$orig_webdir/admin/comment.cgi",
			       "$orig_webdir/admin/refresh_counter.cgi"],
			      "$install_webdir/admin");
	    $self->InstallFile(["$orig_webdir/admin/index.html",
				"$orig_webdir/admin/editor_skelton.html",
				"$orig_webdir/admin/log_skelton.html",
				"$orig_webdir/admin/update_log_skelton.html"],
			       "$install_webdir/admin", "CONFIRM");
	}
	$self->InstallCGI(["$orig_webdir/mkpasswd.pl"],
			  $install_webdir);

	# å
	# EnableAccessLog ˴ؤ餺 log/ 뤳Ȥ
	my $perm = 0777;
	{
	    my $logdir = $TDS::AccessLog::DirInfo::LogDir;
	    if ($logdir !~ m!^/! &&
		$logdir !~ m![A-Za-z]:!){
		$logdir = "$install_webdir/$logdir";
	    }
	    print "creating log dir($logdir)...\n";
	    makedir("$logdir", $perm);
	    chmod($perm, "$logdir");
#	    # LastModified ե
#	    my $lm_file = "$logdir/LastModified";
#	    touch($lm_file, 0666);
	    # .htaccess
	    if ($self->Get('_HtaccessEnable')){
		open(F, ">$logdir/.htaccess") || die "can't write to log/.htaccess";
		print F "deny from all\n";
		close F;
	    }
	}
	if ($self->Get('EnableCache')){
	    print "cache dir...\n";
	    if ($self->Get('CanUseCGI')){
		my $dir = FileSpec->rel2abs($TDS::Cache::DirInfo::DynamicCacheDir,
					    $install_webdir);
		$self->clear_cachedir($dir, $perm);
	    }
	    if ($self->Get('Mode') eq 'static'){
		my $dir = FileSpec->rel2abs($TDS::Cache::DirInfo::StaticCacheDir,
					    $install_webdir);
		$self->clear_cachedir($dir, $perm);
	    }
	}
	# ̤ɬפʤ
	# customize.pl
	$self->InstallCGI("$orig_webdir/customize.pl", $install_webdir);

	# upload.pl
	#$self->InstallFile("$orig_webdir/upload.pl", $install_webdir, 'EXIST');
	
	# .htaccess
	if (-f "$install_webdir/.htaccess" ||
	    $self->Input("_HtaccessEnable")){
	    my $write_flg;
	    if ( ! -f "$install_webdir/.htaccess"){    # ̵
		$write_flg = 1;
	    } else {                           # 
		if ($self->Input("_HtaccessOverwrite")){
		    # Хååפ
		    copy("$install_webdir/.htaccess", "$install_webdir/.htaccess-bak");
		    $write_flg = 1;
		} else {
		    $write_flg = 0;
		}
	    }
	    if ($write_flg){
		open(F, ">$install_webdir/.htaccess") || die "can't write $install_webdir/.htaccess";
		if ($self->Get('Mode') eq 'static'){
		    print F "DirectoryIndex index.html\n";
		    if ($self->Get('CanUseSSI')){
			print F "AddHandler server-parsed .html\n";
		    }
		} else {
		    print F "DirectoryIndex TsDiary.cgi index.html\n";
		}
		print F '# for l-m header in static + SSI
#XBitHack full
<Files ~ "*.tdf">
  deny from all
</Files>

<Files ~ "*.ph">
  deny from all
</Files>
';
		close F;
	    }
	}

	# images directory
 	$self->InstallDir("$orig_webdir/image", "$install_webdir/image", 'FORCE');

	# contrib
	$self->InstallDir("contrib", "$install_webdir/contrib", 'FORCE');
	
	# update conf.ph
	my $footer = "\$TDS::SetupedVersion = qq($TDS::Version);\n1;\n";


	$self->WritePerlHeader("$install_webdir/conf.ph", "TDS::System",
			       $footer, 'variable');

	# style samples
	print "style sample..\n";
	unless (-d "$install_webdir/styles"){
	    $self->InstallDir("$orig_webdir/styles", "$install_webdir/styles", 'FORCE');
	} else {
	    if (! -d "$install_webdir/styles" ||
		$self->Input("_UpdateStyles")){
		$self->InstallDir("$orig_webdir/styles", "$install_webdir/styles", 'BACKUP');
	    }
	}
    }
    ################
    # Customizeirir
    {
	# customize.ph
#	$self->InstallFile("$orig_cusdir/customize.ph", $install_cusdir, 'EXIST');
	
	# ե
	#  ե뤬¸ߤХǥե NO
	print "install skelton file...\n";
	if (! -f "$install_cusdir/skelton.html" ||
	    $self->Input("_UpdateSkeltons")){
	    $self->InstallFile("$orig_cusdir/template.ph", $install_cusdir, "BACKUP");
	    $self->InstallFile(["$orig_cusdir/skelton.html",
				"$orig_cusdir/summary_skelton.html",
				"$orig_cusdir/url_skelton.html",
				"$orig_cusdir/dictionary_skelton.html"],
			       $install_cusdir, "BACKUP");
	}
	# style samples
#	print "style sample..\n";
#	unless (-d "$install_cusdir/styles"){
#	    $self->InstallDir("$orig_cusdir/styles", "$install_cusdir/styles", 'FORCE');
#	} else {
#	    if (! -d "$install_cusdir/styles" ||
#		$self->Input("_UpdateStyles")){
#		$self->InstallDir("$orig_cusdir/styles", "$install_cusdir/styles", 'BACKUP');
#	    }
#	}
    }

    ################
    # DIARY_DIR
    {
	print "install sample diary file...\n";
	# create diary dir
	mkpath($install_diarydir, 0, 0755);
	
	# tdf sample
	my $date = new DateTime::Date;
	$date->SetTime($^T);
	my $tdfymdir = sprintf("$install_diarydir/%04d/%02d",
			       $date->year, $date->month);
	# if not exists, create dir and copy
	unless (-d $tdfymdir){
	    makedir($tdfymdir, 0755);
	    $self->InstallFile("$orig_dir/samples/tdf/01.tdf", $tdfymdir, 'EXIST');
	}
	# datafiles
	print "install data files...\n";
	$self->InstallDir("$orig_diarydir/dat", "$install_diarydir/dat", 'EXIST');
	
	# configfiles
	print "install config files...\n";
	$self->InstallFile("$orig_diarydir/conf/author_id.txt",
			   "$install_diarydir/conf",
			   "EXIST");

	if (! -f "$install_diarydir/conf/user_agent.conf" ||
	    $self->Input('_UpdateUserAgentConf')){
	    $self->InstallFile("$orig_diarydir/conf/user_agent.conf",
			       "$install_diarydir/conf",
			       "BACKUP");
	}
	# password
	my $password_file = "$install_diarydir/conf/.passwd";
	if (! -f $password_file && !$self->yes){
	    print "input password:\n";
	    my $pswd = new Password(filename=>$password_file);
	    if ($pswd->IsSupportNoecho){
		$pswd->ChangePassword;
	    }
	}

	# .htaccess
	open(F, ">$install_diarydir/.htaccess") || die "can't write $install_diarydir/.htaccess";
	print F "deny from all\n";
	close F;
    }
    $self->SaveSetup
	unless $self->unload_setupfile;
    $self->UpdateCustomize;
    if ($self->ja){
	print "### 󥹥ȡ뤬˽λޤ. \###\n";
	print "TDS ĺޤȤˤ꤬Ȥޤ

ޥԤϡ

 % cd $install_webdir
 % perl customize.pl

ȼ¹ԤƤ

Ѥˤʤޤ顢Ȥ⥢󥱡ȥڡ (${TDS::TDSHomePage}enquate.html) ˥
ȯߤˤʤޤ ^^)
";
    } else {
	print "### installation succeeded. \###\n";
	print "thank you for using TDS.

if you want to customize,
do

 % cd $install_webdir
 % perl customize.pl

please access tds enquate page (${TDS::TDSHomePage}enquate.html),
and let me know your answer.
it encourages me very much ^^)
";
    }
}

sub UpdateCustomize($)
{
    my $self = shift;

    my $cus_dir = FileSpec->rel2abs($self->GetItem('CustomizeDir')->data,
				    $self->GetItem('WebDiaryDir')->data);

    my $filename = "$cus_dir/customize.ph";
    print "update $filename\n";
    my $cust = new TDS::Customizer;
    $cust->filename($filename);
    $cust->Read;
    unless (-f $filename){
	# set identinfo
	$cust->GetItem('TDS::IdentInfo::Title')->data($self->Get('Title'));
	$cust->GetItem('TDS::IdentInfo::AuthorName')->data($self->Get('AuthorName'));
	$cust->GetItem('TDS::IdentInfo::MailAddress')->data($self->Get('MailAddress'));
	$cust->GetItem('TDS::IdentInfo::DiaryURL')->data($self->Get('DiaryURL'));
    }
#    $cust->Save;
    $cust->Customizer::Base::WriteToFile($cust->AsOutput);
}
sub clear_cachedir($$$)
{
    my ($self, $cachedir, $perm) = @_;
    
    # if cache files are exist, then clear them
    if (-d $cachedir &&
	$self->Input('_ClearCache')){
	print "clear cache...\n";
	opendir(DIR, $cachedir);
	my $file;
	while ($file = readdir(DIR)){
	    if (-f "$cachedir/$file"){
		unlink("$cachedir/$file") || warn "cannot clear cache: $cachedir/$file";
	    }
	}
	closedir(DIR);
    }
    # create and change mode
    makedir("$cachedir", $perm);
    chmod($perm, "$cachedir");    # may be not need...
}

1;
