/*
 * Decompiled with CFR 0.152.
 */
package bref;

import blbutil.Const;
import blbutil.InputIt;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import bref.AsIsBref3Writer;
import bref.BrefWriter;
import bref.CompressBref3Writer;
import java.io.File;
import vcf.RefGTRec;
import vcf.RefIt;
import vcf.Samples;

public class Bref3 {
    private static final String program = "bref3.21Apr21.304.jar";

    public static void main(String[] stringArray) {
        if (stringArray.length > 2) {
            System.out.println(Bref3.usage());
            System.exit(0);
        }
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("help")) {
            System.out.println(Bref3.usage());
            System.exit(0);
        }
        boolean bl = Bref3.useStdIn(stringArray);
        int n = -1;
        if (stringArray.length == 2 || bl && stringArray.length == 1) {
            n = Bref3.maxNSeq(stringArray[stringArray.length - 1]);
        }
        String string = bl ? null : stringArray[0];
        Bref3.writeBref(string, n);
    }

    private static boolean useStdIn(String[] stringArray) {
        if (stringArray.length == 0) {
            return true;
        }
        if (stringArray.length == 1) {
            return !(stringArray[0].endsWith(".vcf") || stringArray[0].endsWith(".vcf.gz"));
        }
        return false;
    }

    private static int maxNSeq(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
            if (n < 1 || n > 65535) {
                Bref3.exit("Error: invalid <nSeq> " + string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Bref3.exit("Error: <nSeq> is not a parsable integer: " + string);
        }
        return n;
    }

    private static void exit(String string) {
        System.out.println(Bref3.usage());
        Utilities.exit(string);
    }

    private static void writeBref(String string, int n) {
        try (SampleFileIt<RefGTRec> sampleFileIt = Bref3.refIt(string);
             BrefWriter brefWriter = Bref3.brefOut(sampleFileIt.samples(), n);){
            while (sampleFileIt.hasNext()) {
                brefWriter.write((RefGTRec)sampleFileIt.next());
            }
        }
    }

    private static SampleFileIt<RefGTRec> refIt(String string) {
        InputIt inputIt = null;
        inputIt = string == null ? InputIt.fromStdIn() : (string.endsWith(".gz") ? InputIt.fromGzipFile(new File(string)) : InputIt.fromTextFile(new File(string)));
        return RefIt.create(inputIt);
    }

    private static BrefWriter brefOut(Samples samples, int n) {
        File file = null;
        if (n < 0) {
            return new AsIsBref3Writer(program, samples, file);
        }
        return new CompressBref3Writer(program, samples, n, file);
    }

    private static String usage() {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("usage:");
        stringBuilder.append(Const.nl);
        stringBuilder.append("  java -jar ");
        stringBuilder.append(program);
        stringBuilder.append(" help");
        stringBuilder.append(Const.nl);
        stringBuilder.append(Const.nl);
        stringBuilder.append("  java -jar ");
        stringBuilder.append(program);
        stringBuilder.append(" [vcf] <nseq>  > [bref3]");
        stringBuilder.append(Const.nl);
        stringBuilder.append(Const.nl);
        stringBuilder.append("  cat   [vcf]   | java -jar ");
        stringBuilder.append(program);
        stringBuilder.append(" <nseq>  > [bref3]");
        stringBuilder.append(Const.nl);
        stringBuilder.append(Const.nl);
        stringBuilder.append("where");
        stringBuilder.append(Const.nl);
        stringBuilder.append("  [bref3]  = the output bref3 file");
        stringBuilder.append(Const.nl);
        stringBuilder.append("  [vcf]    = A VCF file with phased, non-missing genotype data.  If the");
        stringBuilder.append(Const.nl);
        stringBuilder.append("             file is gzip-compressed, its filename must end in \".gz\"");
        stringBuilder.append(Const.nl);
        stringBuilder.append("             and \"cat\" must be replaced with \"zcat\"");
        stringBuilder.append(Const.nl);
        stringBuilder.append("  <nseq>   = optional argument for maximum number of unique sequences");
        stringBuilder.append(Const.nl);
        stringBuilder.append("             in a bref3 block. If there are N reference samples,");
        stringBuilder.append(Const.nl);
        stringBuilder.append("             the default value is: <max-seq>=2^(2*log10(N) + 1)");
        stringBuilder.append(Const.nl);
        return stringBuilder.toString();
    }
}

