proc mail`comment_bug {type} {
  global module __language
  
  set w [makeTempWindow "Mail $type"]

  label $w.label -text [langExp %s $type $__language(mail,1)]
  checkbutton $w.dotfile -text \
    "$__language(mail,3) (blackie@imada.sdu.dk)" \
    -variable __mail(dotfile)
  if {[info exists module(email)]} {
    checkbutton $w.module -text \
      "[langExp %s $module(name) $__language(mail,4)] ($module(email))" \
      -variable __mail(module)
  } else {
    checkbutton $w.module -text \
      "$module(name) $__language(mail,4)" -variable __mail(module)
  }
  text $w.text -width 50 -height 15 -wrap word

  if {![info exists module(email)]} {
    $w.module configure -state disabled
  }
  frame $w.buts
  button $w.buts.mail   -text $__language(mail,10)  -command "mail`mail1 {$type} $w"
  button $w.buts.cancel -text $__language(cancel) -command "destroy $w"

  pack $w.label $w.dotfile $w.module -anchor w
  pack $w.text -anchor w -fill both -expand 1
  pack $w.buts -anchor w
  pack $w.buts.mail $w.buts.cancel -side left
}

proc mail`postcard {} {
  global __postcard argv __language
  catch "unset __postcard"
  set modules [myGlob [file dirname [lindex $argv 0]]/english/*]
  
  set w [makeTempWindow $__language(mail,5)]

  label $w.desc -text $__language(mail,6) \
    -wraplength 600 -justify l
  pack $w.desc

    checkbutton $w.newversion -text $__language(mail,7) \
    -variable __postcard(newversion)
  pack $w.newversion -anchor w 
    
  pack [frame $w.line  -height 0.1c -relief sunken -bd 1] -fill x -expand 1 -pady 3

  pack [label $w.label -text $__language(mail,8) -anchor w] 
  pack [frame $w.modules] -fill x
  for {set i 0} {$i < 4} {incr i} {
    pack [frame $w.modules.$i] -side left -fill x -expand 1
  }

  set i 0
  foreach module $modules {
    if {![file isdirectory $module] || ![file exists $module/main.template]} continue
    set module [file tail $module]
    if {$module == "Generator"} continue
    if {$module == "demo"} continue
    
    checkbutton $w.modules.[expr $i % 3].$i -text $module \
      -variable __postcard($module) -anchor w
    pack $w.modules.[expr $i % 3].$i -fill x
    incr i
  }

  pack [label $w.com -text $__language(mail,9)]
  pack [text $w.text -width 50 -height 15 -wrap word] -fill both -expand 1

  frame $w.buts
  button $w.buts.mail   -text $__language(mail,10)   -command "mail`mail2 $w"
  button $w.buts.cancel -text $__language(cancel) -command "destroy $w"
  pack $w.buts -anchor w
  pack $w.buts.mail $w.buts.cancel -side left
}

  
proc mail`mail1 {type w} {
  global __mail module
  set text [$w.text get 1.0 end]
  set text "This mail is send from the $module(name) module:\n$text"
  if {$__mail(dotfile)} {
    mail`mailIt $type blackie@imada.sdu.dk $text
  }
  if {$__mail(module)} {
    if {!($__mail(dotfile) && $module(email) == "blackie@imada.sdu.dk")} {
      mail`mailIt $type $module(email) $text
    }
  }
  destroy $w
}

proc mail`mail2 {w} {
  global __postcard
  set text ""
  foreach mod [array names __postcard] {
    if {$mod=="newversion"} continue
    if {$__postcard($mod)} {
      append text "I use $mod\n"
    }
  }
  append text \n\n
  append text [$w.text get 1.0 end]
  if {$__postcard(newversion)} {
    append text "\nPlease send me info about new versions"
  }
  mail`mailIt "Use it" blackie@imada.sdu.dk $text
  destroy $w
}

proc mail`mailIt {type to message} {
  global env __system __language
  if {$__system(mail) == ""} {
    set w [makeTempWindow "Mail"]
    label $w.label -text $__language(mail,11) -anchor w -justify left

    label $w.to -text "$__language(mail,12):" -anchor w
    entry $w.toWho
    $w.toWho insert insert $to
    
    label $w.subject -text "$__language(mail,13):" -anchor w
    entry $w.sub 
    $w.sub insert insert "TDG - $type" 

    label $w.content -text "$__language(mail,14):" -anchor w
    frame $w.text
    text  $w.text.cont -width 50 -height 10 -yscrollcommand "$w.text.scroll set"
    scrollbar $w.text.scroll -command "$w.text.cont yview"
    $w.text.cont insert insert $message

    pack $w.label $w.to -anchor w
    pack $w.toWho -padx 20 -anchor w -expand 1 -fill x
    pack $w.subject -anchor w
    pack $w.sub -padx 20 -anchor w -expand 1 -fill x
    pack $w.content -anchor w
    pack $w.text -padx 20
    pack $w.text.cont $w.text.scroll -side left -fill y -expand 1

    button $w.close -text $__language(mail,15) -command "destroy $w" 
    pack $w.close
  } else {
    set MAIL [open "|$__system(mail) $to" w]
    puts $MAIL "TDG - $type"
    puts $MAIL $message
    close $MAIL
  }
}
