/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.annotations.VisibleForTesting;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Log;
import java.util.Locale;
import java.util.function.Function;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GeneralDataSpec;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblemSpec;

@ClientCodeWrapper.Trusted
public class DiagnosticToProblemListener
implements DiagnosticListener<JavaFileObject> {
    public static final String FORMATTER_FALLBACK_MESSAGE = "Failed to format diagnostic message, falling back to default message formatting";
    private static final Logger LOGGER = Logging.getLogger(DiagnosticToProblemListener.class);
    private final InternalProblemReporter problemReporter;
    private final Context context;
    private final Function<Diagnostic<? extends JavaFileObject>, String> messageFormatter;
    private int errorCount = 0;
    private int warningCount = 0;

    DiagnosticToProblemListener(InternalProblemReporter problemReporter, Context context, Function<Diagnostic<? extends JavaFileObject>, String> messageFormatter) {
        this.problemReporter = problemReporter;
        this.context = context;
        this.messageFormatter = messageFormatter;
    }

    public DiagnosticToProblemListener(InternalProblemReporter problemReporter, Context context) {
        this.problemReporter = problemReporter;
        this.context = context;
        this.messageFormatter = diagnostic -> {
            try {
                DiagnosticFormatter<JCDiagnostic> formatter = Log.instance(context).getDiagnosticFormatter();
                return formatter.format((JCDiagnostic)diagnostic, JavacMessages.instance(context).getCurrentLocale());
            }
            catch (Exception ex) {
                LOGGER.info(FORMATTER_FALLBACK_MESSAGE);
                return diagnostic.getMessage(Locale.getDefault());
            }
        };
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        switch (diagnostic.getKind()) {
            case ERROR: {
                ++this.errorCount;
                break;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                ++this.warningCount;
                break;
            }
        }
        this.problemReporter.reporting(spec -> this.buildProblem(diagnostic, (ProblemSpec)spec));
    }

    void printDiagnosticCounts() {
        Log logger = Log.instance(new Context());
        DiagnosticToProblemListener.printDiagnosticCount(logger, "error", this.errorCount);
        DiagnosticToProblemListener.printDiagnosticCount(logger, "warn", this.warningCount);
    }

    private static void printDiagnosticCount(Log logger, String kind, int number) {
        if (!"error".equals(kind) && !"warn".equals(kind)) {
            throw new IllegalArgumentException("kind must be either 'error' or 'warn'");
        }
        if (number == 0) {
            return;
        }
        StringBuilder keyBuilder = new StringBuilder("count.");
        keyBuilder.append(kind);
        if (number > 1) {
            keyBuilder.append(".plural");
        }
        String localizedMessage = logger.localize(keyBuilder.toString(), number);
        System.err.println(localizedMessage);
    }

    @VisibleForTesting
    void buildProblem(Diagnostic<? extends JavaFileObject> diagnostic, ProblemSpec spec) {
        spec.id(DiagnosticToProblemListener.mapKindToId(diagnostic.getKind()), DiagnosticToProblemListener.mapKindToLabel(diagnostic.getKind()), GradleCoreProblemGroup.compilation().java());
        spec.severity(DiagnosticToProblemListener.mapKindToSeverity(diagnostic.getKind()));
        this.addFormattedMessage(spec, diagnostic);
        DiagnosticToProblemListener.addDetails(spec, diagnostic);
        DiagnosticToProblemListener.addLocations(spec, diagnostic);
    }

    private void addFormattedMessage(ProblemSpec spec, Diagnostic<? extends JavaFileObject> diagnostic) {
        String formatted = this.messageFormatter.apply(diagnostic);
        System.err.println(formatted);
        ((InternalProblemSpec)spec).additionalData(GeneralDataSpec.class, data -> data.put("formatted", formatted));
    }

    private static void addDetails(ProblemSpec spec, Diagnostic<? extends JavaFileObject> diagnostic) {
        String diagnosticMessage = diagnostic.getMessage(Locale.getDefault());
        if (diagnosticMessage != null) {
            spec.details(diagnosticMessage);
        }
    }

    private static void addLocations(ProblemSpec spec, Diagnostic<? extends JavaFileObject> diagnostic) {
        String resourceName = diagnostic.getSource() != null ? DiagnosticToProblemListener.getPath(diagnostic.getSource()) : null;
        int line = DiagnosticToProblemListener.clampLocation(diagnostic.getLineNumber());
        int column = DiagnosticToProblemListener.clampLocation(diagnostic.getColumnNumber());
        int position = DiagnosticToProblemListener.clampLocation(diagnostic.getPosition());
        int start = DiagnosticToProblemListener.clampLocation(diagnostic.getStartPosition());
        int end = DiagnosticToProblemListener.clampLocation(diagnostic.getEndPosition());
        if (resourceName != null) {
            spec.fileLocation(resourceName);
            if (0 < line) {
                if (0 < column) {
                    if (0 < position) {
                        spec.lineInFileLocation(resourceName, line, column, end - position);
                    } else {
                        spec.lineInFileLocation(resourceName, line, column);
                    }
                } else {
                    spec.lineInFileLocation(resourceName, line);
                }
            }
            if (0 < position) {
                spec.offsetInFileLocation(resourceName, position, end - position);
            }
        }
    }

    private static int clampLocation(long value) {
        if (value > Integer.MAX_VALUE) {
            return Math.toIntExact(-1L);
        }
        return (int)value;
    }

    private static String getPath(JavaFileObject fileObject) {
        return fileObject.getName();
    }

    private static String mapKindToId(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "java-compilation-error";
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return "java-compilation-warning";
            }
            case NOTE: {
                return "java-compilation-note";
            }
            case OTHER: {
                return "java-compilation-problem";
            }
        }
        return "unknown-java-compilation-problem";
    }

    private static String mapKindToLabel(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return "Java compilation error";
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return "Java compilation warning";
            }
            case NOTE: {
                return "Java compilation note";
            }
            case OTHER: {
                return "Java compilation problem";
            }
        }
        return "Unknown java compilation problem";
    }

    private static Severity mapKindToSeverity(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return Severity.ERROR;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return Severity.WARNING;
            }
        }
        return Severity.ADVICE;
    }
}

