/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.util.ParsingUtils;

public class BedPEUtils {
    public static void main(String[] args) throws IOException {
        BedPEUtils.juiceboxToBedPE(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interactionToBedPE(String ifile, String ofile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(ifile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = ParsingUtils.WHITESPACE_PATTERN.split(nextLine);
                if (tokens.length == 3) {
                    String[] t1 = tokens[0].split(":");
                    String chr1 = t1[0];
                    t1 = t1[1].split("-");
                    String start1 = t1[0];
                    String end1 = t1[1];
                    t1 = tokens[1].split(":");
                    String chr2 = t1[0];
                    t1 = t1[1].split("-");
                    String start2 = t1[0];
                    String end2 = t1[1];
                    String score = tokens[2];
                    String name = tokens[0] + "->" + tokens[1];
                    pw.println(chr1 + "\t" + start1 + "\t" + end1 + "\t" + chr2 + "\t" + start2 + "\t" + end2 + "\t" + name + "\t" + score);
                    continue;
                }
                System.out.println("Skipping line: " + nextLine);
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void juiceboxToBedPE(String ifile, String ofile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        try {
            String nextLine;
            br = new BufferedReader(new FileReader(ifile));
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            br.readLine();
            pw.println("#columns color=11;thickness=12");
            while ((nextLine = br.readLine()) != null) {
                if (nextLine.startsWith("#")) {
                    pw.println(nextLine);
                    continue;
                }
                String[] tokens = ParsingUtils.WHITESPACE_PATTERN.split(nextLine);
                if (tokens.length >= 6) {
                    int i;
                    for (i = 0; i < 6; ++i) {
                        pw.print(tokens[i] + "\t");
                    }
                    for (i = 0; i < 4; ++i) {
                        pw.print(".\t");
                    }
                    pw.println(tokens[6] + "\t2\t");
                    continue;
                }
                System.out.println("Skipping line: " + nextLine);
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    public static void packFeatures(List<BedPE> features, int maxRows) {
        int bucketStart;
        int gap = 2;
        int start = features.get(0).getStart();
        int end = features.get(features.size() - 1).getStart();
        int nextStart = bucketStart = start;
        HashMap bucketList = new HashMap();
        for (BedPE alignment : features) {
            int buckListIndex = Math.max(0, alignment.getStart() - bucketStart);
            if (bucketList.get(buckListIndex) == null) {
                bucketList.put(buckListIndex, new Stack());
            }
            ((Stack)bucketList.get(buckListIndex)).add(alignment);
        }
        int allocatedCount = 0;
        int lastAllocatedCount = -1;
        for (int row = 0; allocatedCount < features.size() && row <= maxRows; ++row) {
            while (nextStart <= end) {
                Stack bucket = null;
                int index = 0;
                while (bucket == null && nextStart <= end) {
                    index = nextStart - bucketStart;
                    if (bucketList.get(index) == null) {
                        ++nextStart;
                        continue;
                    }
                    bucket = (Stack)bucketList.get(index);
                }
                if (bucket == null) break;
                BedPE feature = (BedPE)bucket.pop();
                if (0 == bucket.size()) {
                    bucketList.remove(index);
                }
                feature.setRow(row);
                nextStart = feature.getEnd() + gap;
                ++allocatedCount;
            }
            nextStart = bucketStart;
            if (allocatedCount == lastAllocatedCount) break;
            lastAllocatedCount = allocatedCount;
        }
    }
}

