/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.I18n;
import free.jin.Jin;
import free.jin.Session;
import free.jin.plugin.Plugin;
import free.jin.plugin.PluginUIContainer;
import free.jin.plugin.PluginUIEvent;
import free.jin.plugin.PluginUIListener;
import free.jin.ui.OptionPanel;
import free.util.EventListenerList;
import free.util.RectDouble;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import javax.swing.JMenu;

public abstract class AbstractPluginUIContainer
implements PluginUIContainer {
    private final Plugin plugin;
    private final String id;
    private final int mode;
    private final EventListenerList listenerList = new EventListenerList();
    private String title;
    private Image icon;
    private int pluginMenuIndex = 0;

    public AbstractPluginUIContainer(Plugin plugin, String string, int n) {
        this.plugin = plugin;
        this.id = string;
        this.mode = n;
    }

    public final void dispose() {
        this.disposeImpl();
        this.firePluginUIEvent(new PluginUIEvent(this, 6));
    }

    protected abstract void disposeImpl();

    protected abstract void loadState();

    protected abstract void saveState();

    public Plugin getPlugin() {
        return this.plugin;
    }

    public final String getId() {
        return this.id;
    }

    public final int getMode() {
        return this.mode;
    }

    protected abstract void insertMenu(JMenu var1, int var2);

    protected abstract int getMenuCount();

    public void addMenu(JMenu jMenu) {
        this.insertMenu(jMenu, this.getMenuCount());
    }

    public void addGlobalMenu(JMenu jMenu) {
        this.insertMenu(jMenu, this.pluginMenuIndex);
        ++this.pluginMenuIndex;
    }

    protected RectDouble getInitialBounds(Container container, Dimension dimension) {
        String string = this.plugin.getId();
        if ("console".equals(string)) {
            if ("".equals(this.id)) {
                return new RectDouble(0.0, 0.0, 0.75, 0.75);
            }
        } else if ("seek".equals(string)) {
            if ("".equals(this.id)) {
                return new RectDouble(0.5, 0.5, 0.5, 0.5);
            }
        } else if ("board".equals(string)) {
            try {
                int n = Integer.parseInt(this.id);
                return new RectDouble(0.25, 0.05 * (double)(n % 6), 0.75, 0.75);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (container instanceof Frame && container.getPeer() == null) {
            ((Frame)container).pack();
        }
        Dimension dimension2 = container.getPreferredSize();
        double d = Math.min(dimension2.width, dimension.width);
        double d2 = Math.min(dimension2.height, dimension.height);
        double d3 = ((double)dimension.width - d) / 2.0;
        double d4 = ((double)dimension.height - d2) / 2.0;
        if ("actions".equals(string) && "".equals(this.id)) {
            d3 = (double)dimension.width - d;
            d4 = 0.0;
        }
        return new RectDouble(d3 / (double)dimension.width, d4 / (double)dimension.height, d / (double)dimension.width, d2 / (double)dimension.height);
    }

    public String getPrefsPrefix() {
        return "".equals(this.id) ? "" : this.id + ".";
    }

    public void addPluginUIListener(PluginUIListener pluginUIListener) {
        this.listenerList.add(PluginUIListener.class, pluginUIListener);
    }

    public void removePluginUIListener(PluginUIListener pluginUIListener) {
        this.listenerList.remove(PluginUIListener.class, pluginUIListener);
    }

    protected void firePluginUIEvent(PluginUIEvent pluginUIEvent) {
        PluginUIListener[] pluginUIListenerArray = (PluginUIListener[])this.listenerList.getListeners(PluginUIListener.class);
        for (int i = 0; i < pluginUIListenerArray.length; ++i) {
            PluginUIListener pluginUIListener = pluginUIListenerArray[i];
            pluginUIEvent.dispatch(pluginUIListener);
        }
    }

    protected void closeSession(Component component) {
        Object object = OptionPanel.OK;
        Session session = Jin.getInstance().getConnManager().getSession();
        if (session != null && session.isConnected()) {
            I18n i18n = I18n.get(AbstractPluginUIContainer.class);
            object = i18n.confirm(OptionPanel.OK, "closeSessionDialog", component);
        }
        if (object == OptionPanel.OK) {
            Jin.getInstance().getConnManager().closeSession();
        }
    }

    public final void setTitle(String string) {
        this.setTitleImpl(string);
        this.title = string;
        this.firePluginUIEvent(new PluginUIEvent(this, 7));
    }

    public final String getTitle() {
        return this.title;
    }

    protected abstract void setTitleImpl(String var1);

    public final void setIcon(Image image) {
        this.setIconImpl(image);
        this.icon = image;
        this.firePluginUIEvent(new PluginUIEvent(this, 8));
    }

    public final Image getIcon() {
        return this.icon;
    }

    protected abstract void setIconImpl(Image var1);
}

