/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board;

import free.jin.Connection;
import free.jin.Game;
import free.jin.I18n;
import free.jin.plugin.Plugin;
import free.util.swing.SwingUtils;
import free.workarounds.FixedJPanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class ExaminedGameButtonPanel
extends FixedJPanel
implements ActionListener {
    protected final Plugin plugin;
    protected final Game game;
    protected JButton startButton;
    protected JButton backwardButton;
    protected JButton forwardButton;
    protected JButton endButton;

    public ExaminedGameButtonPanel(Plugin plugin, Game game) {
        this.plugin = plugin;
        this.game = game;
        this.init(plugin, game);
    }

    protected void init(Plugin plugin, Game game) {
        this.createComponents(plugin, game);
        this.addComponents(plugin, game);
    }

    protected void createComponents(Plugin plugin, Game game) {
        this.startButton = this.createStartGameButton(plugin, game);
        this.backwardButton = this.createBackwardButton(plugin, game);
        this.forwardButton = this.createForwardButton(plugin, game);
        this.endButton = this.createEndGameButton(plugin, game);
    }

    protected JButton createButton(String string, String string2, KeyStroke keyStroke) {
        JButton jButton = new JButton();
        jButton.setToolTipText(I18n.get((Class)ExaminedGameButtonPanel.class).getString(string2));
        jButton.addActionListener(this);
        jButton.registerKeyboardAction(this, keyStroke, 2);
        jButton.setDefaultCapable(false);
        jButton.setRequestFocusEnabled(false);
        Class clazz = ExaminedGameButtonPanel.class;
        SwingUtils.makeIconButton((AbstractButton)jButton, (Icon)new ImageIcon(clazz.getResource("images/" + string + ".png")), (Icon)new ImageIcon(clazz.getResource("images/" + string + "-rollover.png")), (Icon)new ImageIcon(clazz.getResource("images/" + string + "-pressed.png")));
        return jButton;
    }

    protected JButton createStartGameButton(Plugin plugin, Game game) {
        return this.createButton("go-first", "gameStartButton.tooltip", KeyStroke.getKeyStroke(36, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    protected JButton createEndGameButton(Plugin plugin, Game game) {
        return this.createButton("go-last", "gameEndButton.tooltip", KeyStroke.getKeyStroke(35, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    protected JButton createBackwardButton(Plugin plugin, Game game) {
        return this.createButton("go-previous", "backwardButton.tooltip", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    protected JButton createForwardButton(Plugin plugin, Game game) {
        return this.createButton("go-next", "forwardButton.tooltip", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    protected void addComponents(Plugin plugin, Game game) {
        this.setLayout(new FlowLayout(1, 5, 5));
        this.add(this.startButton);
        this.add(this.backwardButton);
        this.add(this.forwardButton);
        this.add(this.endButton);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Connection connection = this.plugin.getConn();
        if (object == this.startButton) {
            connection.goToBeginning(this.game);
        } else if (object == this.endButton) {
            connection.goToEnd(this.game);
        } else if (object == this.forwardButton) {
            connection.goForward(this.game, 1);
        } else if (object == this.backwardButton) {
            connection.goBackward(this.game, 1);
        }
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

