/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.MethodResult;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class ClassTypeCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeSuperclass(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeSetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeInvokeMethod(byteBuffer, dataOutputStream);
                    break;
                }
                case 4: {
                    this.executeNewInstance(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in ClassType Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private final void executeSuperclass(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        Class clazz2 = clazz.getSuperclass();
        ReferenceTypeId referenceTypeId2 = this.idMan.getReferenceTypeId(clazz2);
        referenceTypeId2.write(dataOutputStream);
    }

    private final void executeSetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        int n = byteBuffer.getInt();
        int n2 = 0;
        while (n2 < n) {
            ObjectId objectId = this.idMan.readObjectId(byteBuffer);
            Field field = (Field)objectId.getObject();
            Object object = Value.getUntaggedObj(byteBuffer, field.getType());
            try {
                field.setAccessible(true);
                field.set(null, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidFieldException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JdwpInternalErrorException(illegalAccessException);
            }
            ++n2;
        }
    }

    private final void executeInvokeMethod(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        MethodResult methodResult = this.invokeMethod(byteBuffer);
        Object object = methodResult.getReturnedValue();
        Exception exception = methodResult.getThrownException();
        ObjectId objectId = this.idMan.getObjectId(exception);
        Value.writeTaggedValue(dataOutputStream, object);
        objectId.writeTagged(dataOutputStream);
    }

    private final void executeNewInstance(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        MethodResult methodResult = this.invokeMethod(byteBuffer);
        Object object = methodResult.getReturnedValue();
        ObjectId objectId = this.idMan.getObjectId(object);
        Exception exception = methodResult.getThrownException();
        ObjectId objectId2 = this.idMan.getObjectId(exception);
        objectId.writeTagged(dataOutputStream);
        objectId2.writeTagged(dataOutputStream);
    }

    private final MethodResult invokeMethod(ByteBuffer byteBuffer) throws JdwpException, IOException {
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Thread thread = (Thread)objectId.getObject();
        ObjectId objectId2 = this.idMan.readObjectId(byteBuffer);
        Method method = (Method)objectId2.getObject();
        int n = byteBuffer.getInt();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = Value.getObj(byteBuffer);
            ++n2;
        }
        n2 = byteBuffer.getInt();
        boolean bl = false;
        if ((n2 & 1) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        try {
            if (bl2) {
                VMVirtualMachine.suspendAllThreads();
            }
            MethodResult methodResult = VMVirtualMachine.executeMethod(null, thread, clazz, method, objectArray, false);
            if (bl2) {
                VMVirtualMachine.resumeAllThreads();
            }
            return methodResult;
        }
        catch (Exception exception) {
            if (bl2) {
                VMVirtualMachine.resumeAllThreads();
            }
            throw new JdwpInternalErrorException(exception);
        }
    }
}

