/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.EnumerationFacet;
import gnu.xml.validation.datatype.FractionDigitsFacet;
import gnu.xml.validation.datatype.LengthFacet;
import gnu.xml.validation.datatype.MaxExclusiveFacet;
import gnu.xml.validation.datatype.MaxInclusiveFacet;
import gnu.xml.validation.datatype.MaxLengthFacet;
import gnu.xml.validation.datatype.MinExclusiveFacet;
import gnu.xml.validation.datatype.MinInclusiveFacet;
import gnu.xml.validation.datatype.MinLengthFacet;
import gnu.xml.validation.datatype.PatternFacet;
import gnu.xml.validation.datatype.SimpleType;
import gnu.xml.validation.datatype.TotalDigitsFacet;
import gnu.xml.validation.datatype.WhiteSpaceFacet;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class TypeBuilder
implements DatatypeBuilder {
    final SimpleType type;

    public void addParameter(String string, String string2, ValidationContext validationContext) throws DatatypeException {
        if ("length".equals(string)) {
            this.type.facets.add(this.parseLengthFacet(string2));
        } else if ("minLength".equals(string)) {
            this.type.facets.add(this.parseMinLengthFacet(string2));
        } else if ("maxLength".equals(string)) {
            this.type.facets.add(this.parseMaxLengthFacet(string2));
        } else if ("pattern".equals(string)) {
            this.type.facets.add(this.parsePatternFacet(string2));
        } else if ("enumeration".equals(string)) {
            this.type.facets.add(this.parseEnumerationFacet(string2));
        } else if ("whiteSpace".equals(string)) {
            this.type.facets.add(this.parseWhiteSpaceFacet(string2));
        } else if ("maxInclusive".equals(string)) {
            this.type.facets.add(this.parseMaxInclusiveFacet(string2, validationContext));
        } else if ("maxExclusive".equals(string)) {
            this.type.facets.add(this.parseMaxExclusiveFacet(string2, validationContext));
        } else if ("minExclusive".equals(string)) {
            this.type.facets.add(this.parseMinExclusiveFacet(string2, validationContext));
        } else if ("minInclusive".equals(string)) {
            this.type.facets.add(this.parseMinInclusiveFacet(string2, validationContext));
        } else if ("totalDigits".equals(string)) {
            this.type.facets.add(this.parseTotalDigitsFacet(string2));
        } else if ("fractionDigits".equals(string)) {
            this.type.facets.add(this.parseFractionDigitsFacet(string2));
        }
    }

    LengthFacet parseLengthFacet(String string) throws DatatypeException {
        int n = string.indexOf(32);
        boolean bl = false;
        if (n != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n);
        }
        return new LengthFacet(Integer.parseInt(string), bl, null);
    }

    MinLengthFacet parseMinLengthFacet(String string) throws DatatypeException {
        int n = string.indexOf(32);
        boolean bl = false;
        if (n != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n);
        }
        return new MinLengthFacet(Integer.parseInt(string), bl, null);
    }

    MaxLengthFacet parseMaxLengthFacet(String string) throws DatatypeException {
        int n = string.indexOf(32);
        boolean bl = false;
        if (n != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n);
        }
        return new MaxLengthFacet(Integer.parseInt(string), bl, null);
    }

    PatternFacet parsePatternFacet(String string) throws DatatypeException {
        return new PatternFacet(Pattern.compile(string), null);
    }

    EnumerationFacet parseEnumerationFacet(String string) throws DatatypeException {
        return new EnumerationFacet(string, null);
    }

    WhiteSpaceFacet parseWhiteSpaceFacet(String string) throws DatatypeException {
        int n = string.indexOf(32);
        boolean bl = false;
        if (n != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n);
        }
        if ("preserve".equals(string)) {
            return new WhiteSpaceFacet(0, bl, null);
        }
        if ("replace".equals(string)) {
            return new WhiteSpaceFacet(1, bl, null);
        }
        if ("collapse".equals(string)) {
            return new WhiteSpaceFacet(2, bl, null);
        }
        throw new DatatypeException("argument must be preserve, replace, or collapse");
    }

    MaxInclusiveFacet parseMaxInclusiveFacet(String string, ValidationContext validationContext) throws DatatypeException {
        int n = string.indexOf(32);
        boolean bl = false;
        if (n != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n);
        }
        return new MaxInclusiveFacet(this.type.createValue(string, validationContext), bl, null);
    }

    MaxExclusiveFacet parseMaxExclusiveFacet(String string, ValidationContext validationContext) throws DatatypeException {
        int n = string.indexOf(32);
        boolean bl = false;
        if (n != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n);
        }
        return new MaxExclusiveFacet(this.type.createValue(string, validationContext), bl, null);
    }

    MinExclusiveFacet parseMinExclusiveFacet(String string, ValidationContext validationContext) throws DatatypeException {
        int n = string.indexOf(32);
        boolean bl = false;
        if (n != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n);
        }
        return new MinExclusiveFacet(this.type.createValue(string, validationContext), bl, null);
    }

    MinInclusiveFacet parseMinInclusiveFacet(String string, ValidationContext validationContext) throws DatatypeException {
        int n = string.indexOf(32);
        boolean bl = false;
        if (n != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n);
        }
        return new MinInclusiveFacet(this.type.createValue(string, validationContext), bl, null);
    }

    TotalDigitsFacet parseTotalDigitsFacet(String string) throws DatatypeException {
        int n;
        int n2 = string.indexOf(32);
        boolean bl = false;
        if (n2 != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n2 + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n2);
        }
        if ((n = Integer.parseInt(string)) < 0) {
            throw new DatatypeException("value must be a positiveInteger");
        }
        return new TotalDigitsFacet(n, bl, null);
    }

    FractionDigitsFacet parseFractionDigitsFacet(String string) throws DatatypeException {
        int n;
        int n2 = string.indexOf(32);
        boolean bl = false;
        if (n2 != -1) {
            if (!"FIXED".equalsIgnoreCase(string.substring(n2 + 1))) {
                throw new DatatypeException("second argument must be FIXED if present");
            }
            bl = true;
            string = string.substring(0, n2);
        }
        if ((n = Integer.parseInt(string)) < 0) {
            throw new DatatypeException("value must be a positiveInteger");
        }
        return new FractionDigitsFacet(n, bl, null);
    }

    public Datatype createDatatype() {
        return this.type;
    }

    TypeBuilder(SimpleType simpleType) {
        this.type = simpleType;
        simpleType.facets = new LinkedHashSet();
    }
}

