/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferHelper;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.VMDirectByteBuffer;

class CharViewBufferImpl
extends CharBuffer {
    private int offset;
    private ByteBuffer bb;
    private boolean readOnly;
    private ByteOrder endian;

    public char get() {
        int n = this.position();
        char c = ByteBufferHelper.getChar(this.bb, (n << 1) + this.offset, this.endian);
        this.position(n + 1);
        return c;
    }

    public char get(int n) {
        return ByteBufferHelper.getChar(this.bb, (n << 1) + this.offset, this.endian);
    }

    public CharBuffer put(char c) {
        int n = this.position();
        ByteBufferHelper.putChar(this.bb, (n << 1) + this.offset, c, this.endian);
        this.position(n + 1);
        return this;
    }

    public CharBuffer put(int n, char c) {
        ByteBufferHelper.putChar(this.bb, (n << 1) + this.offset, c, this.endian);
        return this;
    }

    public CharBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            this.bb.shiftDown(this.offset, this.offset + 2 * this.position(), 2 * n);
            this.position(n);
            this.limit(this.capacity());
        } else {
            this.position(this.limit());
            this.limit(this.capacity());
        }
        return this;
    }

    public CharBuffer slice() {
        return new CharViewBufferImpl(this.bb, (this.position() >> 1) + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly(), this.endian);
    }

    CharBuffer duplicate(boolean bl) {
        int n = this.position();
        this.reset();
        int n2 = this.position();
        this.position(n);
        return new CharViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), n, n2, bl, this.endian);
    }

    public CharBuffer duplicate() {
        return this.duplicate(this.readOnly);
    }

    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate(true);
    }

    public CharSequence subSequence(int n, int n2) {
        if (n < 0 || n2 < n || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new CharViewBufferImpl(this.bb, this.array_offset, this.capacity(), this.position() + n2, this.position() + n, -1, this.isReadOnly(), this.endian);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public ByteOrder order() {
        return this.endian;
    }

    CharViewBufferImpl(ByteBuffer byteBuffer, int n) {
        super(n, n, 0, -1);
        this.bb = byteBuffer;
        this.offset = byteBuffer.position();
        this.readOnly = byteBuffer.isReadOnly();
        this.endian = byteBuffer.order();
        if (byteBuffer.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(byteBuffer.address, this.offset);
        }
    }

    public CharViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl, ByteOrder byteOrder) {
        super(n2, n3, n4, n5);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteOrder;
        if (byteBuffer.isDirect()) {
            this.address = VMDirectByteBuffer.adjustAddress(byteBuffer.address, n);
        }
    }
}

