/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Calendar
implements Serializable,
Cloneable {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    private static final String calendarClassName = "java.util.GregorianCalendar";
    static final long serialVersionUID = -1807547505821590642L;
    private static final String bundleName = "gnu.java.locale.LocaleInformation";
    private static HashMap cache;
    private static Class[] ctorArgTypes;
    private static final String[] fieldNames;
    protected int[] fields;
    protected boolean[] isSet;
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    private TimeZone zone;
    private boolean lenient;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;
    private boolean explicitDSTOffset;
    private int serialVersionOnStream;
    static /* synthetic */ Class class$java$util$TimeZone;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$GregorianCalendar;

    private static final ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(bundleName, locale, ClassLoader.getSystemClassLoader());
    }

    public static synchronized Calendar getInstance() {
        return Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
    }

    public static synchronized Calendar getInstance(TimeZone timeZone) {
        return Calendar.getInstance(timeZone, Locale.getDefault());
    }

    public static synchronized Calendar getInstance(Locale locale) {
        return Calendar.getInstance(TimeZone.getDefault(), locale);
    }

    public static synchronized Calendar getInstance(TimeZone timeZone, Locale locale) {
        Class clazz = (Class)cache.get(locale);
        Exception exception = null;
        try {
            Class clazz2;
            if (clazz == null) {
                clazz = Class.forName(calendarClassName);
                Class clazz3 = class$java$util$Calendar;
                if (clazz3 == null) {
                    clazz3 = class$java$util$Calendar = Calendar.class("[Ljava.util.Calendar;", false);
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    cache.put(locale, clazz);
                }
            }
            if ((clazz2 = class$java$util$GregorianCalendar) == null) {
                clazz2 = class$java$util$GregorianCalendar = Calendar.class("[Ljava.util.GregorianCalendar;", false);
            }
            if (clazz == clazz2) {
                return new GregorianCalendar(timeZone, locale);
            }
            Class clazz4 = class$java$util$Calendar;
            if (clazz4 == null) {
                clazz4 = class$java$util$Calendar = Calendar.class("[Ljava.util.Calendar;", false);
            }
            if (clazz4.isAssignableFrom(clazz)) {
                Constructor constructor = clazz.getConstructor(ctorArgTypes);
                return (Calendar)constructor.newInstance(new Object[]{timeZone, locale});
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (InstantiationException instantiationException) {
            exception = instantiationException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        throw new RuntimeException("Error instantiating calendar for locale " + locale, exception);
    }

    public static synchronized Locale[] getAvailableLocales() {
        ResourceBundle resourceBundle = Calendar.getBundle(new Locale("", ""));
        return (Locale[])resourceBundle.getObject("availableLocales");
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final Date getTime() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return new Date(this.time);
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return this.time;
    }

    public void setTimeInMillis(long l) {
        this.clear();
        this.time = l;
        this.isTimeSet = true;
        this.computeFields();
    }

    public int get(int n) {
        if (!this.isSet[n]) {
            this.areFieldsSet = false;
        }
        this.complete();
        return this.fields[n];
    }

    protected final int internalGet(int n) {
        return this.fields[n];
    }

    public void set(int n, int n2) {
        if (this.isTimeSet) {
            int n3 = 0;
            while (n3 < 17) {
                this.isSet[n3] = false;
                ++n3;
            }
        }
        this.isTimeSet = false;
        this.fields[n] = n2;
        this.isSet[n] = true;
        switch (n) {
            case 2: {
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 5: {
                this.isSet[1] = true;
                this.isSet[2] = true;
                this.isSet[4] = true;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 4: {
                if (!this.isSet[7]) {
                    this.fields[7] = this.getFirstDayOfWeek();
                }
                this.isSet[1] = true;
                this.isSet[2] = true;
                this.isSet[7] = true;
                this.isSet[5] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 8: {
                if (!this.isSet[7]) {
                    this.fields[7] = this.getFirstDayOfWeek();
                }
                this.isSet[1] = true;
                this.isSet[2] = true;
                this.isSet[7] = true;
                this.isSet[6] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[3] = false;
                break;
            }
            case 6: {
                this.isSet[1] = true;
                this.isSet[2] = false;
                this.isSet[4] = false;
                this.isSet[5] = false;
                this.isSet[7] = false;
                this.isSet[3] = false;
                this.isSet[8] = false;
                break;
            }
            case 3: {
                if (!this.isSet[7]) {
                    this.fields[7] = this.getFirstDayOfWeek();
                }
                this.isSet[1] = true;
                this.isSet[7] = true;
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[6] = false;
                this.isSet[8] = false;
                break;
            }
            case 9: {
                this.isSet[10] = true;
                this.isSet[11] = false;
                break;
            }
            case 11: {
                this.isSet[9] = false;
                this.isSet[10] = false;
                break;
            }
            case 10: {
                this.isSet[9] = true;
                this.isSet[11] = false;
                break;
            }
            case 16: {
                this.explicitDSTOffset = true;
            }
        }
        if (!this.explicitDSTOffset && n != 16 && n != 15) {
            this.isSet[16] = false;
        }
    }

    public final void set(int n, int n2, int n3) {
        this.isTimeSet = false;
        this.fields[1] = n;
        this.fields[2] = n2;
        this.fields[5] = n3;
        this.isSet[5] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[3] = false;
        this.isSet[6] = false;
        this.isSet[4] = false;
        this.isSet[7] = false;
        this.isSet[8] = false;
        this.isSet[0] = false;
        if (!this.explicitDSTOffset) {
            this.isSet[16] = false;
        }
    }

    public final void set(int n, int n2, int n3, int n4, int n5) {
        this.set(n, n2, n3);
        this.fields[11] = n4;
        this.fields[12] = n5;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[9] = false;
        this.isSet[10] = false;
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(n, n2, n3, n4, n5);
        this.fields[13] = n6;
        this.isSet[13] = true;
    }

    public final void clear() {
        this.isTimeSet = false;
        this.areFieldsSet = false;
        int n = this.zone.getRawOffset();
        int[] nArray = new int[17];
        nArray[0] = 1;
        nArray[1] = 1970;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 5;
        nArray[8] = 1;
        nArray[15] = n;
        int[] nArray2 = nArray;
        this.fields = nArray2;
        int n2 = 0;
        while (n2 < 17) {
            this.isSet[n2] = false;
            ++n2;
        }
    }

    public final void clear(int n) {
        int[] nArray = new int[17];
        nArray[0] = 1;
        nArray[1] = 1970;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 5;
        nArray[8] = 1;
        nArray[15] = this.zone.getRawOffset();
        int[] nArray2 = nArray;
        this.isTimeSet = false;
        this.areFieldsSet = false;
        this.isSet[n] = false;
        this.fields[n] = nArray2[n];
    }

    public final boolean isSet(int n) {
        return this.isSet[n];
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        if (this.getTimeInMillis() == ((Calendar)object).getTimeInMillis() && calendar.getFirstDayOfWeek() == this.getFirstDayOfWeek() && calendar.isLenient() == this.isLenient() && calendar.getMinimalDaysInFirstWeek() == this.getMinimalDaysInFirstWeek()) {
            boolean bl;
            TimeZone timeZone = this.getTimeZone();
            TimeZone timeZone2 = calendar.getTimeZone();
            if (timeZone == null) {
                bl = false;
                if (timeZone2 == null) {
                    bl = true;
                }
            } else {
                bl = timeZone.equals(timeZone2);
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        long l = this.getTimeInMillis();
        int n = (int)(l & 0xFFFFFFFFL ^ l >> 32);
        n += this.getFirstDayOfWeek() + (this.isLenient() ? 1230 : 1237) + this.getMinimalDaysInFirstWeek();
        TimeZone timeZone = this.getTimeZone();
        if (timeZone != null) {
            n ^= timeZone.hashCode();
        }
        return n;
    }

    public boolean before(Object object) {
        boolean bl = false;
        if (this.getTimeInMillis() < ((Calendar)object).getTimeInMillis()) {
            bl = true;
        }
        return bl;
    }

    public boolean after(Object object) {
        boolean bl = false;
        if (this.getTimeInMillis() > ((Calendar)object).getTimeInMillis()) {
            bl = true;
        }
        return bl;
    }

    public abstract void add(int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void roll(int n, int n2) {
        while (n2 > 0) {
            this.roll(n, true);
            --n2;
        }
        while (n2 < 0) {
            this.roll(n, false);
            ++n2;
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int n) {
        this.firstDayOfWeek = n;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        this.minimalDaysInFirstWeek = n;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public int getActualMinimum(int n) {
        Calendar calendar = (Calendar)this.clone();
        int n2 = calendar.getGreatestMinimum(n);
        int n3 = calendar.getMinimum(n);
        calendar.set(n, n2);
        while (n2 > n3) {
            calendar.add(n, -1);
            if (calendar.get(n) != n2 - 1) break;
            --n2;
        }
        return n2;
    }

    public int getActualMaximum(int n) {
        Calendar calendar = (Calendar)this.clone();
        int n2 = calendar.getLeastMaximum(n);
        int n3 = calendar.getMaximum(n);
        calendar.set(n, n2);
        while (n2 < n3) {
            calendar.add(n, 1);
            if (calendar.get(n) != n2 + 1) break;
            ++n2;
        }
        return n2;
    }

    public Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.fields = (int[])this.fields.clone();
            calendar.isSet = (boolean[])this.isSet.clone();
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append('[');
        stringBuffer.append("time=");
        if (this.isTimeSet) {
            stringBuffer.append(this.time);
        } else {
            stringBuffer.append("?");
        }
        stringBuffer.append(",zone=" + this.zone);
        stringBuffer.append(",areFieldsSet=" + this.areFieldsSet);
        int n = 0;
        while (n < 17) {
            stringBuffer.append(fieldNames[n]);
            if (this.isSet[n]) {
                stringBuffer.append(this.fields[n]);
            } else {
                stringBuffer.append("?");
            }
            ++n;
        }
        stringBuffer.append(",lenient=").append(this.lenient);
        stringBuffer.append(",firstDayOfWeek=").append(this.firstDayOfWeek);
        stringBuffer.append(",minimalDaysInFirstWeek=").append(this.minimalDaysInFirstWeek);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        objectOutputStream.defaultWriteObject();
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (this.serialVersionOnStream > 1) {
            this.fields = new int[17];
            this.isSet = new boolean[17];
            this.areFieldsSet = false;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.fields = new int[17];
        this.isSet = new boolean[17];
        this.explicitDSTOffset = false;
        this.serialVersionOnStream = 1;
    }

    protected Calendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        this.this();
        this.zone = timeZone;
        this.lenient = true;
        String[] stringArray = new String[]{"", "sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        ResourceBundle resourceBundle = Calendar.getBundle(locale);
        String string = (String)resourceBundle.getObject("minNumberOfDaysInFirstWeek");
        String string2 = (String)resourceBundle.getObject("firstDayOfWeek");
        try {
            if (string != null) {
                this.minimalDaysInFirstWeek = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.minimalDaysInFirstWeek = 1;
        }
        this.firstDayOfWeek = 1;
        if (string2 != null) {
            int n = 0;
            while (n < 8) {
                if (stringArray[n].equals(string2)) {
                    this.firstDayOfWeek = n;
                }
                ++n;
            }
        }
        this.clear();
    }

    static {
        Class clazz;
        cache = new HashMap();
        Class[] classArray = new Class[2];
        Class clazz2 = class$java$util$TimeZone;
        if (clazz2 == null) {
            clazz2 = classArray[0] = (class$java$util$TimeZone = Calendar.class("[Ljava.util.TimeZone;", false));
        }
        if ((clazz = class$java$util$Locale) == null) {
            clazz = class$java$util$Locale = Calendar.class("[Ljava.util.Locale;", false);
        }
        classArray[1] = clazz;
        ctorArgTypes = classArray;
        fieldNames = new String[]{",ERA=", ",YEAR=", ",MONTH=", ",WEEK_OF_YEAR=", ",WEEK_OF_MONTH=", ",DAY_OF_MONTH=", ",DAY_OF_YEAR=", ",DAY_OF_WEEK=", ",DAY_OF_WEEK_IN_MONTH=", ",AM_PM=", ",HOUR=", ",HOUR_OF_DAY=", ",MINUTE=", ",SECOND=", ",MILLISECOND=", ",ZONE_OFFSET=", ",DST_OFFSET="};
    }
}

