/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_LAYER_CONTROL_H__
#define __SG_LAYER_CONTROL_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "sg_application.h"
#include "widgets/sg_plot.h"

#define GTK_TYPE_SG_LAYER_CONTROL                  (sg_layer_control_get_type ())
#define SG_LAYER_CONTROL(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_SG_LAYER_CONTROL, SGlayerControl))
#define SG_LAYER_CONTROL_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_SG_LAYER_CONTROL, SGlayerControlClass))
#define GTK_IS_SG_LAYER_CONTROL(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_SG_LAYER_CONTROL))
#define GTK_IS_SG_LAYER_CONTROL_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SG_LAYER_CONTROL))
                                                                                 
typedef struct _SGlayerControl SGlayerControl;
typedef struct _SGlayerControlClass SGlayerControlClass;
typedef struct _SGnodeData SGnodeData;

struct _SGnodeData
{
    gint type;
    gpointer data;
    void (* action) (SGlayerControl *dialog, gpointer object);
                                                                                 
    gchar *path;
    GtkCTreeNode *node;
};

struct _SGlayerControl
{
  GtkWindow window;
                                                                                 
  SGplot *plot;
  SGapplication *application;
                                                                                 
  gchar *path;
  GtkWidget *dialog;
  GtkWidget *main_frame;
  GtkWidget *swindow;
  GtkWidget *tree;
  GtkWidget *label;
                                                                                 
  GList *nodes;
                                                                                 
  GtkWidget *ok_button;
  GtkWidget *apply_button;
  GtkWidget *cancel_button;
                                                                                 
  GdkPixmap *layer_pixmap;
  GdkPixmap *plot2d_pixmap;
  GdkPixmap *plot3d_pixmap;
  GdkPixmap *polar_pixmap;
  GdkBitmap *layer_mask;
  GdkBitmap *plot2d_mask;
  GdkBitmap *plot3d_mask;
  GdkBitmap *polar_mask;
};
                                                                                 
struct _SGlayerControlClass
{
  GtkWindowClass parent_class;
};

GtkType		sg_layer_control_get_type		(void);
GtkWidget *	sg_layer_control_new			(SGplot *plot);
GtkWidget *	sg_layer_control_new_application	(SGapplication *app);
void            sg_layer_control_refresh        	(GtkWidget *dialog, 
                                                	 const gchar *path);
void            sg_layer_control_open              	(GtkWidget *dialog, 
                                                	 const gchar *path);
void		sg_layer_control_clear_paned		(SGlayerControl *d);
SGnodeData *    sg_node_data_new
				(gint type, 
				 gpointer data,
                 		 void (*action) (SGlayerControl*, gpointer),
                    		 const gchar *path, 
				 GtkCTreeNode *tree_node);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_LAYER_CONTROL_H__ */

