/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_PLUGIN_STYLE_H__
#define __SG_PLUGIN_STYLE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_plugin.h"

#define SG_PLUGIN_STYLE(obj)        GTK_CHECK_CAST (obj, sg_plugin_style_get_type (), SGpluginStyle)
#define GTK_TYPE_SG_PLUGIN_STYLE   (sg_plugin_style_get_type ())

#define SG_PLUGIN_STYLE_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, sg_plugin_style_get_type(), SGpluginStyleClass)
#define GTK_IS_SG_PLUGIN_STYLE(obj)     GTK_CHECK_TYPE (obj, sg_plugin_style_get_type ())


typedef struct _SGpluginStyle   SGpluginStyle;
typedef struct _SGpluginStyleClass   SGpluginStyleClass;

struct _SGpluginStyle
{
  SGplugin plugin;

  gchar * layer;
 
  GtkPixmap *pixmap;

  GtkPlotArrayList *arrays;
  
  GtkPlotData* (*construct) 			(void);
  GtkWidget* (*property_dialog) 		(SGpluginStyle *plugin, 
						 GtkPlotData *dataset);
};

struct _SGpluginStyleClass
{
  SGpluginClass parent_class;
};

GtkType		sg_plugin_style_get_type	();
SGpluginStyle *	sg_plugin_style_new		();
GtkPlotData *   sg_plugin_style_construct	(SGpluginStyle *plugin);
void		sg_plugin_style_add_dimension	(SGpluginStyle *plugin,
			                         const gchar *name,
                       			         const gchar *label,
            			                 const gchar *desc,
                			         GtkType value_type,
                 			         gboolean required,
               			                 gboolean independent);
GtkWidget*      sg_plugin_style_dialog          (SGpluginStyle *plugin,
                                                 GtkPlotData *dataset);
gint 		sg_plugin_style_num_required_dimensions
						(SGpluginStyle *style);
gint 		sg_plugin_style_num_independent_dimensions
						(SGpluginStyle *style);
gint 		sg_plugin_style_num_dependent_dimensions
						(SGpluginStyle *style);
gint 		sg_plugin_style_min_independent_dimensions
						(SGpluginStyle *style);
gint 		sg_plugin_style_min_dependent_dimensions
						(SGpluginStyle *style);
gboolean        sg_plugin_style_dialog_apply    (SGpluginStyle *plugin,
                                                 GtkPlotData *dataset);
void	        sg_plugin_style_dialog_init     (SGpluginStyle *plugin,
                                                 GtkPlotData *dataset);
SGpluginStyle * sg_plugin_style_get		(const gchar *name);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_PLUGIN_STYLE_H__ */

