/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_MATRIX_H__
#define __SG_MATRIX_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_widgets_enums.h"
#include "sg_worksheet.h"

#define GTK_TYPE_SG_MATRIX                  (sg_matrix_get_type ())
#define SG_MATRIX(obj)                  (GTK_CHECK_CAST ((obj), GTK_TYPE_SG_MATRIX, SGmatrix))
#define SG_MATRIX_CLASS(klass)          (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_SG_MATRIX, SGmatrixClass))
#define GTK_IS_SG_MATRIX(obj)               (GTK_CHECK_TYPE ((obj), GTK_TYPE_SG_MATRIX))
#define GTK_IS_SG_MATRIX_CLASS(klass)       (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_SG_MATRIX))

typedef struct _SGmatrix SGmatrix;
typedef struct _SGmatrixClass SGmatrixClass;

struct _SGmatrix 
{
  SGworksheet worksheet;

  SGcolumn format;

  gdouble xmin, xmax;
  gdouble ymin, ymax;

  gdouble *x_values;
  gdouble *y_values;
  gint nx, ny;
};

struct _SGmatrixClass
{
  SGworksheetClass parent_class;
};

GtkType 	sg_matrix_get_type		(void); 
SGmatrix 	*sg_matrix_new			(gchar *name, 
                                                 gint nrows, gint ncols);
void		sg_matrix_set_xrange		(SGmatrix *matrix,
						 gdouble xmin, gdouble xmax);
void		sg_matrix_set_yrange		(SGmatrix *matrix,
						 gdouble ymin, gdouble ymax);
void		sg_matrix_set_x_values		(SGmatrix *matrix,
						 gdouble *x, gint nx);
void		sg_matrix_set_y_values		(SGmatrix *matrix,
						 gdouble *y, gint ny);
void 		sg_matrix_set_format		(SGmatrix *matrix,
                           			 SGcolumntype type,
                               			 SGcolumnformat format,
                               			 SGcolumninternal internal,
                               			 gint precision);
void 		sg_matrix_set_exp		(SGmatrix *matrix,
                               			 gchar *exp); 
void 		sg_matrix_update_exp		(SGmatrix *matrix,
                               			 gchar *exp,
						 gint from_col, gint to_col, 
						 gint from_row, gint to_row); 


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SG_MATRIX_H__ */

