/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.animation;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import uk.ac.ic.doc.scenebeans.TransformBase;
import uk.ac.ic.doc.scenebeans.animation.Animation;

class WindowTransform
extends TransformBase {
    private double _width = 0.0;
    private double _height = 0.0;
    private double _child_width = 1.0;
    private double _child_height = 1.0;
    private double _translate_x = 0.0;
    private double _translate_y = 0.0;
    private double _scale_x = 1.0;
    private double _scale_y = 1.0;
    private boolean _is_centered = false;
    private boolean _is_stretched = false;
    private boolean _is_aspect_fixed = false;

    WindowTransform() {
    }

    public boolean isCentered() {
        return this._is_centered;
    }

    public void setCentered(boolean bl) {
        this._is_centered = bl;
        this.updateTransform();
    }

    public boolean isStretched() {
        return this._is_stretched;
    }

    public void setStretched(boolean bl) {
        this._is_stretched = bl;
        this.updateTransform();
    }

    public boolean isAspectFixed() {
        return this._is_aspect_fixed;
    }

    public void setAspectFixed(boolean bl) {
        this._is_aspect_fixed = bl;
        this.updateTransform();
    }

    public AffineTransform getTransform() {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this._translate_x, this._translate_y);
        affineTransform.scale(this._scale_x, this._scale_y);
        return affineTransform;
    }

    public void setWindowSize(double d, double d2) {
        this._width = d;
        this._height = d2;
        this.updateTransform();
    }

    public void updateTransform() {
        if (this._is_centered) {
            this._translate_x = this._width / 2.0;
            this._translate_y = this._height / 2.0;
        } else {
            this._translate_x = 0.0;
            this._translate_y = 0.0;
        }
        if (this._is_stretched) {
            double d = this._width / this._child_width;
            double d2 = this._height / this._child_height;
            if (this._is_aspect_fixed) {
                this._scale_x = this._scale_y = Math.min(d, d2);
            } else {
                this._scale_x = d;
                this._scale_y = d2;
            }
        } else {
            this._scale_x = 1.0;
            this._scale_y = 1.0;
        }
        this.setDirty(true);
    }

    public void setTransformedGraph(Animation animation) {
        this._child_width = animation.getWidth();
        this._child_height = animation.getHeight();
        super.setTransformedGraph(animation);
        this.updateTransform();
    }

    protected void transform(Graphics2D graphics2D) {
        graphics2D.translate(this._translate_x, this._translate_y);
        graphics2D.scale(this._scale_x, this._scale_y);
    }
}

