require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_VNODE_H_)) {
    eval 'sub _SYS_VNODE_H_ () {1;}' unless defined(&_SYS_VNODE_H_);
    require 'sys/event.ph';
    require 'sys/queue.ph';
    require 'sys/condvar.ph';
    require 'sys/rwlock.ph';
    require 'sys/mutex.ph';
    require 'sys/time.ph';
    require 'sys/acl.ph';
    require 'uvm/uvm_param.ph';
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	require 'uvm/uvm_pglist.ph';
	require 'uvm/uvm_object.ph';
	require 'uvm/uvm_extern.ph';
    }
    eval("sub VNON () { 0; }") unless defined(&VNON);
    eval("sub VREG () { 1; }") unless defined(&VREG);
    eval("sub VDIR () { 2; }") unless defined(&VDIR);
    eval("sub VBLK () { 3; }") unless defined(&VBLK);
    eval("sub VCHR () { 4; }") unless defined(&VCHR);
    eval("sub VLNK () { 5; }") unless defined(&VLNK);
    eval("sub VSOCK () { 6; }") unless defined(&VSOCK);
    eval("sub VFIFO () { 7; }") unless defined(&VFIFO);
    eval("sub VBAD () { 8; }") unless defined(&VBAD);
    eval 'sub VNODE_TYPES () {"VNON", "VREG", "VDIR", "VBLK", "VCHR", "VLNK", "VSOCK", "VFIFO", "VBAD";}' unless defined(&VNODE_TYPES);
    eval("sub VT_NON () { 0; }") unless defined(&VT_NON);
    eval("sub VT_UFS () { 1; }") unless defined(&VT_UFS);
    eval("sub VT_NFS () { 2; }") unless defined(&VT_NFS);
    eval("sub VT_MFS () { 3; }") unless defined(&VT_MFS);
    eval("sub VT_MSDOSFS () { 4; }") unless defined(&VT_MSDOSFS);
    eval("sub VT_LFS () { 5; }") unless defined(&VT_LFS);
    eval("sub VT_LOFS () { 6; }") unless defined(&VT_LOFS);
    eval("sub VT_FDESC () { 7; }") unless defined(&VT_FDESC);
    eval("sub VT_PORTAL () { 8; }") unless defined(&VT_PORTAL);
    eval("sub VT_NULL () { 9; }") unless defined(&VT_NULL);
    eval("sub VT_UMAP () { 10; }") unless defined(&VT_UMAP);
    eval("sub VT_KERNFS () { 11; }") unless defined(&VT_KERNFS);
    eval("sub VT_PROCFS () { 12; }") unless defined(&VT_PROCFS);
    eval("sub VT_AFS () { 13; }") unless defined(&VT_AFS);
    eval("sub VT_ISOFS () { 14; }") unless defined(&VT_ISOFS);
    eval("sub VT_UNION () { 15; }") unless defined(&VT_UNION);
    eval("sub VT_ADOSFS () { 16; }") unless defined(&VT_ADOSFS);
    eval("sub VT_EXT2FS () { 17; }") unless defined(&VT_EXT2FS);
    eval("sub VT_CODA () { 18; }") unless defined(&VT_CODA);
    eval("sub VT_FILECORE () { 19; }") unless defined(&VT_FILECORE);
    eval("sub VT_NTFS () { 20; }") unless defined(&VT_NTFS);
    eval("sub VT_VFS () { 21; }") unless defined(&VT_VFS);
    eval("sub VT_OVERLAY () { 22; }") unless defined(&VT_OVERLAY);
    eval("sub VT_SMBFS () { 23; }") unless defined(&VT_SMBFS);
    eval("sub VT_PTYFS () { 24; }") unless defined(&VT_PTYFS);
    eval("sub VT_TMPFS () { 25; }") unless defined(&VT_TMPFS);
    eval("sub VT_UDF () { 26; }") unless defined(&VT_UDF);
    eval("sub VT_SYSVBFS () { 27; }") unless defined(&VT_SYSVBFS);
    eval("sub VT_PUFFS () { 28; }") unless defined(&VT_PUFFS);
    eval("sub VT_HFS () { 29; }") unless defined(&VT_HFS);
    eval("sub VT_EFS () { 30; }") unless defined(&VT_EFS);
    eval("sub VT_ZFS () { 31; }") unless defined(&VT_ZFS);
    eval("sub VT_RUMP () { 32; }") unless defined(&VT_RUMP);
    eval("sub VT_NILFS () { 33; }") unless defined(&VT_NILFS);
    eval("sub VT_V7FS () { 34; }") unless defined(&VT_V7FS);
    eval("sub VT_CHFS () { 35; }") unless defined(&VT_CHFS);
    eval("sub VT_AUTOFS () { 36; }") unless defined(&VT_AUTOFS);
    eval 'sub VNODE_TAGS () {"VT_NON", "VT_UFS", "VT_NFS", "VT_MFS", "VT_MSDOSFS", "VT_LFS", "VT_LOFS", "VT_FDESC", "VT_PORTAL", "VT_NULL", "VT_UMAP", "VT_KERNFS", "VT_PROCFS", "VT_AFS", "VT_ISOFS", "VT_UNION", "VT_ADOSFS", "VT_EXT2FS", "VT_CODA", "VT_FILECORE", "VT_NTFS", "VT_VFS", "VT_OVERLAY", "VT_SMBFS", "VT_PTYFS", "VT_TMPFS", "VT_UDF", "VT_SYSVBFS", "VT_PUFFS", "VT_HFS", "VT_EFS", "VT_ZFS", "VT_RUMP", "VT_NILFS", "VT_V7FS", "VT_CHFS", "VT_AUTOFS";}' unless defined(&VNODE_TAGS);
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	eval 'sub v_mountedhere () { ($v_un->{vu_mountedhere});}' unless defined(&v_mountedhere);
	eval 'sub v_socket () { ($v_un->{vu_socket});}' unless defined(&v_socket);
	eval 'sub v_specnode () { ($v_un->{vu_specnode});}' unless defined(&v_specnode);
	eval 'sub v_fifoinfo () { ($v_un->{vu_fifoinfo});}' unless defined(&v_fifoinfo);
	eval 'sub v_ractx () { ($v_un->{vu_ractx});}' unless defined(&v_ractx);
    }
    eval 'sub VV_ROOT () {0x1;}' unless defined(&VV_ROOT);
    eval 'sub VV_SYSTEM () {0x2;}' unless defined(&VV_SYSTEM);
    eval 'sub VV_ISTTY () {0x4;}' unless defined(&VV_ISTTY);
    eval 'sub VV_MAPPED () {0x8;}' unless defined(&VV_MAPPED);
    eval 'sub VV_MPSAFE () {0x10;}' unless defined(&VV_MPSAFE);
    eval 'sub VI_TEXT () {0x100;}' unless defined(&VI_TEXT);
    eval 'sub VI_EXECMAP () {0x200;}' unless defined(&VI_EXECMAP);
    eval 'sub VI_WRMAP () {0x400;}' unless defined(&VI_WRMAP);
    eval 'sub VI_PAGES () {0x800;}' unless defined(&VI_PAGES);
    eval 'sub VI_ONWORKLST () {0x4000;}' unless defined(&VI_ONWORKLST);
    eval 'sub VI_DEADCHECK () {0x8000;}' unless defined(&VI_DEADCHECK);
    eval 'sub VU_DIROP () {0x1000000;}' unless defined(&VU_DIROP);
    eval 'sub VNODE_FLAGBITS () {"\\20\\1ROOT\\2SYSTEM\\3ISTTY\\4MAPPED\\5MPSAFE\\11TEXT\\12EXECMAP" "\\13WRMAP\\14PAGES\\17ONWORKLST\\20DEADCHECK\\31DIROP";}' unless defined(&VNODE_FLAGBITS);
    eval 'sub VSIZENOTSET () {(( &voff_t)-1);}' unless defined(&VSIZENOTSET);
    eval 'sub LK_NONE () {0x;}' unless defined(&LK_NONE);
    eval 'sub LK_SHARED () {0x1;}' unless defined(&LK_SHARED);
    eval 'sub LK_EXCLUSIVE () {0x2;}' unless defined(&LK_EXCLUSIVE);
    eval 'sub LK_UPGRADE () {0x10;}' unless defined(&LK_UPGRADE);
    eval 'sub LK_DOWNGRADE () {0x20;}' unless defined(&LK_DOWNGRADE);
    eval 'sub LK_NOWAIT () {0x100;}' unless defined(&LK_NOWAIT);
    eval 'sub LK_RETRY () {0x200;}' unless defined(&LK_RETRY);
    eval 'sub VA_UTIMES_NULL () {0x1;}' unless defined(&VA_UTIMES_NULL);
    eval 'sub VA_EXCLUSIVE () {0x2;}' unless defined(&VA_EXCLUSIVE);
    if(defined(&_KERNEL)) {
	eval 'sub IO_UNIT () {0x10;}' unless defined(&IO_UNIT);
	eval 'sub IO_APPEND () {0x20;}' unless defined(&IO_APPEND);
	eval 'sub IO_SYNC () {(0x40| &IO_DSYNC);}' unless defined(&IO_SYNC);
	eval 'sub IO_NODELOCKED () {0x80;}' unless defined(&IO_NODELOCKED);
	eval 'sub IO_NDELAY () {0x100;}' unless defined(&IO_NDELAY);
	eval 'sub IO_DSYNC () {0x200;}' unless defined(&IO_DSYNC);
	eval 'sub IO_ALTSEMANTICS () {0x400;}' unless defined(&IO_ALTSEMANTICS);
	eval 'sub IO_NORMAL () {0x800;}' unless defined(&IO_NORMAL);
	eval 'sub IO_EXT () {0x1000;}' unless defined(&IO_EXT);
	eval 'sub IO_DIRECT () {0x2000;}' unless defined(&IO_DIRECT);
	eval 'sub IO_JOURNALLOCKED () {0x4000;}' unless defined(&IO_JOURNALLOCKED);
	eval 'sub IO_ADV_MASK () {0x3;}' unless defined(&IO_ADV_MASK);
	eval 'sub IO_ADV_SHIFT () {0;}' unless defined(&IO_ADV_SHIFT);
	eval 'sub IO_ADV_ENCODE {
	    my($adv) = @_;
    	    eval q(((($adv) <<  &IO_ADV_SHIFT) &  &IO_ADV_MASK));
	}' unless defined(&IO_ADV_ENCODE);
	eval 'sub IO_ADV_DECODE {
	    my($ioflag) = @_;
    	    eval q(((($ioflag) &  &IO_ADV_MASK) >>  &IO_ADV_SHIFT));
	}' unless defined(&IO_ADV_DECODE);
	eval 'sub VEXEC () {000000000100;}' unless defined(&VEXEC);
	eval 'sub VWRITE () {000000000200;}' unless defined(&VWRITE);
	eval 'sub VREAD () {000000000400;}' unless defined(&VREAD);
	eval 'sub VADMIN () {000000010000;}' unless defined(&VADMIN);
	eval 'sub VAPPEND () {000000040000;}' unless defined(&VAPPEND);
	eval 'sub VEXPLICIT_DENY () {000000100000;}' unless defined(&VEXPLICIT_DENY);
	eval 'sub VREAD_NAMED_ATTRS () {000000200000;}' unless defined(&VREAD_NAMED_ATTRS);
	eval 'sub VWRITE_NAMED_ATTRS () {000000400000;}' unless defined(&VWRITE_NAMED_ATTRS);
	eval 'sub VDELETE_CHILD () {000001000000;}' unless defined(&VDELETE_CHILD);
	eval 'sub VREAD_ATTRIBUTES () {000002000000;}' unless defined(&VREAD_ATTRIBUTES);
	eval 'sub VWRITE_ATTRIBUTES () {000004000000;}' unless defined(&VWRITE_ATTRIBUTES);
	eval 'sub VDELETE () {000010000000;}' unless defined(&VDELETE);
	eval 'sub VREAD_ACL () {000020000000;}' unless defined(&VREAD_ACL);
	eval 'sub VWRITE_ACL () {000040000000;}' unless defined(&VWRITE_ACL);
	eval 'sub VWRITE_OWNER () {000100000000;}' unless defined(&VWRITE_OWNER);
	eval 'sub VSYNCHRONIZE () {000200000000;}' unless defined(&VSYNCHRONIZE);
	eval 'sub VCREAT () {000400000000;}' unless defined(&VCREAT);
	eval 'sub VVERIFY () {001000000000;}' unless defined(&VVERIFY);
	eval 'sub __VNODE_PERM_BITS () {"\\10" "\\07VEXEC" "\\10VWRITE" "\\11VREAD" "\\15VADMIN" "\\17VAPPEND" "\\20VEXPLICIT_DENY" "\\21VREAD_NAMED_ATTRS" "\\22VWRITE_NAMED_ATTRS" "\\23VDELETE_CHILD" "\\24VREAD_ATTRIBUTES" "\\25VWRITE_ATTRIBUTES" "\\26VDELETE" "\\27VREAD_ACL" "\\30VWRITE_ACL" "\\31VWRITE_OWNER" "\\32VSYNCHRONIZE" "\\33VCREAT" "\\34VVERIFY";}' unless defined(&__VNODE_PERM_BITS);
	eval 'sub VADMIN_PERMS () {( &VADMIN |  &VWRITE_ATTRIBUTES |  &VWRITE_ACL |  &VWRITE_OWNER);}' unless defined(&VADMIN_PERMS);
	eval 'sub VSTAT_PERMS () {( &VREAD_ATTRIBUTES |  &VREAD_ACL);}' unless defined(&VSTAT_PERMS);
	eval 'sub VMODIFY_PERMS () {( &VWRITE |  &VAPPEND |  &VADMIN_PERMS |  &VDELETE_CHILD |  &VDELETE);}' unless defined(&VMODIFY_PERMS);
	eval 'sub VNOVAL () {(-1);}' unless defined(&VNOVAL);
	eval 'sub VNOVALSIZE () {(( &u_quad_t)-1);}' unless defined(&VNOVALSIZE);
	eval 'sub VNOVALFLAGS () {(-1);}' unless defined(&VNOVALFLAGS);
	eval 'sub IFTOVT {
	    my($mode) = @_;
    	    eval q(( $iftovt_tab[(($mode) &  &S_IFMT) >> 12]));
	}' unless defined(&IFTOVT);
	eval 'sub VTTOIF {
	    my($indx) = @_;
    	    eval q(( $vttoif_tab[($indx)]));
	}' unless defined(&VTTOIF);
	eval 'sub MAKEIMODE {
	    my($indx, $mode) = @_;
    	    eval q(( &VTTOIF($indx) | ($mode)));
	}' unless defined(&MAKEIMODE);
	eval 'sub SKIPSYSTEM () {0x1;}' unless defined(&SKIPSYSTEM);
	eval 'sub FORCECLOSE () {0x2;}' unless defined(&FORCECLOSE);
	eval 'sub WRITECLOSE () {0x4;}' unless defined(&WRITECLOSE);
	eval 'sub V_SAVE () {0x1;}' unless defined(&V_SAVE);
	eval 'sub REVOKEALL () {0x1;}' unless defined(&REVOKEALL);
	eval 'sub FSYNC_WAIT () {0x1;}' unless defined(&FSYNC_WAIT);
	eval 'sub FSYNC_DATAONLY () {0x2;}' unless defined(&FSYNC_DATAONLY);
	eval 'sub FSYNC_RECLAIM () {0x4;}' unless defined(&FSYNC_RECLAIM);
	eval 'sub FSYNC_LAZY () {0x8;}' unless defined(&FSYNC_LAZY);
	eval 'sub FSYNC_NOLOG () {0x10;}' unless defined(&FSYNC_NOLOG);
	eval 'sub FSYNC_CACHE () {0x100;}' unless defined(&FSYNC_CACHE);
	eval 'sub UPDATE_WAIT () {0x1;}' unless defined(&UPDATE_WAIT);
	eval 'sub UPDATE_DIROP () {0x2;}' unless defined(&UPDATE_DIROP);
	eval 'sub UPDATE_CLOSE () {0x4;}' unless defined(&UPDATE_CLOSE);
	eval 'sub VDEAD_NOWAIT () {0x1;}' unless defined(&VDEAD_NOWAIT);
	eval 'sub NULLVP () {( &NULL);}' unless defined(&NULLVP);
	eval 'sub _VN_KEVENT_INTEREST {
	    my($vp, $n) = @_;
    	    eval q(((($vp)-> ($v_klist->{vk_interest}) & ($n)) != 0));
	}' unless defined(&_VN_KEVENT_INTEREST);
	eval 'sub VN_KEVENT_INTEREST {
	    my($vp,$hint) = @_;
    	    eval q({  &mutex_enter( ($vp->{v_interlock}));  &bool  &rv =  &_VN_KEVENT_INTEREST($vp, $hint);  &mutex_exit( ($vp->{v_interlock}));  &rv; });
	}' unless defined(&VN_KEVENT_INTEREST);
	eval 'sub VN_KNOTE {
	    my($vp,$hint) = @_;
    	    eval q({  &mutex_enter( ($vp->{v_interlock}));  &if ( &__predict_false( &_VN_KEVENT_INTEREST($vp, $hint))) {  &knote( ($vp->{v_klist}->{vk_klist}), $hint); }  &mutex_exit( ($vp->{v_interlock})); });
	}' unless defined(&VN_KNOTE);
    }
    eval 'sub VDESC_MAX_VPS () {8;}' unless defined(&VDESC_MAX_VPS);
    eval 'sub VDESC_VP0_WILLRELE () {0x1;}' unless defined(&VDESC_VP0_WILLRELE);
    eval 'sub VDESC_VP1_WILLRELE () {0x2;}' unless defined(&VDESC_VP1_WILLRELE);
    eval 'sub VDESC_VP2_WILLRELE () {0x4;}' unless defined(&VDESC_VP2_WILLRELE);
    eval 'sub VDESC_VP3_WILLRELE () {0x8;}' unless defined(&VDESC_VP3_WILLRELE);
    eval 'sub VDESC_VP0_WILLPUT () {0x101;}' unless defined(&VDESC_VP0_WILLPUT);
    eval 'sub VDESC_VP1_WILLPUT () {0x202;}' unless defined(&VDESC_VP1_WILLPUT);
    eval 'sub VDESC_VP2_WILLPUT () {0x404;}' unless defined(&VDESC_VP2_WILLPUT);
    eval 'sub VDESC_VP3_WILLPUT () {0x808;}' unless defined(&VDESC_VP3_WILLPUT);
    eval 'sub VDESC_NO_OFFSET () {-1;}' unless defined(&VDESC_NO_OFFSET);
    if(defined(&_KERNEL)) {
	eval 'sub VOPARG_OFFSETOF {
	    my($type, $member) = @_;
    	    eval q( &offsetof($type, $member));
	}' unless defined(&VOPARG_OFFSETOF);
	eval 'sub VOPARG_OFFSETTO {
	    my($type,$offset,$sp) = @_;
    	    eval q((($type)((($sp)) + ($offset))));
	}' unless defined(&VOPARG_OFFSETTO);
	eval 'sub VOCALL {
	    my($OPSV,$OFF,$AP) = @_;
    	    eval q((( *(($OPSV)[($OFF)])) ($AP)));
	}' unless defined(&VOCALL);
	eval 'sub VCALL {
	    my($VP,$OFF,$AP) = @_;
    	    eval q( &VOCALL(($VP)-> &v_op,($OFF),($AP)));
	}' unless defined(&VCALL);
	eval 'sub VDESC {
	    my($OP) = @_;
    	    eval q((&  &__CONCAT($OP, &_desc)));
	}' unless defined(&VDESC);
	eval 'sub VOFFSET {
	    my($OP) = @_;
    	    eval q(( &VDESC($OP)-> &vdesc_offset));
	}' unless defined(&VOFFSET);
	require 'sys/mount.ph';
	require 'sys/vnode_if.ph';
	if(defined(&DDB) || defined(&DEBUGPRINT)) {
	}
    }
}
1;
