/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DoubleDST_2D {
    private int n1;
    private int n2;
    private int[] ip;
    private double[] w;
    private double[] t;
    private DoubleDST_1D dstn2;
    private DoubleDST_1D dstn1;
    private int oldNthread;
    private int nt;

    public DoubleDST_2D(int n, int n2) {
        if (!ConcurrencyUtils.isPowerOf2(n) || !ConcurrencyUtils.isPowerOf2(n2)) {
            throw new IllegalArgumentException("n1, n2 must be power of two numbers");
        }
        if (n <= 1 || n2 <= 1) {
            throw new IllegalArgumentException("n1, n2 must be greater than 1");
        }
        this.n1 = n;
        this.n2 = n2;
        this.ip = new int[2 + (int)Math.ceil(Math.sqrt(Math.max(n / 2, n2 / 2)))];
        this.w = new double[(int)Math.ceil(Math.max((double)n * 1.5, (double)n2 * 1.5))];
        this.dstn2 = new DoubleDST_1D(n2, this.ip, this.w);
        this.dstn1 = new DoubleDST_1D(n, this.ip, this.w);
        this.oldNthread = ConcurrencyUtils.getNumberOfProcessors();
        this.nt = 4 * this.oldNthread * n;
        if (n2 == 2 * this.oldNthread) {
            this.nt >>= 1;
        } else if (n2 < 2 * this.oldNthread) {
            this.nt >>= 2;
        }
        this.t = new double[this.nt];
    }

    public void forward(double[] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 4 * n * this.n1;
            if (this.n2 == 2 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 2 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.ddxt2d_subth(-1, dArray, bl);
            this.ddxt2d0_subth(-1, dArray, bl);
        } else {
            this.ddxt2d_sub(-1, dArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.dstn2.forward(dArray, i * this.n2, bl);
            }
        }
    }

    public void forward(double[][] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 4 * n * this.n1;
            if (this.n2 == 2 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 2 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.ddxt2d_subth(-1, dArray, bl);
            this.ddxt2d0_subth(-1, dArray, bl);
        } else {
            this.ddxt2d_sub(-1, dArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.dstn2.forward(dArray[i], bl);
            }
        }
    }

    public void inverse(double[] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 4 * n * this.n1;
            if (this.n2 == 2 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 2 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.ddxt2d_subth(1, dArray, bl);
            this.ddxt2d0_subth(1, dArray, bl);
        } else {
            this.ddxt2d_sub(1, dArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.dstn2.inverse(dArray, i * this.n2, bl);
            }
        }
    }

    public void inverse(double[][] dArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.n1;
        if (n4 < this.n2) {
            n4 = this.n2;
        }
        if (n4 > (n3 = this.ip[0]) << 2) {
            n3 = n4 >> 2;
            this.makewt(n3);
        }
        if (n4 > (n2 = this.ip[1])) {
            n2 = n4;
            this.makect(n2, this.w, n3);
        }
        if ((n = ConcurrencyUtils.getNumberOfProcessors()) != this.oldNthread) {
            this.nt = 4 * n * this.n1;
            if (this.n2 == 2 * n) {
                this.nt >>= 1;
            } else if (this.n2 < 2 * n) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthread = n;
        }
        if (n > 1 && this.n1 * this.n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.ddxt2d_subth(1, dArray, bl);
            this.ddxt2d0_subth(1, dArray, bl);
        } else {
            this.ddxt2d_sub(1, dArray, bl);
            for (int i = 0; i < this.n1; ++i) {
                this.dstn2.inverse(dArray[i], bl);
            }
        }
    }

    private void ddxt2d_subth(final int n, final double[] dArray, final boolean bl) {
        int n2;
        int n3;
        int n4 = n3 = ConcurrencyUtils.getNumberOfProcessors();
        int n5 = 4 * this.n1;
        if (this.n2 == 2 * n3) {
            n5 >>= 1;
        } else if (this.n2 < 2 * n3) {
            n4 = this.n2;
            n5 >>= 2;
        }
        final int n6 = n4;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block17: {
                        int n11;
                        block18: {
                            int n22;
                            int n3;
                            int n4;
                            block16: {
                                if (DoubleDST_2D.this.n2 <= 2 * n6) break block16;
                                if (n == -1) {
                                    for (int i = 4 * n2; i < DoubleDST_2D.this.n2; i += 4 * n6) {
                                        int n5;
                                        int n62;
                                        int n72;
                                        for (n72 = 0; n72 < DoubleDST_2D.this.n1; ++n72) {
                                            n62 = n72 * DoubleDST_2D.this.n2 + i;
                                            n5 = n7 + DoubleDST_2D.this.n1 + n72;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n7 + n72] = dArray[n62];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n5] = dArray[n62 + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n5 + ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n62 + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n5 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n62 + 3];
                                        }
                                        DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7, bl);
                                        DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7 + DoubleDST_2D.this.n1, bl);
                                        DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7 + 2 * DoubleDST_2D.this.n1, bl);
                                        DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7 + 3 * DoubleDST_2D.this.n1, bl);
                                        for (n72 = 0; n72 < DoubleDST_2D.this.n1; ++n72) {
                                            n62 = n72 * DoubleDST_2D.this.n2 + i;
                                            n5 = n7 + DoubleDST_2D.this.n1 + n72;
                                            dArray[n62] = DoubleDST_2D.this.t[n7 + n72];
                                            dArray[n62 + 1] = DoubleDST_2D.this.t[n5];
                                            dArray[n62 + 2] = DoubleDST_2D.this.t[n5 + DoubleDST_2D.this.n1];
                                            dArray[n62 + 3] = DoubleDST_2D.this.t[n5 + 2 * DoubleDST_2D.this.n1];
                                        }
                                    }
                                } else {
                                    for (int i = 4 * n2; i < DoubleDST_2D.this.n2; i += 4 * n6) {
                                        int n8;
                                        int n9;
                                        int n10;
                                        for (n10 = 0; n10 < DoubleDST_2D.this.n1; ++n10) {
                                            n9 = n10 * DoubleDST_2D.this.n2 + i;
                                            n8 = n7 + DoubleDST_2D.this.n1 + n10;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n7 + n10] = dArray[n9];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n8] = dArray[n9 + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n8 + ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n9 + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n8 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n9 + 3];
                                        }
                                        DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7, bl);
                                        DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7 + DoubleDST_2D.this.n1, bl);
                                        DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7 + 2 * DoubleDST_2D.this.n1, bl);
                                        DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7 + 3 * DoubleDST_2D.this.n1, bl);
                                        for (n10 = 0; n10 < DoubleDST_2D.this.n1; ++n10) {
                                            n9 = n10 * DoubleDST_2D.this.n2 + i;
                                            n8 = n7 + DoubleDST_2D.this.n1 + n10;
                                            dArray[n9] = DoubleDST_2D.this.t[n7 + n10];
                                            dArray[n9 + 1] = DoubleDST_2D.this.t[n8];
                                            dArray[n9 + 2] = DoubleDST_2D.this.t[n8 + DoubleDST_2D.this.n1];
                                            dArray[n9 + 3] = DoubleDST_2D.this.t[n8 + 2 * DoubleDST_2D.this.n1];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDST_2D.this.n2 != 2 * n6) break block18;
                            for (n4 = 0; n4 < DoubleDST_2D.this.n1; ++n4) {
                                n3 = n4 * DoubleDST_2D.this.n2 + 2 * n2;
                                n22 = n7 + n4;
                                ((DoubleDST_2D)DoubleDST_2D.this).t[n22] = dArray[n3];
                                ((DoubleDST_2D)DoubleDST_2D.this).t[n22 + ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n3 + 1];
                            }
                            if (n == -1) {
                                DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7, bl);
                                DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7 + DoubleDST_2D.this.n1, bl);
                            } else {
                                DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7, bl);
                                DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7 + DoubleDST_2D.this.n1, bl);
                            }
                            for (n4 = 0; n4 < DoubleDST_2D.this.n1; ++n4) {
                                n3 = n4 * DoubleDST_2D.this.n2 + 2 * n2;
                                n22 = n7 + n4;
                                dArray[n3] = DoubleDST_2D.this.t[n22];
                                dArray[n3 + 1] = DoubleDST_2D.this.t[n22 + DoubleDST_2D.this.n1];
                            }
                            break block17;
                        }
                        if (DoubleDST_2D.this.n2 != n6) break block17;
                        for (n11 = 0; n11 < DoubleDST_2D.this.n1; ++n11) {
                            ((DoubleDST_2D)DoubleDST_2D.this).t[n7 + n11] = dArray[n11 * DoubleDST_2D.this.n2 + n2];
                        }
                        if (n == -1) {
                            DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7, bl);
                        } else {
                            DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7, bl);
                        }
                        for (n11 = 0; n11 < DoubleDST_2D.this.n1; ++n11) {
                            dArray[n11 * ((DoubleDST_2D)DoubleDST_2D.this).n2 + n2] = DoubleDST_2D.this.t[n7 + n11];
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt2d_subth(final int n, final double[][] dArray, final boolean bl) {
        int n2;
        int n3;
        int n4 = n3 = ConcurrencyUtils.getNumberOfProcessors();
        int n5 = 4 * this.n1;
        if (this.n2 == 2 * n3) {
            n5 >>= 1;
        } else if (this.n2 < 2 * n3) {
            n4 = this.n2;
            n5 >>= 2;
        }
        final int n6 = n4;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            final int n7 = n5 * i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    block17: {
                        int n8;
                        block18: {
                            int n22;
                            int n3;
                            block16: {
                                if (DoubleDST_2D.this.n2 <= 2 * n6) break block16;
                                if (n == -1) {
                                    for (int i = 4 * n2; i < DoubleDST_2D.this.n2; i += 4 * n6) {
                                        int n4;
                                        int n5;
                                        for (n5 = 0; n5 < DoubleDST_2D.this.n1; ++n5) {
                                            n4 = n7 + DoubleDST_2D.this.n1 + n5;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n7 + n5] = dArray[n5][i];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n4] = dArray[n5][i + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n4 + ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n5][i + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n4 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n5][i + 3];
                                        }
                                        DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7, bl);
                                        DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7 + DoubleDST_2D.this.n1, bl);
                                        DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7 + 2 * DoubleDST_2D.this.n1, bl);
                                        DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7 + 3 * DoubleDST_2D.this.n1, bl);
                                        for (n5 = 0; n5 < DoubleDST_2D.this.n1; ++n5) {
                                            n4 = n7 + DoubleDST_2D.this.n1 + n5;
                                            dArray[n5][i] = DoubleDST_2D.this.t[n7 + n5];
                                            dArray[n5][i + 1] = DoubleDST_2D.this.t[n4];
                                            dArray[n5][i + 2] = DoubleDST_2D.this.t[n4 + DoubleDST_2D.this.n1];
                                            dArray[n5][i + 3] = DoubleDST_2D.this.t[n4 + 2 * DoubleDST_2D.this.n1];
                                        }
                                    }
                                } else {
                                    for (int i = 4 * n2; i < DoubleDST_2D.this.n2; i += 4 * n6) {
                                        int n62;
                                        int n72;
                                        for (n72 = 0; n72 < DoubleDST_2D.this.n1; ++n72) {
                                            n62 = n7 + DoubleDST_2D.this.n1 + n72;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n7 + n72] = dArray[n72][i];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n62] = dArray[n72][i + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n62 + ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n72][i + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[n62 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n72][i + 3];
                                        }
                                        DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7, bl);
                                        DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7 + DoubleDST_2D.this.n1, bl);
                                        DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7 + 2 * DoubleDST_2D.this.n1, bl);
                                        DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7 + 3 * DoubleDST_2D.this.n1, bl);
                                        for (n72 = 0; n72 < DoubleDST_2D.this.n1; ++n72) {
                                            n62 = n7 + DoubleDST_2D.this.n1 + n72;
                                            dArray[n72][i] = DoubleDST_2D.this.t[n7 + n72];
                                            dArray[n72][i + 1] = DoubleDST_2D.this.t[n62];
                                            dArray[n72][i + 2] = DoubleDST_2D.this.t[n62 + DoubleDST_2D.this.n1];
                                            dArray[n72][i + 3] = DoubleDST_2D.this.t[n62 + 2 * DoubleDST_2D.this.n1];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDST_2D.this.n2 != 2 * n6) break block18;
                            for (n3 = 0; n3 < DoubleDST_2D.this.n1; ++n3) {
                                n22 = n7 + n3;
                                ((DoubleDST_2D)DoubleDST_2D.this).t[n22] = dArray[n3][2 * n2];
                                ((DoubleDST_2D)DoubleDST_2D.this).t[n22 + ((DoubleDST_2D)DoubleDST_2D.this).n1] = dArray[n3][2 * n2 + 1];
                            }
                            if (n == -1) {
                                DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7, bl);
                                DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7 + DoubleDST_2D.this.n1, bl);
                            } else {
                                DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7, bl);
                                DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7 + DoubleDST_2D.this.n1, bl);
                            }
                            for (n3 = 0; n3 < DoubleDST_2D.this.n1; ++n3) {
                                n22 = n7 + n3;
                                dArray[n3][2 * n2] = DoubleDST_2D.this.t[n22];
                                dArray[n3][2 * n2 + 1] = DoubleDST_2D.this.t[n22 + DoubleDST_2D.this.n1];
                            }
                            break block17;
                        }
                        if (DoubleDST_2D.this.n2 != n6) break block17;
                        for (n8 = 0; n8 < DoubleDST_2D.this.n1; ++n8) {
                            ((DoubleDST_2D)DoubleDST_2D.this).t[n7 + n8] = dArray[n8][n2];
                        }
                        if (n == -1) {
                            DoubleDST_2D.this.dstn1.forward(DoubleDST_2D.this.t, n7, bl);
                        } else {
                            DoubleDST_2D.this.dstn1.inverse(DoubleDST_2D.this.t, n7, bl);
                        }
                        for (n8 = 0; n8 < DoubleDST_2D.this.n1; ++n8) {
                            dArray[n8][n2] = DoubleDST_2D.this.t[n7 + n8];
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt2d0_subth(final int n, final double[] dArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        final int n4 = n3 > this.n1 ? this.n1 : n3;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n2; i < DoubleDST_2D.this.n1; i += n4) {
                            DoubleDST_2D.this.dstn2.forward(dArray, i * DoubleDST_2D.this.n2, bl);
                        }
                    } else {
                        for (int i = n2; i < DoubleDST_2D.this.n1; i += n4) {
                            DoubleDST_2D.this.dstn2.inverse(dArray, i * DoubleDST_2D.this.n2, bl);
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt2d0_subth(final int n, final double[][] dArray, final boolean bl) {
        int n2;
        int n3 = ConcurrencyUtils.getNumberOfProcessors();
        final int n4 = n3 > this.n1 ? this.n1 : n3;
        Future[] futureArray = new Future[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = i;
            futureArray[i] = ConcurrencyUtils.threadPool.submit(new Runnable(){

                public void run() {
                    if (n == -1) {
                        for (int i = n2; i < DoubleDST_2D.this.n1; i += n4) {
                            DoubleDST_2D.this.dstn2.forward(dArray[i], bl);
                        }
                    } else {
                        for (int i = n2; i < DoubleDST_2D.this.n1; i += n4) {
                            DoubleDST_2D.this.dstn2.inverse(dArray[i], bl);
                        }
                    }
                }
            });
        }
        try {
            for (n2 = 0; n2 < n4; ++n2) {
                futureArray[n2].get();
            }
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void ddxt2d_sub(int n, double[] dArray, boolean bl) {
        block13: {
            int n2;
            int n3;
            block12: {
                if (this.n2 <= 2) break block12;
                if (n == -1) {
                    for (int i = 0; i < this.n2; i += 4) {
                        int n4;
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = n6 * this.n2 + i;
                            n4 = this.n1 + n6;
                            this.t[n6] = dArray[n5];
                            this.t[n4] = dArray[n5 + 1];
                            this.t[n4 + this.n1] = dArray[n5 + 2];
                            this.t[n4 + 2 * this.n1] = dArray[n5 + 3];
                        }
                        this.dstn1.forward(this.t, 0, bl);
                        this.dstn1.forward(this.t, this.n1, bl);
                        this.dstn1.forward(this.t, 2 * this.n1, bl);
                        this.dstn1.forward(this.t, 3 * this.n1, bl);
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = n6 * this.n2 + i;
                            n4 = this.n1 + n6;
                            dArray[n5] = this.t[n6];
                            dArray[n5 + 1] = this.t[n4];
                            dArray[n5 + 2] = this.t[n4 + this.n1];
                            dArray[n5 + 3] = this.t[n4 + 2 * this.n1];
                        }
                    }
                } else {
                    for (int i = 0; i < this.n2; i += 4) {
                        int n7;
                        int n8;
                        int n9;
                        for (n9 = 0; n9 < this.n1; ++n9) {
                            n8 = n9 * this.n2 + i;
                            n7 = this.n1 + n9;
                            this.t[n9] = dArray[n8];
                            this.t[n7] = dArray[n8 + 1];
                            this.t[n7 + this.n1] = dArray[n8 + 2];
                            this.t[n7 + 2 * this.n1] = dArray[n8 + 3];
                        }
                        this.dstn1.inverse(this.t, 0, bl);
                        this.dstn1.inverse(this.t, this.n1, bl);
                        this.dstn1.inverse(this.t, 2 * this.n1, bl);
                        this.dstn1.inverse(this.t, 3 * this.n1, bl);
                        for (n9 = 0; n9 < this.n1; ++n9) {
                            n8 = n9 * this.n2 + i;
                            n7 = this.n1 + n9;
                            dArray[n8] = this.t[n9];
                            dArray[n8 + 1] = this.t[n7];
                            dArray[n8 + 2] = this.t[n7 + this.n1];
                            dArray[n8 + 3] = this.t[n7 + 2 * this.n1];
                        }
                    }
                }
                break block13;
            }
            if (this.n2 != 2) break block13;
            for (n3 = 0; n3 < this.n1; ++n3) {
                n2 = n3 * this.n2;
                this.t[n3] = dArray[n2];
                this.t[this.n1 + n3] = dArray[n2 + 1];
            }
            if (n == -1) {
                this.dstn1.forward(this.t, 0, bl);
                this.dstn1.forward(this.t, this.n1, bl);
            } else {
                this.dstn1.inverse(this.t, 0, bl);
                this.dstn1.inverse(this.t, this.n1, bl);
            }
            for (n3 = 0; n3 < this.n1; ++n3) {
                n2 = n3 * this.n2;
                dArray[n2] = this.t[n3];
                dArray[n2 + 1] = this.t[this.n1 + n3];
            }
        }
    }

    private void ddxt2d_sub(int n, double[][] dArray, boolean bl) {
        block13: {
            int n2;
            block12: {
                if (this.n2 <= 2) break block12;
                if (n == -1) {
                    for (int i = 0; i < this.n2; i += 4) {
                        int n3;
                        int n4;
                        for (n4 = 0; n4 < this.n1; ++n4) {
                            n3 = this.n1 + n4;
                            this.t[n4] = dArray[n4][i];
                            this.t[n3] = dArray[n4][i + 1];
                            this.t[n3 + this.n1] = dArray[n4][i + 2];
                            this.t[n3 + 2 * this.n1] = dArray[n4][i + 3];
                        }
                        this.dstn1.forward(this.t, 0, bl);
                        this.dstn1.forward(this.t, this.n1, bl);
                        this.dstn1.forward(this.t, 2 * this.n1, bl);
                        this.dstn1.forward(this.t, 3 * this.n1, bl);
                        for (n4 = 0; n4 < this.n1; ++n4) {
                            n3 = this.n1 + n4;
                            dArray[n4][i] = this.t[n4];
                            dArray[n4][i + 1] = this.t[n3];
                            dArray[n4][i + 2] = this.t[n3 + this.n1];
                            dArray[n4][i + 3] = this.t[n3 + 2 * this.n1];
                        }
                    }
                } else {
                    for (int i = 0; i < this.n2; i += 4) {
                        int n5;
                        int n6;
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = this.n1 + n6;
                            this.t[n6] = dArray[n6][i];
                            this.t[n5] = dArray[n6][i + 1];
                            this.t[n5 + this.n1] = dArray[n6][i + 2];
                            this.t[n5 + 2 * this.n1] = dArray[n6][i + 3];
                        }
                        this.dstn1.inverse(this.t, 0, bl);
                        this.dstn1.inverse(this.t, this.n1, bl);
                        this.dstn1.inverse(this.t, 2 * this.n1, bl);
                        this.dstn1.inverse(this.t, 3 * this.n1, bl);
                        for (n6 = 0; n6 < this.n1; ++n6) {
                            n5 = this.n1 + n6;
                            dArray[n6][i] = this.t[n6];
                            dArray[n6][i + 1] = this.t[n5];
                            dArray[n6][i + 2] = this.t[n5 + this.n1];
                            dArray[n6][i + 3] = this.t[n5 + 2 * this.n1];
                        }
                    }
                }
                break block13;
            }
            if (this.n2 != 2) break block13;
            for (n2 = 0; n2 < this.n1; ++n2) {
                this.t[n2] = dArray[n2][0];
                this.t[this.n1 + n2] = dArray[n2][1];
            }
            if (n == -1) {
                this.dstn1.forward(this.t, 0, bl);
                this.dstn1.forward(this.t, this.n1, bl);
            } else {
                this.dstn1.inverse(this.t, 0, bl);
                this.dstn1.inverse(this.t, this.n1, bl);
            }
            for (n2 = 0; n2 < this.n1; ++n2) {
                dArray[n2][0] = this.t[n2];
                dArray[n2][1] = this.t[this.n1 + n2];
            }
        }
    }

    private void makewt(int n) {
        this.ip[0] = n;
        this.ip[1] = 1;
        if (n > 2) {
            int n2;
            int n3 = n >> 1;
            double d = Math.atan(1.0) / (double)n3;
            double d2 = Math.cos(d * (double)n3);
            this.w[0] = 1.0;
            this.w[1] = d2;
            if (n3 == 4) {
                this.w[2] = Math.cos(d * 2.0);
                this.w[3] = Math.sin(d * 2.0);
            } else if (n3 > 4) {
                this.makeipt(n);
                this.w[2] = 0.5 / Math.cos(d * 2.0);
                this.w[3] = 0.5 / Math.cos(d * 6.0);
                for (n2 = 4; n2 < n3; n2 += 4) {
                    this.w[n2] = Math.cos(d * (double)n2);
                    this.w[n2 + 1] = Math.sin(d * (double)n2);
                    this.w[n2 + 2] = Math.cos(3.0 * d * (double)n2);
                    this.w[n2 + 3] = -Math.sin(3.0 * d * (double)n2);
                }
            }
            int n4 = 0;
            while (n3 > 2) {
                double d3;
                double d4;
                int n5 = n4 + n3;
                this.w[n5] = 1.0;
                this.w[n5 + 1] = d2;
                if ((n3 >>= 1) == 4) {
                    d4 = this.w[n4 + 4];
                    d3 = this.w[n4 + 5];
                    this.w[n5 + 2] = d4;
                    this.w[n5 + 3] = d3;
                } else if (n3 > 4) {
                    d4 = this.w[n4 + 4];
                    double d5 = this.w[n4 + 6];
                    this.w[n5 + 2] = 0.5 / d4;
                    this.w[n5 + 3] = 0.5 / d5;
                    for (n2 = 4; n2 < n3; n2 += 4) {
                        int n6 = n4 + 2 * n2;
                        int n7 = n5 + n2;
                        d4 = this.w[n6];
                        d3 = this.w[n6 + 1];
                        d5 = this.w[n6 + 2];
                        double d6 = this.w[n6 + 3];
                        this.w[n7] = d4;
                        this.w[n7 + 1] = d3;
                        this.w[n7 + 2] = d5;
                        this.w[n7 + 3] = d6;
                    }
                }
                n4 = n5;
            }
        }
    }

    private void makeipt(int n) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int n2 = 2;
        for (int i = n; i > 32; i >>= 2) {
            int n3 = n2 << 1;
            int n4 = n3 << 3;
            for (int j = n2; j < n3; ++j) {
                int n5;
                this.ip[n2 + j] = n5 = this.ip[j] << 2;
                this.ip[n3 + j] = n5 + n4;
            }
            n2 = n3;
        }
    }

    private void makect(int n, double[] dArray, int n2) {
        this.ip[1] = n;
        if (n > 1) {
            int n3 = n >> 1;
            double d = Math.atan(1.0) / (double)n3;
            dArray[n2] = Math.cos(d * (double)n3);
            dArray[n2 + n3] = 0.5 * dArray[n2];
            for (int i = 1; i < n3; ++i) {
                dArray[n2 + i] = 0.5 * Math.cos(d * (double)i);
                dArray[n2 + n - i] = 0.5 * Math.sin(d * (double)i);
            }
        }
    }
}

