require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NETINET6_IN6_H_)) {
    eval 'sub _NETINET6_IN6_H_ () {1;}' unless defined(&_NETINET6_IN6_H_);
    require 'sys/featuretest.ph';
    unless(defined(&__KAME_NETINET_IN_H_INCLUDED_)) {
	die("do not include netinet6/in6.h directly, include netinet/in.h.  see RFC2553");
    }
    require 'sys/socket.ph';
    require 'sys/endian.ph';
    eval 'sub __KAME__ () {1;}' unless defined(&__KAME__);
    eval 'sub __KAME_VERSION () {"NetBSD-current";}' unless defined(&__KAME_VERSION);
    if(defined(&_NETBSD_SOURCE)) {
	eval 'sub IPV6PORT_RESERVED () {1024;}' unless defined(&IPV6PORT_RESERVED);
	eval 'sub IPV6PORT_ANONMIN () {49152;}' unless defined(&IPV6PORT_ANONMIN);
	eval 'sub IPV6PORT_ANONMAX () {65535;}' unless defined(&IPV6PORT_ANONMAX);
	eval 'sub IPV6PORT_RESERVEDMIN () {600;}' unless defined(&IPV6PORT_RESERVEDMIN);
	eval 'sub IPV6PORT_RESERVEDMAX () {( &IPV6PORT_RESERVED-1);}' unless defined(&IPV6PORT_RESERVEDMAX);
    }
    eval 'sub s6_addr () { ($__u6_addr->{__u6_addr8});}' unless defined(&s6_addr);
    if(defined(&_KERNEL)) {
	eval 'sub s6_addr8 () { ($__u6_addr->{__u6_addr8});}' unless defined(&s6_addr8);
	eval 'sub s6_addr16 () { ($__u6_addr->{__u6_addr16});}' unless defined(&s6_addr16);
	eval 'sub s6_addr32 () { ($__u6_addr->{__u6_addr32});}' unless defined(&s6_addr32);
    }
    eval 'sub INET6_ADDRSTRLEN () {46;}' unless defined(&INET6_ADDRSTRLEN);
    if(defined(&_NETBSD_SOURCE)) {
	eval 'sub SIN6_LEN () {1;}' unless defined(&SIN6_LEN);
    }
    if(defined(&_KERNEL)) {
	eval 'sub IN6MASK0 () {{{{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}};}' unless defined(&IN6MASK0);
	eval 'sub IN6MASK32 () {{{{ 0xff, 0xff, 0xff, 0xff, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6MASK32);
	eval 'sub IN6MASK64 () {{{{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6MASK64);
	eval 'sub IN6MASK96 () {{{{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6MASK96);
	eval 'sub IN6MASK128 () {{{{ 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff }}};}' unless defined(&IN6MASK128);
    }
    if(defined(&_KERNEL)) {
    }
    if(defined(&_KERNEL)) {
	if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : undef)) {
	    eval 'sub IPV6_ADDR_INT32_ONE () {1;}' unless defined(&IPV6_ADDR_INT32_ONE);
	    eval 'sub IPV6_ADDR_INT32_TWO () {2;}' unless defined(&IPV6_ADDR_INT32_TWO);
	    eval 'sub IPV6_ADDR_INT32_MNL () {0xff010000;}' unless defined(&IPV6_ADDR_INT32_MNL);
	    eval 'sub IPV6_ADDR_INT32_MLL () {0xff020000;}' unless defined(&IPV6_ADDR_INT32_MLL);
	    eval 'sub IPV6_ADDR_INT32_SMP () {0xffff;}' unless defined(&IPV6_ADDR_INT32_SMP);
	    eval 'sub IPV6_ADDR_INT16_ULL () {0xfe80;}' unless defined(&IPV6_ADDR_INT16_ULL);
	    eval 'sub IPV6_ADDR_INT16_USL () {0xfec0;}' unless defined(&IPV6_ADDR_INT16_USL);
	    eval 'sub IPV6_ADDR_INT16_MLL () {0xff02;}' unless defined(&IPV6_ADDR_INT16_MLL);
	}
 elsif((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
	    eval 'sub IPV6_ADDR_INT32_ONE () {0x1000000;}' unless defined(&IPV6_ADDR_INT32_ONE);
	    eval 'sub IPV6_ADDR_INT32_TWO () {0x2000000;}' unless defined(&IPV6_ADDR_INT32_TWO);
	    eval 'sub IPV6_ADDR_INT32_MNL () {0x1ff;}' unless defined(&IPV6_ADDR_INT32_MNL);
	    eval 'sub IPV6_ADDR_INT32_MLL () {0x2ff;}' unless defined(&IPV6_ADDR_INT32_MLL);
	    eval 'sub IPV6_ADDR_INT32_SMP () {0xffff0000;}' unless defined(&IPV6_ADDR_INT32_SMP);
	    eval 'sub IPV6_ADDR_INT16_ULL () {0x80fe;}' unless defined(&IPV6_ADDR_INT16_ULL);
	    eval 'sub IPV6_ADDR_INT16_USL () {0xc0fe;}' unless defined(&IPV6_ADDR_INT16_USL);
	    eval 'sub IPV6_ADDR_INT16_MLL () {0x2ff;}' unless defined(&IPV6_ADDR_INT16_MLL);
	}
    }
    eval 'sub IN6ADDR_ANY_INIT () {{{{ 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x }}};}' unless defined(&IN6ADDR_ANY_INIT);
    eval 'sub IN6ADDR_LOOPBACK_INIT () {{{{ 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_LOOPBACK_INIT);
    eval 'sub IN6ADDR_NODELOCAL_ALLNODES_INIT () {{{{ 0xff, 0x1, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_NODELOCAL_ALLNODES_INIT);
    eval 'sub IN6ADDR_LINKLOCAL_ALLNODES_INIT () {{{{ 0xff, 0x2, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x1 }}};}' unless defined(&IN6ADDR_LINKLOCAL_ALLNODES_INIT);
    eval 'sub IN6ADDR_LINKLOCAL_ALLROUTERS_INIT () {{{{ 0xff, 0x2, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x, 0x2 }}};}' unless defined(&IN6ADDR_LINKLOCAL_ALLROUTERS_INIT);
    eval 'sub IN6_ARE_ADDR_EQUAL {
        my($a, $b) = @_;
	    eval q(( &memcmp(($a)-> $s6_addr[0], ($b)-> $s6_addr[0], $sizeof{\'struct in6_addr\'}) == 0));
    }' unless defined(&IN6_ARE_ADDR_EQUAL);
    eval 'sub IN6_IS_ADDR_UNSPECIFIED {
        my($a) = @_;
	    eval q((($a)-> ($__u6_addr->{__u6_addr32[0]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[1]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[2]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[3]}) == 0));
    }' unless defined(&IN6_IS_ADDR_UNSPECIFIED);
    eval 'sub IN6_IS_ADDR_LOOPBACK {
        my($a) = @_;
	    eval q((($a)-> ($__u6_addr->{__u6_addr32[0]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[1]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[2]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[3]}) ==  &ntohl(1)));
    }' unless defined(&IN6_IS_ADDR_LOOPBACK);
    eval 'sub IN6_IS_ADDR_V4COMPAT {
        my($a) = @_;
	    eval q((($a)-> ($__u6_addr->{__u6_addr32[0]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[1]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[2]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[3]}) != 0 && ($a)-> ($__u6_addr->{__u6_addr32[3]}) !=  &ntohl(1)));
    }' unless defined(&IN6_IS_ADDR_V4COMPAT);
    eval 'sub IN6_IS_ADDR_V4MAPPED {
        my($a) = @_;
	    eval q((($a)-> ($__u6_addr->{__u6_addr32[0]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[1]}) == 0 && ($a)-> ($__u6_addr->{__u6_addr32[2]}) ==  &ntohl(0xffff)));
    }' unless defined(&IN6_IS_ADDR_V4MAPPED);
    if(defined(&_KERNEL)) {
	eval 'sub IPV6_ADDR_SCOPE_NODELOCAL () {0x1;}' unless defined(&IPV6_ADDR_SCOPE_NODELOCAL);
	eval 'sub IPV6_ADDR_SCOPE_INTFACELOCAL () {0x1;}' unless defined(&IPV6_ADDR_SCOPE_INTFACELOCAL);
	eval 'sub IPV6_ADDR_SCOPE_LINKLOCAL () {0x2;}' unless defined(&IPV6_ADDR_SCOPE_LINKLOCAL);
	eval 'sub IPV6_ADDR_SCOPE_SITELOCAL () {0x5;}' unless defined(&IPV6_ADDR_SCOPE_SITELOCAL);
	eval 'sub IPV6_ADDR_SCOPE_ORGLOCAL () {0x8;}' unless defined(&IPV6_ADDR_SCOPE_ORGLOCAL);
	eval 'sub IPV6_ADDR_SCOPE_GLOBAL () {0xe;}' unless defined(&IPV6_ADDR_SCOPE_GLOBAL);
    } else {
	eval 'sub __IPV6_ADDR_SCOPE_NODELOCAL () {0x1;}' unless defined(&__IPV6_ADDR_SCOPE_NODELOCAL);
	eval 'sub __IPV6_ADDR_SCOPE_LINKLOCAL () {0x2;}' unless defined(&__IPV6_ADDR_SCOPE_LINKLOCAL);
	eval 'sub __IPV6_ADDR_SCOPE_SITELOCAL () {0x5;}' unless defined(&__IPV6_ADDR_SCOPE_SITELOCAL);
	eval 'sub __IPV6_ADDR_SCOPE_ORGLOCAL () {0x8;}' unless defined(&__IPV6_ADDR_SCOPE_ORGLOCAL);
	eval 'sub __IPV6_ADDR_SCOPE_GLOBAL () {0xe;}' unless defined(&__IPV6_ADDR_SCOPE_GLOBAL);
    }
    eval 'sub IN6_IS_ADDR_LINKLOCAL {
        my($a) = @_;
	    eval q(((($a)-> $s6_addr[0] == 0xfe)  && ((($a)-> $s6_addr[1] & 0xc0) == 0x80)));
    }' unless defined(&IN6_IS_ADDR_LINKLOCAL);
    eval 'sub IN6_IS_ADDR_SITELOCAL {
        my($a) = @_;
	    eval q(((($a)-> $s6_addr[0] == 0xfe)  && ((($a)-> $s6_addr[1] & 0xc0) == 0xc0)));
    }' unless defined(&IN6_IS_ADDR_SITELOCAL);
    eval 'sub IN6_IS_ADDR_MULTICAST {
        my($a) = @_;
	    eval q((($a)-> $s6_addr[0] == 0xff));
    }' unless defined(&IN6_IS_ADDR_MULTICAST);
    if(defined(&_KERNEL)) {
	eval 'sub IPV6_ADDR_MC_SCOPE {
	    my($a) = @_;
    	    eval q((($a)-> $s6_addr[1] & 0xf));
	}' unless defined(&IPV6_ADDR_MC_SCOPE);
    } else {
	eval 'sub __IPV6_ADDR_MC_SCOPE {
	    my($a) = @_;
    	    eval q((($a)-> $s6_addr[1] & 0xf));
	}' unless defined(&__IPV6_ADDR_MC_SCOPE);
    }
    if(defined(&_KERNEL)) {
	eval 'sub IN6_IS_ADDR_MC_NODELOCAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_NODELOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_NODELOCAL);
	eval 'sub IN6_IS_ADDR_MC_INTFACELOCAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_INTFACELOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_INTFACELOCAL);
	eval 'sub IN6_IS_ADDR_MC_LINKLOCAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_LINKLOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_LINKLOCAL);
	eval 'sub IN6_IS_ADDR_MC_SITELOCAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_SITELOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_SITELOCAL);
	eval 'sub IN6_IS_ADDR_MC_ORGLOCAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_ORGLOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_ORGLOCAL);
	eval 'sub IN6_IS_ADDR_MC_GLOBAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &IPV6_ADDR_MC_SCOPE($a) ==  &IPV6_ADDR_SCOPE_GLOBAL)));
	}' unless defined(&IN6_IS_ADDR_MC_GLOBAL);
    } else {
	eval 'sub IN6_IS_ADDR_MC_NODELOCAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_NODELOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_NODELOCAL);
	eval 'sub IN6_IS_ADDR_MC_LINKLOCAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_LINKLOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_LINKLOCAL);
	eval 'sub IN6_IS_ADDR_MC_SITELOCAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_SITELOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_SITELOCAL);
	eval 'sub IN6_IS_ADDR_MC_ORGLOCAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_ORGLOCAL)));
	}' unless defined(&IN6_IS_ADDR_MC_ORGLOCAL);
	eval 'sub IN6_IS_ADDR_MC_GLOBAL {
	    my($a) = @_;
    	    eval q(( &IN6_IS_ADDR_MULTICAST($a)  && ( &__IPV6_ADDR_MC_SCOPE($a) ==  &__IPV6_ADDR_SCOPE_GLOBAL)));
	}' unless defined(&IN6_IS_ADDR_MC_GLOBAL);
    }
    if(defined(&_KERNEL)) {
	eval 'sub IN6_IS_SCOPE_LINKLOCAL {
	    my($a) = @_;
    	    eval q((( &IN6_IS_ADDR_LINKLOCAL($a)) || ( &IN6_IS_ADDR_MC_LINKLOCAL($a))));
	}' unless defined(&IN6_IS_SCOPE_LINKLOCAL);
	eval 'sub IN6_IS_SCOPE_EMBEDDABLE {
	    my($__a) = @_;
    	    eval q(( &IN6_IS_SCOPE_LINKLOCAL($__a) ||  &IN6_IS_ADDR_MC_INTFACELOCAL($__a)));
	}' unless defined(&IN6_IS_SCOPE_EMBEDDABLE);
	eval 'sub IFA6_IS_DEPRECATED {
	    my($a) = @_;
    	    eval q((($a)-> ($i$a6_lifetime->{i$a6t_pltime}) !=  &ND6_INFINITE_LIFETIME  && ( &u_int32_t)(( &time_uptime - ($a)-> &ia6_updatetime)) > ($a)-> ($i$a6_lifetime->{i$a6t_pltime})));
	}' unless defined(&IFA6_IS_DEPRECATED);
	eval 'sub IFA6_IS_INVALID {
	    my($a) = @_;
    	    eval q((($a)-> ($i$a6_lifetime->{i$a6t_vltime}) !=  &ND6_INFINITE_LIFETIME  && ( &u_int32_t)(( &time_uptime - ($a)-> &ia6_updatetime)) > ($a)-> ($i$a6_lifetime->{i$a6t_vltime})));
	}' unless defined(&IFA6_IS_INVALID);
    }
    if(0) {
	eval 'sub IPV6_OPTIONS () {1;}' unless defined(&IPV6_OPTIONS);
	eval 'sub IPV6_RECVOPTS () {5;}' unless defined(&IPV6_RECVOPTS);
	eval 'sub IPV6_RECVRETOPTS () {6;}' unless defined(&IPV6_RECVRETOPTS);
	eval 'sub IPV6_RECVDSTADDR () {7;}' unless defined(&IPV6_RECVDSTADDR);
	eval 'sub IPV6_RETOPTS () {8;}' unless defined(&IPV6_RETOPTS);
    }
    eval 'sub IPV6_SOCKOPT_RESERVED1 () {3;}' unless defined(&IPV6_SOCKOPT_RESERVED1);
    eval 'sub IPV6_UNICAST_HOPS () {4;}' unless defined(&IPV6_UNICAST_HOPS);
    eval 'sub IPV6_MULTICAST_IF () {9;}' unless defined(&IPV6_MULTICAST_IF);
    eval 'sub IPV6_MULTICAST_HOPS () {10;}' unless defined(&IPV6_MULTICAST_HOPS);
    eval 'sub IPV6_MULTICAST_LOOP () {11;}' unless defined(&IPV6_MULTICAST_LOOP);
    eval 'sub IPV6_JOIN_GROUP () {12;}' unless defined(&IPV6_JOIN_GROUP);
    eval 'sub IPV6_LEAVE_GROUP () {13;}' unless defined(&IPV6_LEAVE_GROUP);
    eval 'sub IPV6_PORTRANGE () {14;}' unless defined(&IPV6_PORTRANGE);
    if(defined(&_NETBSD_SOURCE)) {
	eval 'sub IPV6_PORTALGO () {17;}' unless defined(&IPV6_PORTALGO);
	eval 'sub ICMP6_FILTER () {18;}' unless defined(&ICMP6_FILTER);
    }
    if(defined(&_KERNEL)) {
	eval 'sub IPV6_2292PKTINFO () {19;}' unless defined(&IPV6_2292PKTINFO);
	eval 'sub IPV6_2292HOPLIMIT () {20;}' unless defined(&IPV6_2292HOPLIMIT);
	eval 'sub IPV6_2292NEXTHOP () {21;}' unless defined(&IPV6_2292NEXTHOP);
	eval 'sub IPV6_2292HOPOPTS () {22;}' unless defined(&IPV6_2292HOPOPTS);
	eval 'sub IPV6_2292DSTOPTS () {23;}' unless defined(&IPV6_2292DSTOPTS);
	eval 'sub IPV6_2292RTHDR () {24;}' unless defined(&IPV6_2292RTHDR);
	eval 'sub IPV6_2292PKTOPTIONS () {25;}' unless defined(&IPV6_2292PKTOPTIONS);
    }
    eval 'sub IPV6_CHECKSUM () {26;}' unless defined(&IPV6_CHECKSUM);
    eval 'sub IPV6_V6ONLY () {27;}' unless defined(&IPV6_V6ONLY);
    eval 'sub IPV6_IPSEC_POLICY () {28;}' unless defined(&IPV6_IPSEC_POLICY);
    eval 'sub IPV6_FAITH () {29;}' unless defined(&IPV6_FAITH);
    eval 'sub IPV6_RTHDRDSTOPTS () {35;}' unless defined(&IPV6_RTHDRDSTOPTS);
    eval 'sub IPV6_RECVPKTINFO () {36;}' unless defined(&IPV6_RECVPKTINFO);
    eval 'sub IPV6_RECVHOPLIMIT () {37;}' unless defined(&IPV6_RECVHOPLIMIT);
    eval 'sub IPV6_RECVRTHDR () {38;}' unless defined(&IPV6_RECVRTHDR);
    eval 'sub IPV6_RECVHOPOPTS () {39;}' unless defined(&IPV6_RECVHOPOPTS);
    eval 'sub IPV6_RECVDSTOPTS () {40;}' unless defined(&IPV6_RECVDSTOPTS);
    if(defined(&_KERNEL)) {
	eval 'sub IPV6_RECVRTHDRDSTOPTS () {41;}' unless defined(&IPV6_RECVRTHDRDSTOPTS);
    }
    eval 'sub IPV6_USE_MIN_MTU () {42;}' unless defined(&IPV6_USE_MIN_MTU);
    eval 'sub IPV6_RECVPATHMTU () {43;}' unless defined(&IPV6_RECVPATHMTU);
    eval 'sub IPV6_PATHMTU () {44;}' unless defined(&IPV6_PATHMTU);
    eval 'sub IPV6_PKTINFO () {46;}' unless defined(&IPV6_PKTINFO);
    eval 'sub IPV6_HOPLIMIT () {47;}' unless defined(&IPV6_HOPLIMIT);
    eval 'sub IPV6_NEXTHOP () {48;}' unless defined(&IPV6_NEXTHOP);
    eval 'sub IPV6_HOPOPTS () {49;}' unless defined(&IPV6_HOPOPTS);
    eval 'sub IPV6_DSTOPTS () {50;}' unless defined(&IPV6_DSTOPTS);
    eval 'sub IPV6_RTHDR () {51;}' unless defined(&IPV6_RTHDR);
    eval 'sub IPV6_RECVTCLASS () {57;}' unless defined(&IPV6_RECVTCLASS);
    if(defined(&_KERNEL)) {
	eval 'sub IPV6_OTCLASS () {58;}' unless defined(&IPV6_OTCLASS);
    }
    eval 'sub IPV6_TCLASS () {61;}' unless defined(&IPV6_TCLASS);
    eval 'sub IPV6_DONTFRAG () {62;}' unless defined(&IPV6_DONTFRAG);
    eval 'sub IPV6_PREFER_TEMPADDR () {63;}' unless defined(&IPV6_PREFER_TEMPADDR);
    eval 'sub IPV6_BINDANY () {64;}' unless defined(&IPV6_BINDANY);
    eval 'sub IPV6_RTHDR_LOOSE () {0;}' unless defined(&IPV6_RTHDR_LOOSE);
    eval 'sub IPV6_RTHDR_STRICT () {1;}' unless defined(&IPV6_RTHDR_STRICT);
    eval 'sub IPV6_RTHDR_TYPE_0 () {0;}' unless defined(&IPV6_RTHDR_TYPE_0);
    eval 'sub IPV6_DEFAULT_MULTICAST_HOPS () {1;}' unless defined(&IPV6_DEFAULT_MULTICAST_HOPS);
    eval 'sub IPV6_DEFAULT_MULTICAST_LOOP () {1;}' unless defined(&IPV6_DEFAULT_MULTICAST_LOOP);
    eval 'sub IPV6_PORTRANGE_DEFAULT () {0;}' unless defined(&IPV6_PORTRANGE_DEFAULT);
    eval 'sub IPV6_PORTRANGE_HIGH () {1;}' unless defined(&IPV6_PORTRANGE_HIGH);
    eval 'sub IPV6_PORTRANGE_LOW () {2;}' unless defined(&IPV6_PORTRANGE_LOW);
    if(defined(&_NETBSD_SOURCE)) {
	eval 'sub IPV6CTL_FORWARDING () {1;}' unless defined(&IPV6CTL_FORWARDING);
	eval 'sub IPV6CTL_SENDREDIRECTS () {2;}' unless defined(&IPV6CTL_SENDREDIRECTS);
	eval 'sub IPV6CTL_DEFHLIM () {3;}' unless defined(&IPV6CTL_DEFHLIM);
	eval 'sub IPV6CTL_FORWSRCRT () {5;}' unless defined(&IPV6CTL_FORWSRCRT);
	eval 'sub IPV6CTL_STATS () {6;}' unless defined(&IPV6CTL_STATS);
	eval 'sub IPV6CTL_MRTSTATS () {7;}' unless defined(&IPV6CTL_MRTSTATS);
	eval 'sub IPV6CTL_MRTPROTO () {8;}' unless defined(&IPV6CTL_MRTPROTO);
	eval 'sub IPV6CTL_MAXFRAGPACKETS () {9;}' unless defined(&IPV6CTL_MAXFRAGPACKETS);
	eval 'sub IPV6CTL_SOURCECHECK () {10;}' unless defined(&IPV6CTL_SOURCECHECK);
	eval 'sub IPV6CTL_SOURCECHECK_LOGINT () {11;}' unless defined(&IPV6CTL_SOURCECHECK_LOGINT);
	eval 'sub IPV6CTL_KEEPFAITH () {13;}' unless defined(&IPV6CTL_KEEPFAITH);
	eval 'sub IPV6CTL_LOG_INTERVAL () {14;}' unless defined(&IPV6CTL_LOG_INTERVAL);
	eval 'sub IPV6CTL_HDRNESTLIMIT () {15;}' unless defined(&IPV6CTL_HDRNESTLIMIT);
	eval 'sub IPV6CTL_DAD_COUNT () {16;}' unless defined(&IPV6CTL_DAD_COUNT);
	eval 'sub IPV6CTL_AUTO_FLOWLABEL () {17;}' unless defined(&IPV6CTL_AUTO_FLOWLABEL);
	eval 'sub IPV6CTL_DEFMCASTHLIM () {18;}' unless defined(&IPV6CTL_DEFMCASTHLIM);
	eval 'sub IPV6CTL_GIF_HLIM () {19;}' unless defined(&IPV6CTL_GIF_HLIM);
	eval 'sub IPV6CTL_KAME_VERSION () {20;}' unless defined(&IPV6CTL_KAME_VERSION);
	eval 'sub IPV6CTL_USE_DEPRECATED () {21;}' unless defined(&IPV6CTL_USE_DEPRECATED);
	eval 'sub IPV6CTL_V6ONLY () {24;}' unless defined(&IPV6CTL_V6ONLY);
	eval 'sub IPV6CTL_ANONPORTMIN () {28;}' unless defined(&IPV6CTL_ANONPORTMIN);
	eval 'sub IPV6CTL_ANONPORTMAX () {29;}' unless defined(&IPV6CTL_ANONPORTMAX);
	eval 'sub IPV6CTL_LOWPORTMIN () {30;}' unless defined(&IPV6CTL_LOWPORTMIN);
	eval 'sub IPV6CTL_LOWPORTMAX () {31;}' unless defined(&IPV6CTL_LOWPORTMAX);
	eval 'sub IPV6CTL_AUTO_LINKLOCAL () {35;}' unless defined(&IPV6CTL_AUTO_LINKLOCAL);
	eval 'sub IPV6CTL_ADDRCTLPOLICY () {38;}' unless defined(&IPV6CTL_ADDRCTLPOLICY);
	eval 'sub IPV6CTL_USE_DEFAULTZONE () {39;}' unless defined(&IPV6CTL_USE_DEFAULTZONE);
	eval 'sub IPV6CTL_MAXFRAGS () {41;}' unless defined(&IPV6CTL_MAXFRAGS);
	eval 'sub IPV6CTL_IFQ () {42;}' unless defined(&IPV6CTL_IFQ);
	eval 'sub IPV6CTL_GIF_PMTU () {45;}' unless defined(&IPV6CTL_GIF_PMTU);
	eval 'sub IPV6CTL_IPSEC_HLIM () {46;}' unless defined(&IPV6CTL_IPSEC_HLIM);
	eval 'sub IPV6CTL_IPSEC_PMTU () {47;}' unless defined(&IPV6CTL_IPSEC_PMTU);
    }
    if(defined(&_KERNEL)) {
	eval 'sub satosin6 {
	    my($sa) = @_;
    	    eval q((($sa)));
	}' unless defined(&satosin6);
	eval 'sub satocsin6 {
	    my($sa) = @_;
    	    eval q((( &const \'struct sockaddr_in6\' *)($sa)));
	}' unless defined(&satocsin6);
	eval 'sub sin6tosa {
	    my($sin6) = @_;
    	    eval q((($sin6)));
	}' unless defined(&sin6tosa);
	eval 'sub sin6tocsa {
	    my($sin6) = @_;
    	    eval q((( &const \'struct sockaddr\' *)($sin6)));
	}' unless defined(&sin6tocsa);
	eval 'sub ifatoia6 {
	    my($ifa) = @_;
    	    eval q((($ifa)));
	}' unless defined(&ifatoia6);
	eval 'sub sockaddr_in6_init1 {
	    my($sin6,$addr,$port,$flowinfo,$scope_id) = @_;
    	    eval q({  ($sin6->{sin6_port}) = $port;  ($sin6->{sin6_flowinfo}) = $flowinfo;  ($sin6->{sin6_addr}) = *$addr;  ($sin6->{sin6_scope_id}) = $scope_id; });
	}' unless defined(&sockaddr_in6_init1);
	eval 'sub sockaddr_in6_init {
	    my($sin6,$addr,$port,$flowinfo,$scope_id) = @_;
    	    eval q({  ($sin6->{sin6_family}) =  &AF_INET6;  ($sin6->{sin6_len}) = $sizeof{$sin6};  &sockaddr_in6_init1($sin6, $addr, $port, $flowinfo, $scope_id); });
	}' unless defined(&sockaddr_in6_init);
	eval 'sub sockaddr_in6_alloc {
	    my($addr,$port,$flowinfo,$scope_id,$flags) = @_;
    	    eval q({ \'struct sockaddr\' * &sa;  &if (( &sa =  &sockaddr_alloc( &AF_INET6, $sizeof{\'struct sockaddr_in6\'}, $flags)) ==  &NULL)  &NULL;  &sockaddr_in6_init1( &satosin6( &sa), $addr, $port, $flowinfo, $scope_id);  &sa; });
	}' unless defined(&sockaddr_in6_alloc);
    }
    if(defined(&_NETBSD_SOURCE)) {
	require 'machine/ansi.ph';
	if(defined(&_BSD_SIZE_T_)) {
	    eval 'sub _SIZE_T () {1;}' unless defined(&_SIZE_T);
	    undef(&_BSD_SIZE_T_) if defined(&_BSD_SIZE_T_);
	}
	require 'sys/cdefs.ph';
	eval 'sub INET6_IS_ADDR_LINKLOCAL () {1;}' unless defined(&INET6_IS_ADDR_LINKLOCAL);
	eval 'sub INET6_IS_ADDR_MC_LINKLOCAL () {2;}' unless defined(&INET6_IS_ADDR_MC_LINKLOCAL);
	eval 'sub INET6_IS_ADDR_SITELOCAL () {4;}' unless defined(&INET6_IS_ADDR_SITELOCAL);
	if(0) {
	}
    }
    if(defined(&_KERNEL) || defined(&_TEST)) {
	eval 'sub IN6_PRINT {
	    my($b, $a) = @_;
    	    eval q(( &in6_print(($b), $sizeof{$b}, ($a)), ($b)));
	}' unless defined(&IN6_PRINT);
    }
}
1;
