/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Test;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public final class NodeTypeTest
extends Test {
    final short type;
    final String data;

    public final short getNodeType() {
        return this.type;
    }

    public final String getData() {
        return this.data;
    }

    public final boolean matches(Node node2, int n, int n2) {
        short s = node2.getNodeType();
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                return this.type <= 0 || s == this.type;
            }
            case 7: {
                if (this.type > 0) {
                    if (s != this.type) {
                        return false;
                    }
                    if (this.data != null && !this.data.equals(((ProcessingInstruction)node2).getTarget())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public final Test clone(Object object) {
        return new NodeTypeTest(this.type, this.data);
    }

    public final boolean references(QName qName) {
        return false;
    }

    public final String toString() {
        switch (this.type) {
            case 0: {
                return "node()";
            }
            case 3: {
                return "text()";
            }
            case 8: {
                return "comment()";
            }
            case 7: {
                if (this.data != null) {
                    return "processing-instruction('" + this.data + "')";
                }
                return "processing-instruction()";
            }
        }
        throw new IllegalStateException();
    }

    public NodeTypeTest(short s) {
        this(s, null);
    }

    public NodeTypeTest(short s, String string) {
        this.type = s;
        this.data = string;
    }
}

