/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.WireParseException;

public class Name
implements Comparable {
    private static final int LABEL_NORMAL = 0;
    private static final int LABEL_COMPRESSION = 192;
    private static final int LABEL_MASK = 192;
    private static final byte[] emptyLabel = new byte[1];
    private static final byte[] wildLabel = new byte[]{1, 42};
    public static final Name root;
    public static final Name empty;
    private static final int MAXNAME = 255;
    private static final int MAXLABEL = 63;
    private static final int MAXLABELS = 128;
    private static final int MAXOFFSETS = 7;
    private static final DecimalFormat byteFormat;
    private static final byte[] lowercase;
    private static final Name wild;
    private byte[] name;
    private long offsets;
    private int hashcode;

    private final void dump(String string) {
        String string2;
        try {
            string2 = this.toString();
        }
        catch (Exception exception) {
            string2 = "<unprintable>";
        }
        System.out.println(string + ": " + string2);
        int n = this.labels();
        int n2 = 0;
        while (n2 < n) {
            System.out.print("" + this.offset(n2) + ' ');
            ++n2;
        }
        System.out.println("");
        n2 = 0;
        while (this.name != null && n2 < this.name.length) {
            System.out.print("" + (this.name[n2] & 0xFF) + ' ');
            ++n2;
        }
        System.out.println("");
    }

    private final void setoffset(int n, int n2) {
        if (n >= 7) {
            return;
        }
        int n3 = 8 * (7 - n);
        this.offsets &= 255L << n3 ^ -1L;
        this.offsets |= (long)n2 << n3;
    }

    private final int offset(int n) {
        if (n == 0 && this.getlabels() == 0) {
            return 0;
        }
        if (n < 0 || n >= this.getlabels()) {
            throw new IllegalArgumentException("label out of range");
        }
        if (n < 7) {
            int n2 = 8 * (7 - n);
            return (int)(this.offsets >>> n2) & 0xFF;
        }
        int n3 = this.offset(6);
        int n4 = 6;
        while (n4 < n) {
            n3 += this.name[n3] + 1;
            ++n4;
        }
        return n3;
    }

    private final void setlabels(int n) {
        this.offsets &= 0xFFFFFFFFFFFFFF00L;
        this.offsets |= (long)n;
    }

    private final int getlabels() {
        return (int)(this.offsets & 0xFFL);
    }

    private static final void copy(Name name, Name name2) {
        if (name.offset(0) == 0) {
            name2.name = name.name;
            name2.offsets = name.offsets;
        } else {
            int n = name.offset(0);
            int n2 = name.name.length - n;
            int n3 = name.labels();
            name2.name = new byte[n2];
            System.arraycopy(name.name, n, name2.name, 0, n2);
            int n4 = 0;
            while (n4 < n3 && n4 < 7) {
                name2.setoffset(n4, name.offset(n4) - n);
                ++n4;
            }
            name2.setlabels(n3);
        }
    }

    private final void append(byte[] byArray, int n, int n2) throws NameTooLongException {
        int n3;
        int n4 = 0;
        if (this.name != null) {
            n4 = this.name.length - this.offset(0);
        }
        int n5 = n4;
        int n6 = 0;
        int n7 = 0;
        int n8 = n;
        while (n7 < n2) {
            n3 = byArray[n8];
            if (n3 > 63) {
                throw new IllegalStateException("invalid label");
            }
            n8 += ++n3;
            n6 += n3;
            ++n7;
        }
        n7 = n5 + n6;
        if (n7 > 255) {
            throw new NameTooLongException();
        }
        n8 = this.getlabels();
        n3 = n8 + n2;
        if (n3 > 128) {
            throw new IllegalStateException("too many labels");
        }
        byte[] byArray2 = new byte[n7];
        if (n5 != 0) {
            System.arraycopy(this.name, this.offset(0), byArray2, 0, n5);
        }
        System.arraycopy(byArray, n, byArray2, n5, n6);
        this.name = byArray2;
        int n9 = 0;
        int n10 = n5;
        while (n9 < n2) {
            this.setoffset(n8 + n9, n10);
            n10 += byArray2[n10] + 1;
            ++n9;
        }
        this.setlabels(n3);
    }

    private static final TextParseException parseException(String string, String string2) {
        return new TextParseException("'" + string + "': " + string2);
    }

    private final void appendFromString(String string, byte[] byArray, int n, int n2) throws TextParseException {
        try {
            this.append(byArray, n, n2);
        }
        catch (NameTooLongException nameTooLongException) {
            throw Name.parseException(string, "Name too long");
        }
    }

    private final void appendSafe(byte[] byArray, int n, int n2) {
        try {
            this.append(byArray, n, n2);
        }
        catch (NameTooLongException nameTooLongException) {}
    }

    public static Name fromString(String string, Name name) throws TextParseException {
        if (string.equals("@") && name != null) {
            return name;
        }
        if (string.equals(".")) {
            return root;
        }
        return new Name(string, name);
    }

    public static Name fromString(String string) throws TextParseException {
        return Name.fromString(string, null);
    }

    public static Name fromConstantString(String string) {
        try {
            return Name.fromString(string, null);
        }
        catch (TextParseException textParseException) {
            throw new IllegalArgumentException("Invalid name '" + string + '\'');
        }
    }

    public static Name concatenate(Name name, Name name2) throws NameTooLongException {
        if (name.isAbsolute()) {
            return name;
        }
        Name name3 = new Name();
        Name.copy(name, name3);
        name3.append(name2.name, name2.offset(0), name2.getlabels());
        return name3;
    }

    public Name relativize(Name name) {
        if (name == null || !this.subdomain(name)) {
            return this;
        }
        Name name2 = new Name();
        Name.copy(this, name2);
        int n = this.length() - name.length();
        int n2 = name2.labels() - name.labels();
        name2.setlabels(n2);
        name2.name = new byte[n];
        System.arraycopy(this.name, this.offset(0), name2.name, 0, n);
        return name2;
    }

    public Name wild(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("must replace 1 or more labels");
        }
        try {
            Name name = new Name();
            Name.copy(wild, name);
            name.append(this.name, this.offset(n), this.getlabels() - n);
            return name;
        }
        catch (NameTooLongException nameTooLongException) {
            throw new IllegalStateException("Name.wild: concatenate failed");
        }
    }

    public Name fromDNAME(DNAMERecord dNAMERecord) throws NameTooLongException {
        Name name = dNAMERecord.getName();
        Name name2 = dNAMERecord.getTarget();
        if (!this.subdomain(name)) {
            return null;
        }
        int n = this.labels() - name.labels();
        int n2 = this.length() - name.length();
        int n3 = this.offset(0);
        int n4 = name2.labels();
        short s = name2.length();
        if (n2 + s > 255) {
            throw new NameTooLongException();
        }
        Name name3 = new Name();
        name3.setlabels(n + n4);
        name3.name = new byte[n2 + s];
        System.arraycopy(this.name, n3, name3.name, 0, n2);
        System.arraycopy(name2.name, 0, name3.name, n2, s);
        int n5 = 0;
        int n6 = 0;
        while (n5 < 7 && n5 < n + n4) {
            name3.setoffset(n5, n6);
            n6 += name3.name[n6] + 1;
            ++n5;
        }
        return name3;
    }

    public boolean isWild() {
        if (this.labels() == 0) {
            return false;
        }
        boolean bl = false;
        if (this.name[0] == 1 && this.name[1] == 42) {
            bl = true;
        }
        return bl;
    }

    public boolean isAbsolute() {
        if (this.labels() == 0) {
            return false;
        }
        boolean bl = false;
        if (this.name[this.name.length - 1] == 0) {
            bl = true;
        }
        return bl;
    }

    public short length() {
        if (this.getlabels() == 0) {
            return 0;
        }
        return (short)(this.name.length - this.offset(0));
    }

    public int labels() {
        return this.getlabels();
    }

    public boolean subdomain(Name name) {
        int n = this.labels();
        int n2 = name.labels();
        if (n2 > n) {
            return false;
        }
        if (n2 == n) {
            return this.equals(name);
        }
        return name.equals(this.name, this.offset(n - n2));
    }

    private final String byteString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = byArray[n++];
        int n2 = n;
        while (n2 < n + by) {
            int n3 = byArray[n2] & 0xFF;
            if (n3 <= 32 || n3 >= 127) {
                stringBuffer.append('\\');
                stringBuffer.append(byteFormat.format(n3));
            } else if (n3 == 34 || n3 == 40 || n3 == 41 || n3 == 46 || n3 == 59 || n3 == 92 || n3 == 64 || n3 == 36) {
                stringBuffer.append('\\');
                stringBuffer.append((char)n3);
            } else {
                stringBuffer.append((char)n3);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        int n = this.labels();
        if (n == 0) {
            return "@";
        }
        if (n == 1 && this.name[this.offset(0)] == 0) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = this.offset(0);
        while (n2 < n) {
            byte by = this.name[n3];
            if (by > 63) {
                throw new IllegalStateException("invalid label");
            }
            if (by == 0) break;
            stringBuffer.append(this.byteString(this.name, n3));
            stringBuffer.append('.');
            n3 += 1 + by;
            ++n2;
        }
        if (!this.isAbsolute()) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public byte[] getLabel(int n) {
        int n2 = this.offset(n);
        byte by = (byte)(this.name[n2] + 1);
        byte[] byArray = new byte[by];
        System.arraycopy(this.name, n2, byArray, 0, by);
        return byArray;
    }

    public String getLabelString(int n) {
        int n2 = this.offset(n);
        return this.byteString(this.name, n2);
    }

    void toWire(DNSOutput dNSOutput, Compression compression) {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("toWire() called on non-absolute name");
        }
        int n = this.labels();
        int n2 = 0;
        while (n2 < n - 1) {
            Name name = n2 == 0 ? this : new Name(this, n2);
            int n3 = -1;
            if (compression != null) {
                n3 = compression.get(name);
            }
            if (n3 >= 0) {
                dNSOutput.writeU16(n3 |= 0xC000);
                return;
            }
            if (compression != null) {
                compression.add(dNSOutput.current(), name);
            }
            int n4 = this.offset(n2);
            dNSOutput.writeByteArray(this.name, n4, this.name[n4] + 1);
            ++n2;
        }
        dNSOutput.writeU8(0);
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput, null);
        return dNSOutput.toByteArray();
    }

    void toWireCanonical(DNSOutput dNSOutput) {
        byte[] byArray = this.toWireCanonical();
        dNSOutput.writeByteArray(byArray);
    }

    public byte[] toWireCanonical() {
        int n = this.labels();
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.name.length - this.offset(0)];
        int n2 = 0;
        int n3 = this.offset(0);
        int n4 = 0;
        while (n2 < n) {
            int n5 = this.name[n3];
            if (n5 > 63) {
                throw new IllegalStateException("invalid label");
            }
            byArray[n4++] = this.name[n3++];
            int n6 = 0;
            while (n6 < n5) {
                byArray[n4++] = lowercase[this.name[n3++] & 0xFF];
                ++n6;
            }
            ++n2;
        }
        return byArray;
    }

    void toWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        if (bl) {
            this.toWireCanonical(dNSOutput);
        } else {
            this.toWire(dNSOutput, compression);
        }
    }

    private final boolean equals(byte[] byArray, int n) {
        int n2 = this.labels();
        int n3 = 0;
        int n4 = this.offset(0);
        while (n3 < n2) {
            if (this.name[n4] != byArray[n]) {
                return false;
            }
            int n5 = this.name[n4++];
            ++n;
            if (n5 > 63) {
                throw new IllegalStateException("invalid label");
            }
            int n6 = 0;
            while (n6 < n5) {
                if (lowercase[this.name[n4++] & 0xFF] != lowercase[byArray[n++] & 0xFF]) {
                    return false;
                }
                ++n6;
            }
            ++n3;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        if (name.hashcode == 0) {
            name.hashCode();
        }
        if (this.hashcode == 0) {
            this.hashCode();
        }
        if (name.hashcode != this.hashcode) {
            return false;
        }
        if (name.labels() != this.labels()) {
            return false;
        }
        return this.equals(name.name, name.offset(0));
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        int n = 0;
        int n2 = this.offset(0);
        while (n2 < this.name.length) {
            n += (n << 3) + lowercase[this.name[n2] & 0xFF];
            ++n2;
        }
        this.hashcode = n;
        return this.hashcode;
    }

    public int compareTo(Object object) {
        int n;
        Name name = (Name)object;
        if (this == name) {
            return 0;
        }
        int n2 = this.labels();
        int n3 = n2 > (n = name.labels()) ? n : n2;
        int n4 = 1;
        while (n4 <= n3) {
            int n5 = this.offset(n2 - n4);
            int n6 = name.offset(n - n4);
            int n7 = this.name[n5];
            byte by = name.name[n6];
            int n8 = 0;
            while (n8 < n7 && n8 < by) {
                int n9 = lowercase[this.name[n8 + n5 + 1] & 0xFF] - lowercase[name.name[n8 + n6 + 1] & 0xFF];
                if (n9 != 0) {
                    return n9;
                }
                ++n8;
            }
            if (n7 != by) {
                return n7 - by;
            }
            ++n4;
        }
        return n2 - n;
    }

    private Name() {
    }

    public Name(String string, Name name) throws TextParseException {
        if (string.equals("")) {
            throw Name.parseException(string, "empty name");
        }
        if (string.equals("@")) {
            if (name == null) {
                Name.copy(empty, this);
            } else {
                Name.copy(name, this);
            }
            return;
        }
        if (string.equals(".")) {
            Name.copy(root, this);
            return;
        }
        int n = -1;
        int n2 = 1;
        byte[] byArray = new byte[64];
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < string.length()) {
            block23: {
                byte by;
                block21: {
                    block24: {
                        block22: {
                            by = (byte)string.charAt(n5);
                            if (!bl) break block21;
                            if (by < 48 || by > 57 || n3 >= 3) break block22;
                            ++n3;
                            n4 *= 10;
                            if ((n4 += by - 48) > 255) {
                                throw Name.parseException(string, "bad escape");
                            }
                            if (n3 < 3) break block23;
                            by = (byte)n4;
                            break block24;
                        }
                        if (n3 > 0 && n3 < 3) {
                            throw Name.parseException(string, "bad escape");
                        }
                    }
                    if (n2 > 63) {
                        throw Name.parseException(string, "label too long");
                    }
                    n = n2;
                    byArray[n2++] = by;
                    bl = false;
                    break block23;
                }
                if (by == 92) {
                    bl = true;
                    n3 = 0;
                    n4 = 0;
                } else if (by == 46) {
                    if (n == -1) {
                        throw Name.parseException(string, "invalid empty label");
                    }
                    byArray[0] = (byte)(n2 - 1);
                    this.appendFromString(string, byArray, 0, 1);
                    n = -1;
                    n2 = 1;
                } else {
                    if (n == -1) {
                        n = n5;
                    }
                    if (n2 > 63) {
                        throw Name.parseException(string, "label too long");
                    }
                    byArray[n2++] = by;
                }
            }
            ++n5;
        }
        if (n3 > 0 && n3 < 3) {
            throw Name.parseException(string, "bad escape");
        }
        if (bl) {
            throw Name.parseException(string, "bad escape");
        }
        if (n == -1) {
            this.appendFromString(string, emptyLabel, 0, 1);
            bl2 = true;
        } else {
            byArray[0] = (byte)(n2 - 1);
            this.appendFromString(string, byArray, 0, 1);
        }
        if (name != null && !bl2) {
            this.appendFromString(string, name.name, 0, name.getlabels());
        }
    }

    public Name(String string) throws TextParseException {
        this(string, null);
    }

    Name(DNSInput dNSInput) throws WireParseException {
        boolean bl = false;
        byte[] byArray = new byte[64];
        boolean bl2 = false;
        block4: while (!bl) {
            int n = dNSInput.readU8();
            switch (n & 0xC0) {
                case 0: {
                    if (this.getlabels() >= 128) {
                        throw new WireParseException("too many labels");
                    }
                    if (n == 0) {
                        this.append(emptyLabel, 0, 1);
                        bl = true;
                        break;
                    }
                    byArray[0] = (byte)n;
                    dNSInput.readByteArray(byArray, 1, n);
                    this.append(byArray, 0, 1);
                    break;
                }
                case 192: {
                    int n2 = dNSInput.readU8();
                    n2 += (n & 0xFFFFFF3F) << 8;
                    if (Options.check("verbosecompression")) {
                        System.err.println("currently " + dNSInput.current() + ", pointer to " + n2);
                    }
                    if (n2 >= dNSInput.current()) {
                        throw new WireParseException("bad compression");
                    }
                    if (!bl2) {
                        dNSInput.save();
                        bl2 = true;
                    }
                    dNSInput.jump(n2);
                    if (!Options.check("verbosecompression")) continue block4;
                    System.err.println("current name '" + this + "', seeking to " + n2);
                    break;
                }
            }
        }
        if (bl2) {
            dNSInput.restore();
        }
    }

    public Name(byte[] byArray) throws IOException {
        this(new DNSInput(byArray));
    }

    public Name(Name name, int n) {
        int n2 = name.labels();
        if (n > n2) {
            throw new IllegalArgumentException("attempted to remove too many labels");
        }
        this.name = name.name;
        this.setlabels(n2 - n);
        int n3 = 0;
        while (n3 < 7 && n3 < n2 - n) {
            this.setoffset(n3, name.offset(n3 + n));
            ++n3;
        }
    }

    static {
        byteFormat = new DecimalFormat();
        lowercase = new byte[256];
        byteFormat.setMinimumIntegerDigits(3);
        int n = 0;
        while (n < lowercase.length) {
            Name.lowercase[n] = n < 65 || n > 90 ? (byte)n : (byte)(n - 65 + 97);
            ++n;
        }
        root = new Name();
        root.appendSafe(emptyLabel, 0, 1);
        empty = new Name();
        Name.empty.name = new byte[0];
        wild = new Name();
        wild.appendSafe(wildLabel, 0, 1);
    }
}

