/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public abstract class Certificate
implements Serializable {
    private static final long serialVersionUID = -6751606818319535583L;
    private String type;

    public final String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (other instanceof Certificate) {
            try {
                Certificate x = (Certificate)other;
                if (this.getEncoded().length != x.getEncoded().length) {
                    return false;
                }
                byte[] b1 = this.getEncoded();
                byte[] b2 = x.getEncoded();
                int i = 0;
                while (i < b1.length) {
                    if (b1[i] != b2[i]) {
                        return false;
                    }
                    ++i;
                }
            }
            catch (CertificateEncodingException cee) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertificateRep(this.getType(), this.getEncoded());
        }
        catch (CertificateEncodingException cee) {
            throw new InvalidObjectException(cee.toString());
        }
    }

    protected Certificate(String type) {
        this.type = type;
    }

    protected static class CertificateRep
    implements Serializable {
        private static final long serialVersionUID = -8563758940495660020L;
        private String type;
        private byte[] data;

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory fact = CertificateFactory.getInstance(this.type);
                return fact.generateCertificate(new ByteArrayInputStream(this.data));
            }
            catch (Exception e) {
                throw new InvalidObjectException(e.toString());
            }
        }

        protected CertificateRep(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }
    }
}

