Koch1 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 6
  Axiom F--F--F
  F=F+F--F+F
  }

Koch2 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 12
  Axiom F---F---F---F
  F=-F+++F---F+
  }

Koch3 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 4
  Axiom F-F-F-F
  F=F-F+F+FF-F-F+F
  }

Koch6 { ; Adrian Mariano
   axiom f+f+f+f
   f=f-ff+ff+f+f-f-ff+f+f-f-ff-ff+f
   angle 4
    }

Dragon { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 8
  Axiom FX
  F=
  y=+FX--FY+
  x=-FX++FY-
  }

Peano1 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 4
  Axiom F-F-F-F
  F=F-F+F+F+F-F-F-F+F
  }

Cesaro { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 34
  Axiom FX
  F=
  X=----F!X!++++++++F!X!----
  }

DoubleCesaro { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 4
  axiom D\90D\90D\90D\90
  D=\42!D!/84!D!\42
  }

FlowSnake { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle=6;
  axiom FL
  L=FL-FR--FR+FL++FLFL+FR-",
  R=+FL-FRFR--FR-FL++FL+FR",
  F=
  }

CantorDust { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 6
  Axiom F
  F=FGF
  G=GGG
  }

Snowflake2 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle 12
  axiom F
  F=++!F!F--F--F@IQ3|+F!F--
  F=F--F!+++@Q3F@QI3|+F!F@Q3|+F!F
  }

SnowflakeColor { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle 12
  axiom F
  F=--!F<1!F<1++F<1++F<1@IQ3|-F<1!F<1++
  F=F<1++F<1!---@Q3F<1@QI3|-F<1!F<1@Q3|-F<1!F<1
  F=
  }

Island1 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle 4
  axiom F+F+F+F
  F=FFFF-F+F+F-F[-GFF+F+FF+F]FF
  G=@8G@I8
  }

Island2 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle 4
  axiom f+f+f+f
  f=f+gf-ff-f-ff+g+ff-gf+ff+f+ff-g-fff
  g=@6G@I6
  }

Quartet { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle 4
  axiom fb
  A=FBFA+HFA+FB-FA
  B=FB+FA-FB-JFBFA
  F=
  H=-
  J=+
  }

SnowFlake1 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 12
  Axiom FR
  R=++!FRFU++FU++FU!---@Q3FU|-@IQ3!FRFU!
  U=!FRFU!|+@Q3FR@IQ3+++!FR--FR--FRFU!--
  F=
  }

SnowFlake3 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle 12
  axiom fx
  x=++f!x!fy--fx--fy|+@iq3fyf!x!++f!y!++f!y!fx@q3+++f!y!fx
  y=fyf!x!+++@iq3fyf!x!++f!x!++f!y!fx@q3|+fx--fy--fxf!y!++
  f=
  }

Tree1 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle=12;
  axiom +++FX
  X=@.6[-FX]+FX
  }

Peano2 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  Angle 8
  Axiom FXY++F++FXY++F
  X=XY@Q2-F@IQ2-FXY++F++FXY
  Y=-@Q2F-@IQ2FXY
  }

Sierpinski1 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle 3
  axiom F
  F=FXF
  X=+FXF-FXF-FXF+
  }

Koch4 { ; Adrian Mariano
; from The Fractal Geometry of Nature by Mandelbrot
  angle 12
  axiom f++++f++++f
  f=+f--f++f-
  }


Plant07 { ; Ken Philip, from The Science of Fractal Images p.285b
  axiom Z
  z=zFX[+Z][-Z]
  x=x[-FFF][+FFF]FX
  angle 14
  }

Plant08 { ; Ken Philip, from The Science of Fractal Images, p.286
  axiom SLFFF
  s=[+++Z][---Z]TS
  z=+H[-Z]L
  h=-Z[+H]L
  t=TL
  l=[-FFF][+FFF]F
  angle 20
  }

Hilbert { ; Ken Philip, from The Science of Fractal Images
  axiom x
  x=-YF+XFX+FY-
  y=+XF-YFY-FX+
  angle 4
  }

Sierpinski3 { ; From Jim Hanan via Corbit
  axiom F-F-F
  f=F[-F]F
  angle 3
  }


Peano3 {
  axiom x
  x=XFYFX+F+YFXFY-F-XFYFX
  y=YFXFY-F-XFYFX+F+YFXFY
  angle 4
  }

Koch5 {
  axiom f+F+F+F
  f=F+F-F-FFF+F+F-F
  angle 4
  }

Sierpinski2 { ; from The Science of Fractal Images
  axiom FXF--FF--FF
  f=FF
  x=--FXF++FXF++FXF--
  angle 6
  }

SierpinskiSquare {
  axiom F+F+F+F
  f=FF+F+F+F+FF
  angle 4
  }


Pentagram { ; created by Adrian Mariano
  angle 10
  axiom fx++fx++fx++fx++fx
; f=f[++++@1.618033989f]
  x=[++++@i1.618033989f@.618033989f!x!@i.618033989f]
  }


QuadKoch { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	   ; Quadratic Koch island, Figure 1.7a p.9
  angle 4
  AXIOM F-F-F-F-
  F=F+FF-FF-F-F+F+FF-F-F+F+FF+FF-F
  }

Fass1 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	; FASS curve (3x3 tiles form macrotile), Figure 1.16a p.17
  axiom -l
  angle 4
  L=LF+RFR+FL-F-LFLFL-FRFR+
  R=-LFLF+RFRFR+F+RF-LFL-FR
  }

Fass2 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	; FASS curve (4x4 tiles form macrotile), Figure 1.16b p.17
  angle 4
  axiom -l
  L=LFLF+RFR+FLFL-FRF-LFL-FR+F+RF-LFL-FRFRFR+
  R=-LFLFLF+RFR+FL-F-LF+RFR+FLF+RFRF-LFL-FRFR
  }

QuadGosper { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	     ; Quadratic Gosper curve, Figure 1.11b p.12
  angle 4
  axiom -Fr
  l=FlFl-Fr-Fr+Fl+Fl-Fr-FrFl+Fr+FlFlFr-Fl+Fr+FlFl+Fr-FlFr-Fr-Fl+Fl+FrFr-
  r=+FlFl-Fr-Fr+Fl+FlFr+Fl-FrFr-Fl-Fr+FlFrFr-Fl-FrFl+Fl+Fr-Fr-Fl+Fl+FrFr
  f=
  }

Plant01 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	 ; Plant-like structure, figure 1.24a p.25
	 ; also p.285a The Science of Fractal Images
  angle 14
  axiom f
  f=F[+F]F[-F]F
  }

Plant02 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	 ; Plant-like structure, figure 1.24b p.25
  angle 18
  axiom f
  f=F[+F]F[-F][F]
  }

Plant03 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	 ; Plant-like structure, figure 1.24c p.25
  angle 16
  axiom f
  f=FF-[-F+F+F]+[+F-F-F]
  }

Plant04 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	 ; Plant-like structure, figure 1.24d p.25
  angle 18
  axiom x
  X=F[+X]F[-X]+X
  F=FF
  }

Plant05 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	 ; Plant-like structure, figure 1.24e p.25
  angle 14
  axiom x
  X=f[+X][-X]FX
  F=FF
  }

Plant06 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	 ; Plant-like structure, figure 1.24f p.25
  angle 16
  axiom x
  X=F-[[X]+X]+F[+FX]-X
  F=FF
  }

Plant09 { ; Adrian Mariano
   axiom y
   x=X[-FFF][+FFF]FX
   y=YFX[+Y][-Y]
   angle 14
}

Plant10 { ; Adrian Mariano
   axiom f
   f=f[+ff][-ff]f[+ff][-ff]f
   angle 10
   }


Plant11 { ; Adrian Mariano
   axiom f
   f=F[+F[+F][-F]F][-F[+F][-F]F]F[+F][-F]F
   angle 12
   }

Curve1 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	 ; curve from figure 1.9a p.10
  angle 4
  axiom F-F-F-F-
  f=FF-F-F-F-F-F+F
  }

Curve2 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
  angle 4
  axiom F-F-F-F-
  f=FF-F+F-F-FF
  }

Curve3 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	 ; curve from figure 1.9e p.10
  axiom F-F-F-F-
  angle 4
  F=F-FF--F-F
  }

Curve4 { ; Adrian Mariano
   axiom yf
   x=YF+XF+Y
   y=XF-YF-X
   angle 6
   }

Leaf1 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	; Compound leaf with alternating branches, Figure 5.12b p.130
  angle 8
  axiom x
  a=n
  n=o
  o=p
  p=x
  b=e
  e=h
  h=j
  j=y
  x=F[+A(4)]Fy
  y=F[-B(4)]Fx
  F=@1.18F@i1.18
  }

Leaf2 { ; Adrian Mariano, from the Algorithmic Beauty of Plants
	; Compound leaf with alternating branches, Figure 5.12a p.130
  angle 8
  axiom a
  a=f[+x]fb
  b=f[-y]fa
  x=a
  y=b
  f=@1.36f@i1.36
  }

Bush { ; Adrian Mariano
  Angle 16
  Axiom ++++F
  F=FF-[-F+F+F]+[+F-F-F]
  }

MyTree { ; Adrian Mariano
  Angle 16
  Axiom ++++F
  F=FF-[XY]+[XY]
  X=+FY
  Y=-FX
  }

ColorTriangGasket { ; Adrian Mariano
  Angle 6
  Axiom --X
  X=++FXF++FXF++FXF>1
  F=FF
  }

SquareGasket { ; Adrian Mariano
  Angle 4
  Axiom X
  X=+FXF+FXF+FXF+FXF
  F=FF
  }

DragonCurve { ; Adrian Mariano
  Angle 4
  Axiom X
  X=X-YF-
  Y=+FX+Y
  }

Square { ; Adrian Mariano
  Angle 4
  Axiom F+F+F+F
  F=FF+F+F+F+FF
  }

KochCurve { ; Adrian Mariano
  Angle 6
  Axiom F
  F=F+F--F+F
  }


Penrose1 { ; by Herb Savage
; based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
; Roger Penrose's rhombuses
  Angle 10
  Axiom +WF--XF---YF--ZF
  W=YF++ZF----XF[-YF----WF]++
  X=+YF--ZF[---WF--XF]+
  Y=-WF++XF[+++YF++ZF]-
  Z=--YF++++WF[+ZF++++XF]--XF
  F=
}

ColorPenrose1 { ; by Herb Savage
; based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
; Roger Penrose's rhombuses
; Uses color to show the edge matching rules to force nonperiodicy
  Angle 10
  Axiom +WC02F--XC04F---YC04F--ZC02F
  W=YC04F++ZC02F----XC04F[-YC04F----WC02F]++
  X=+YC04F--ZC02F[---WC02F--XC04F]+
  Y=-WC02F++XC04F[+++YC04F++ZC02F]-
  Z=--YC04F++++WC02F[+ZC02F++++XC04F]--XC04F
  F=
  }

Penrose2 { ; by Herb Savage
; based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
; Roger Penrose's rhombuses
  Angle 10
  Axiom ++ZF----XF-YF----WF
  W=YF++ZF----XF[-YF----WF]++
  X=+YF--ZF[---WF--XF]+
  Y=-WF++XF[+++YF++ZF]-
  Z=--YF++++WF[+ZF++++XF]--XF
  F=
  }

Penrose3 { ; by Herb Savage
; based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
; Roger Penrose's rhombuses
  Angle 10
  Axiom [X]++[X]++[X]++[X]++[X]
  W=YF++ZF----XF[-YF----WF]++
  X=+YF--ZF[---WF--XF]+
  Y=-WF++XF[+++YF++ZF]-
  Z=--YF++++WF[+ZF++++XF]--XF
  F=
  }

Penrose4 { ; by Herb Savage
; based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
; Roger Penrose's rhombuses
  Angle 10
  Axiom [Y]++[Y]++[Y]++[Y]++[Y]
  W=YF++ZF----XF[-YF----WF]++
  X=+YF--ZF[---WF--XF]+
  Y=-WF++XF[+++YF++ZF]-
  Z=--YF++++WF[+ZF++++XF]--XF
  F=
  }

DoublePenrose { ; by Herb Savage
; This is Penrose3 and Penrose4 superimposed
  Angle 10
  Axiom [X][Y]++[X][Y]++[X][Y]++[X][Y]++[X][Y]
  W=YF++ZF----XF[-YF----WF]++
  X=+YF--ZF[---WF--XF]+
  Y=-WF++XF[+++YF++ZF]-
  Z=--YF++++WF[+ZF++++XF]--XF
  F=
  }

Sphinx { ; by Herb Savage
; based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers"
; This is an example of a "reptile"
  Angle 6
  Axiom X
  X=+FF-YFF+FF--FFF|X|F--YFFFYFFF|
  Y=-FF+XFF-FF++FFF|Y|F++XFFFXFFF|
  F=GG
  G=GG
  }

PentaPlexity {
; Manual construction by Roger Penrose as a prelude to his development of
; the famous Penrose tiles (the kites and darts) that tile the plane
; only non-periodically.
; Translated first to a "dragon curve" and finally to an L-system
; by Joe Saverino.
  Angle 10
  Axiom F++F++F++F++F
  F=F++F++F|F-F++F
  }

; old PentaPlexity:
; Angle 10
; Axiom F++F++F++F++Fabxjeabxykabxyelbxyeahxyeabiye
; F=
; a=Fabxjea
; b=++F--bxykab
; x=++++F----xyelbx
; y=----F++++yeahxy
; e=--F++eabiye
; h=+++++F-----hijxlh
; i=---F+++ijkyhi
; j=-F+jkleij
; k=+F-klhajk
; l=+++F---lhibkl

CircularTile { ; Adrian Mariano
  axiom X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X
  x=[F+F+F+F[---X-Y]+++++F++++++++F-F-F-F]
  y=[F+F+F+F[---Y]+++++F++++++++F-F-F-F]
  angle 24
  }

Lars1{ ; By Jonathan Osuch [73277,1432]
       ; Based on a suggestion by Lars Vangsgaard
  Angle 8  ; angle increment/decrement is 45
  axiom [F]++[F]++[F]++F
  F=F[+F][-F]
  }

Lars2{ ; By Jonathan Osuch [73277,1432]
       ; Based on a suggestion by Lars Vangsgaard
  Angle 8  ; angle increment/decrement is 45
  axiom +[F]++[F]++[F]++F
  F=F[+F][-F]
  }

Lars1Color{ ; By Jonathan Osuch [73277,1432]
       ; Based on a suggestion by Lars Vangsgaard
  Angle 8  ; angle increment/decrement is 45
  axiom C1[F]++[F]++[F]++F
  F=F<1[+F][-F]>1
  }

Lars2Color{ ; By Jonathan Osuch [73277,1432]
       ; Based on a suggestion by Lars Vangsgaard
  Angle 8  ; angle increment/decrement is 45
  axiom C1+[F]++[F]++[F]++F
  F=F<1[+F][-F]>1
  }

Man { ; From Ivan Daunis daunis@teleline.es
   ; looks like man with an odd number of iterations
  Angle 8
  Axiom F++F++F++F
  F=-F-FF+++F+FF-F
}

Lace { ; From Ivan Daunis daunis@teleline.es
  Angle 8
  Axiom F++F++F++F
  F=F+++F---F+F---F++F--F++F
}
