/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import java.math.BigInteger;

public class Util {
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final String BASE64_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./";
    private static final char[] BASE64_CHARSET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz./".toCharArray();

    public static String toString(byte[] byArray) {
        return Util.toString(byArray, 0, byArray.length);
    }

    public static final String toString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byte by = byArray[n + n3++];
            cArray[n4++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n4++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static String toReversedString(byte[] byArray) {
        return Util.toReversedString(byArray, 0, byArray.length);
    }

    public static final String toReversedString(byte[] byArray, int n, int n2) {
        char[] cArray = new char[n2 * 2];
        int n3 = n + n2 - 1;
        int n4 = 0;
        while (n3 >= n) {
            byte by = byArray[n + n3--];
            cArray[n4++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n4++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] toBytesFromString(String string) {
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        if (n % 2 == 1) {
            byArray[n3++] = (byte)Util.fromDigit(string.charAt(n2++));
        }
        while (n2 < n) {
            byArray[n3] = (byte)(Util.fromDigit(string.charAt(n2++)) << 4);
            int n4 = n3++;
            byArray[n4] = (byte)(byArray[n4] | (byte)Util.fromDigit(string.charAt(n2++)));
        }
        return byArray;
    }

    public static byte[] toReversedBytesFromString(String string) {
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        if (n % 2 == 1) {
            byArray[n2++] = (byte)Util.fromDigit(string.charAt(--n));
        }
        while (n > 0) {
            byArray[n2] = (byte)Util.fromDigit(string.charAt(--n));
            int n3 = n2++;
            byArray[n3] = (byte)(byArray[n3] | (byte)(Util.fromDigit(string.charAt(--n)) << 4));
        }
        return byArray;
    }

    public static int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hexadecimal digit: " + c);
    }

    public static String toString(int n) {
        char[] cArray = new char[8];
        int n2 = 7;
        while (n2 >= 0) {
            cArray[n2] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    public static String toString(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n * 8];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = nArray[n2];
            cArray[n3++] = HEX_DIGITS[n4 >>> 28 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 24 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 20 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 16 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 12 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 8 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 & 0xF];
            ++n2;
        }
        return new String(cArray);
    }

    public static String toString(long l) {
        char[] cArray = new char[16];
        int n = 15;
        while (n >= 0) {
            cArray[n] = HEX_DIGITS[(int)(l & 0xFL)];
            l >>>= 4;
            --n;
        }
        return new String(cArray);
    }

    public static String toUnicodeString(byte[] byArray) {
        return Util.toUnicodeString(byArray, 0, byArray.length);
    }

    public static final String toUnicodeString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        stringBuffer.append('\n').append("\"");
        while (n3 < n2) {
            stringBuffer.append("\\u");
            byte by = byArray[n + n3++];
            stringBuffer.append(HEX_DIGITS[by >>> 4 & 0xF]);
            stringBuffer.append(HEX_DIGITS[by & 0xF]);
            by = byArray[n + n3++];
            stringBuffer.append(HEX_DIGITS[by >>> 4 & 0xF]);
            stringBuffer.append(HEX_DIGITS[by & 0xF]);
            if (++n4 % 8 != 0) continue;
            stringBuffer.append("\"+").append('\n').append("\"");
        }
        stringBuffer.append("\"").append('\n');
        return stringBuffer.toString();
    }

    public static String toUnicodeString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        stringBuffer.append('\n').append("\"");
        while (n < nArray.length) {
            int n3 = nArray[n++];
            stringBuffer.append("\\u");
            stringBuffer.append(HEX_DIGITS[n3 >>> 28 & 0xF]);
            stringBuffer.append(HEX_DIGITS[n3 >>> 24 & 0xF]);
            stringBuffer.append(HEX_DIGITS[n3 >>> 20 & 0xF]);
            stringBuffer.append(HEX_DIGITS[n3 >>> 16 & 0xF]);
            stringBuffer.append("\\u");
            stringBuffer.append(HEX_DIGITS[n3 >>> 12 & 0xF]);
            stringBuffer.append(HEX_DIGITS[n3 >>> 8 & 0xF]);
            stringBuffer.append(HEX_DIGITS[n3 >>> 4 & 0xF]);
            stringBuffer.append(HEX_DIGITS[n3 & 0xF]);
            if (++n2 % 4 != 0) continue;
            stringBuffer.append("\"+").append('\n').append("\"");
        }
        stringBuffer.append("\"").append('\n');
        return stringBuffer.toString();
    }

    public static byte[] toBytesFromUnicode(String string) {
        int n = string.length() * 2;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.charAt(n2 >>> 1);
            byArray[n2] = (byte)((n2 & 1) == 0 ? n3 >>> 8 : n3);
            ++n2;
        }
        return byArray;
    }

    public static String dumpString(byte[] byArray, int n, int n2, String string) {
        if (byArray == null) {
            return string + "null\n";
        }
        StringBuffer stringBuffer = new StringBuffer(n2 * 3);
        if (n2 > 32) {
            stringBuffer.append(string).append("Hexadecimal dump of ").append(n2).append(" bytes...\n");
        }
        int n3 = n + n2;
        int n4 = Integer.toString(n2).length();
        if (n4 < 4) {
            n4 = 4;
        }
        while (n < n3) {
            if (n2 > 32) {
                String string2 = "         " + n;
                stringBuffer.append(string).append(string2.substring(string2.length() - n4)).append(": ");
            }
            int n5 = 0;
            while (n5 < 32 && n + n5 + 7 < n3) {
                stringBuffer.append(Util.toString(byArray, n + n5, 8)).append(' ');
                n5 += 8;
            }
            if (n5 < 32) {
                while (n5 < 32 && n + n5 < n3) {
                    stringBuffer.append(Util.byteToString(byArray[n + n5]));
                    ++n5;
                }
            }
            stringBuffer.append('\n');
            n += 32;
        }
        return stringBuffer.toString();
    }

    public static String dumpString(byte[] byArray) {
        return byArray == null ? "null\n" : Util.dumpString(byArray, 0, byArray.length, "");
    }

    public static String dumpString(byte[] byArray, String string) {
        return byArray == null ? "null\n" : Util.dumpString(byArray, 0, byArray.length, string);
    }

    public static String dumpString(byte[] byArray, int n, int n2) {
        return Util.dumpString(byArray, n, n2, "");
    }

    public static String byteToString(int n) {
        char[] cArray = new char[]{HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(cArray);
    }

    public static final String toBase64(byte[] byArray) {
        int n = byArray.length;
        int n2 = n % 3;
        int n3 = 0;
        byte by = 0;
        byte by2 = 0;
        switch (n2) {
            case 1: {
                by2 = byArray[0];
                break;
            }
            case 2: {
                by = byArray[0];
                by2 = byArray[1];
                break;
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (true) {
            int n4 = (n3 & 0xFC) >>> 2;
            if (bl || n4 != 0) {
                stringBuffer.append(BASE64_CHARSET[n4]);
                bl = true;
            }
            n4 = (n3 & 3) << 4 | (by & 0xF0) >>> 4;
            if (bl || n4 != 0) {
                stringBuffer.append(BASE64_CHARSET[n4]);
                bl = true;
            }
            n4 = (by & 0xF) << 2 | (by2 & 0xC0) >>> 6;
            if (bl || n4 != 0) {
                stringBuffer.append(BASE64_CHARSET[n4]);
                bl = true;
            }
            n4 = by2 & 0x3F;
            if (bl || n4 != 0) {
                stringBuffer.append(BASE64_CHARSET[n4]);
                bl = true;
            }
            if (n2 >= n) break;
            try {
                n3 = byArray[n2++];
                by = byArray[n2++];
                by2 = byArray[n2++];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                break;
            }
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return "0";
    }

    /*
     * Exception decompiling
     */
    public static final byte[] fromBase64(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 10[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final byte[] trim(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 0 || byArray[0] != 0) {
            return byArray;
        }
        int n = byArray.length;
        int n2 = 1;
        while (byArray[n2] == 0 && n2 < n) {
            ++n2;
        }
        byte[] byArray2 = new byte[n - n2];
        System.arraycopy(byArray, n2, byArray2, 0, n - n2);
        return byArray2;
    }

    public static final String dump(BigInteger bigInteger) {
        return Util.dumpString(Util.trim(bigInteger));
    }

    private Util() {
    }
}

