/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.dto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonCodec {
    public static final ObjectMapper mapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T decode(Buffer buffer, Class<T> type) throws IOException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JsonCodec.class.getClassLoader());
        try {
            Object object = mapper.readValue((InputStream)buffer.in(), type);
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static Buffer encode(Object value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        mapper.writeValue((OutputStream)baos, value);
        return baos.toBuffer();
    }

    static {
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

