/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.io.PrintWriter;
import vcf.Marker;

public final class VcfRecBuilder {
    public static final int DEFAULT_INIT_SIZE = 50;
    private final StringBuilder sb;
    private final Marker marker;
    private final int nAlleles;

    public VcfRecBuilder(Marker marker, int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        StringBuilder stringBuilder = new StringBuilder(100 + 4 * n);
        VcfRecBuilder.writeFixedFields(marker, stringBuilder);
        this.marker = marker;
        this.nAlleles = marker.nAlleles();
        this.sb = stringBuilder;
    }

    public Marker marker() {
        return this.marker;
    }

    public void addSampleData(int n, int n2) {
        if (n < 0 || n >= this.nAlleles) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 < 0 || n2 >= this.nAlleles) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        this.sb.append('\t');
        this.sb.append(n);
        this.sb.append('|');
        this.sb.append(n2);
    }

    public void addSampleData(int n) {
        if (n < 0 || n >= this.nAlleles) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        this.sb.append('\t');
        this.sb.append(n);
    }

    public void writeRec(PrintWriter printWriter) {
        printWriter.println(this.sb);
    }

    private static void writeFixedFields(Marker marker, StringBuilder stringBuilder) {
        VcfRecBuilder.appendMarker(marker, stringBuilder);
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("PASS");
        stringBuilder.append('\t');
        if (marker.end() == -1) {
            stringBuilder.append('.');
        } else {
            stringBuilder.append("END=");
            stringBuilder.append(marker.end());
        }
        stringBuilder.append('\t');
        stringBuilder.append("GT");
    }

    private static void appendMarker(Marker marker, StringBuilder stringBuilder) {
        int n;
        stringBuilder.append(marker.chrom());
        stringBuilder.append('\t');
        stringBuilder.append(marker.pos());
        int n2 = marker.nIds();
        if (n2 == 0) {
            stringBuilder.append('\t');
            stringBuilder.append('.');
        } else {
            for (n = 0; n < n2; ++n) {
                stringBuilder.append(n == 0 ? (char)'\t' : ';');
                stringBuilder.append(marker.id(n));
            }
        }
        n = marker.nAlleles();
        if (n == 1) {
            stringBuilder.append('\t');
            stringBuilder.append(marker.allele(0));
            stringBuilder.append('\t');
            stringBuilder.append('.');
        } else {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(i < 2 ? (char)'\t' : ',');
                stringBuilder.append(marker.allele(i));
            }
        }
    }
}

