/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.cgoban;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import org.igoweb.igoweb.client.swing.AdWidget;
import org.igoweb.igoweb.client.swing.LoginPanel;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.MsgOut;

public class LoginWindow
extends AFrame {
    private static final int BANNERAD_WIDTH = 468;
    private static final int BANNERAD_HEIGHT = 60;
    public final LoginPanel loginPanel;
    private AdWidget adWidget;

    public LoginWindow(AFrame parent) {
        super(Defs.getString(-382651054), parent);
        ActionListener connListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LoginWindow.this.dispose();
            }
        };
        this.loginPanel = new LoginPanel(connListener);
        this.getContentPane().add(this.loginPanel);
        this.adWidget = new AdWidget(null, 0, 468, 60, null, null);
        this.adWidget.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.getContentPane().add("North", this.adWidget);
        final Toolkit tk = this.getToolkit();
        new Thread(new Runnable(){

            @Override
            public void run() {
                LoginWindow.this.fetchAdId(tk);
            }
        }).start();
        this.pack(parent);
        this.setVisible(true);
    }

    public void setListener(ActionListener listener) {
        this.loginPanel.setListener(listener);
    }

    @Override
    public Dimension getDefaultPreferredSize() {
        Dimension size = super.getDefaultPreferredSize();
        Insets insets = this.getInsets();
        int w = size.width - (insets.left + insets.right);
        int h = size.height - (insets.top + insets.bottom);
        double ratio = Math.sqrt(2.0);
        if ((double)w < (double)h * ratio) {
            w = (int)((double)h * ratio);
        } else {
            h = (int)((double)w / ratio);
        }
        size.width = w + insets.left + insets.right;
        size.height = h + insets.top + insets.bottom;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAdId(Toolkit tk) {
        ObjectInputStream in = null;
        URL url = null;
        try {
            url = new URL("https://www.gokgs.com/servlet/adId/" + Defs.getString(2031923656) + "-" + 468 + "x" + 60);
            in = new ObjectInputStream(new BufferedInputStream(url.openConnection().getInputStream()));
            final int adId = in.readInt();
            url = new URL(in.readUTF());
            final Image adImage = tk.getImage(url);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LoginWindow.this.adWidget.setImage(adImage, adId);
                }
            });
        }
        catch (AccessControlException excep) {
            new MsgOut(Defs.getString(-903340547), Defs.getString(-382651073), 1);
        }
        catch (Exception excep) {
            Logger.getLogger("global").log(Level.WARNING, "LoginWindow.fetchAdId: Unable to fetch from " + url, excep);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException excep) {}
        }
    }
}

