/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIteratorFilter;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.build.CRAMReferenceRegion;
import htsjdk.samtools.cram.build.CramContainerIterator;
import htsjdk.samtools.cram.build.CramSpanContainerIterator;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.structure.AlignmentContext;
import htsjdk.samtools.cram.structure.CRAMEncodingStrategy;
import htsjdk.samtools.cram.structure.CompressorCache;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CRAMIterator
implements SAMRecordIterator,
Closeable {
    private final CountingInputStream countingInputStream;
    private final CramContainerIterator containerIterator;
    private final CramHeader cramHeader;
    private final SAMFileHeader samFileHeader;
    private final CRAMReferenceRegion cramReferenceState;
    private final QueryInterval[] queryIntervals;
    private ValidationStringency validationStringency;
    private List<SAMRecord> samRecords;
    private Container container;
    private SamReader mReader;
    private final long firstContainerOffset;
    private final CompressorCache compressorCache = new CompressorCache();
    private long samRecordIndex;
    private Iterator<SAMRecord> samRecordIterator = Collections.EMPTY_LIST.iterator();
    private static final Comparator<QueryInterval> overlapsContainerSpan = (queryInterval, containerInterval) -> {
        int comp = queryInterval.referenceIndex - containerInterval.referenceIndex;
        if (comp != 0) {
            return comp;
        }
        if (queryInterval.end <= 0) {
            return containerInterval.end <= queryInterval.start ? -1 : 0;
        }
        if (containerInterval.overlaps((QueryInterval)queryInterval)) {
            return 0;
        }
        return queryInterval.compareTo((QueryInterval)containerInterval);
    };

    public CRAMIterator(InputStream inputStream, CRAMReferenceSource referenceSource, ValidationStringency validationStringency) {
        this.countingInputStream = new CountingInputStream(inputStream);
        this.containerIterator = new CramContainerIterator(this.countingInputStream);
        this.validationStringency = validationStringency;
        this.samFileHeader = this.containerIterator.getSamFileHeader();
        this.cramReferenceState = new CRAMReferenceRegion(referenceSource, this.samFileHeader);
        this.cramHeader = this.containerIterator.getCramHeader();
        this.firstContainerOffset = this.countingInputStream.getCount();
        this.samRecords = new ArrayList<SAMRecord>(new CRAMEncodingStrategy().getReadsPerSlice());
        this.queryIntervals = null;
    }

    public CRAMIterator(SeekableStream seekableStream, CRAMReferenceSource referenceSource, ValidationStringency validationStringency, QueryInterval[] queryIntervals, long[] coordinates) {
        this.countingInputStream = new CountingInputStream(seekableStream);
        this.containerIterator = CramSpanContainerIterator.fromFileSpan(seekableStream, coordinates);
        this.validationStringency = validationStringency;
        this.samFileHeader = this.containerIterator.getSamFileHeader();
        this.cramReferenceState = new CRAMReferenceRegion(referenceSource, this.samFileHeader);
        this.cramHeader = this.containerIterator.getCramHeader();
        this.firstContainerOffset = this.countingInputStream.getCount();
        this.samRecords = new ArrayList<SAMRecord>(new CRAMEncodingStrategy().getReadsPerSlice());
        this.queryIntervals = queryIntervals;
    }

    private BAMIteratorFilter.FilteringIteratorState nextContainer() {
        if (this.containerIterator != null) {
            if (!this.containerIterator.hasNext()) {
                this.samRecords.clear();
                return BAMIteratorFilter.FilteringIteratorState.STOP_ITERATION;
            }
            this.container = this.containerIterator.next();
            if (this.container.isEOF()) {
                this.samRecords.clear();
                return BAMIteratorFilter.FilteringIteratorState.STOP_ITERATION;
            }
        } else {
            long containerByteOffset = this.countingInputStream.getCount();
            this.container = new Container(this.cramHeader.getCRAMVersion(), this.countingInputStream, containerByteOffset);
            if (this.container.isEOF()) {
                this.samRecords.clear();
                return BAMIteratorFilter.FilteringIteratorState.STOP_ITERATION;
            }
        }
        if (this.containerMatchesQuery(this.container)) {
            this.samRecords = this.container.getSAMRecords(this.validationStringency, this.cramReferenceState, this.compressorCache, this.getSAMFileHeader());
            this.samRecordIterator = this.samRecords.iterator();
            return BAMIteratorFilter.FilteringIteratorState.MATCHES_FILTER;
        }
        return BAMIteratorFilter.FilteringIteratorState.CONTINUE_ITERATION;
    }

    private boolean containerMatchesQuery(Container container) {
        if (this.queryIntervals == null) {
            return true;
        }
        AlignmentContext alignmentContext = container.getAlignmentContext();
        return !alignmentContext.getReferenceContext().isMappedSingleRef() || Arrays.binarySearch(this.queryIntervals, new QueryInterval(alignmentContext.getReferenceContext().getReferenceContextID(), alignmentContext.getAlignmentStart(), alignmentContext.getAlignmentStart() + alignmentContext.getAlignmentSpan() - 1), overlapsContainerSpan) >= 0;
    }

    public boolean advanceToAlignmentInContainer(int refIndex, int pos) {
        if (!this.hasNext()) {
            return false;
        }
        int i = 0;
        for (SAMRecord record : this.samRecords) {
            if (refIndex != -1 && record.getReferenceIndex() != refIndex) continue;
            if (pos <= 0) {
                if (record.getAlignmentStart() == 0) {
                    this.samRecordIterator = this.samRecords.listIterator(i);
                    return true;
                }
            } else if (record.getAlignmentStart() >= pos) {
                this.samRecordIterator = this.samRecords.listIterator(i);
                return true;
            }
            ++i;
        }
        this.samRecordIterator = Collections.EMPTY_LIST.iterator();
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.container != null && this.container.isEOF()) {
            return false;
        }
        if (!this.samRecordIterator.hasNext()) {
            BAMIteratorFilter.FilteringIteratorState nextContainerPasses = BAMIteratorFilter.FilteringIteratorState.CONTINUE_ITERATION;
            while (nextContainerPasses == BAMIteratorFilter.FilteringIteratorState.CONTINUE_ITERATION) {
                nextContainerPasses = this.nextContainer();
            }
            return nextContainerPasses == BAMIteratorFilter.FilteringIteratorState.MATCHES_FILTER;
        }
        return !this.samRecords.isEmpty();
    }

    @Override
    public SAMRecord next() {
        if (this.hasNext()) {
            SAMRecord samRecord = this.samRecordIterator.next();
            if (this.validationStringency != ValidationStringency.SILENT) {
                SAMUtils.processValidationErrors(samRecord.isValid(), this.samRecordIndex++, this.validationStringency);
            }
            return samRecord;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Removal of records not implemented.");
    }

    @Override
    public void close() {
        this.samRecords.clear();
        try {
            if (this.countingInputStream != null) {
                this.countingInputStream.close();
            }
        }
        catch (RuntimeIOException runtimeIOException) {
            // empty catch block
        }
    }

    public long getFirstContainerOffset() {
        return this.firstContainerOffset;
    }

    @Override
    public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
        return SamReader.AssertingIterator.of(this).assertSorted(sortOrder);
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public SamReader getFileSource() {
        return this.mReader;
    }

    public void setFileSource(SamReader mReader) {
        this.mReader = mReader;
    }

    public SAMFileHeader getSAMFileHeader() {
        return this.samFileHeader;
    }
}

