/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.AttrContainer;
import gnu.bytecodecvssnap.Attribute;
import gnu.bytecodecvssnap.ClassType;
import gnu.bytecodecvssnap.ConstantPool;
import gnu.bytecodecvssnap.ConstantValueAttr;
import gnu.bytecodecvssnap.CpoolEntry;
import gnu.bytecodecvssnap.Location;
import gnu.bytecodecvssnap.PrimType;
import java.io.DataOutputStream;
import java.io.IOException;

public class Field
extends Location
implements AttrContainer {
    int flags;
    Field next;
    Attribute attributes;
    ClassType owner;
    String sourceName;
    java.lang.reflect.Field rfield;

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attribute) {
        this.attributes = attribute;
    }

    public final ClassType getDeclaringClass() {
        return this.owner;
    }

    public final void setStaticFlag(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags ^= 0xFFFFFFF7);
    }

    public final boolean getStaticFlag() {
        boolean bl = false;
        if ((this.flags & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final int getModifiers() {
        return this.flags;
    }

    void write(DataOutputStream dataOutputStream, ClassType classType) throws IOException {
        dataOutputStream.writeShort(this.flags);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.signature_index);
        Attribute.writeAll(this, dataOutputStream);
    }

    void assign_constants(ClassType classType) {
        ConstantPool constantPool = classType.constants;
        if (this.name_index == 0 && this.name != null) {
            this.name_index = constantPool.addUtf8((String)this.name).index;
        }
        if (this.signature_index == 0 && this.type != null) {
            this.signature_index = constantPool.addUtf8((String)this.type.signature).index;
        }
        Attribute.assignConstants(this, classType);
    }

    public java.lang.reflect.Field getReflectField() throws NoSuchFieldException {
        if (this.rfield == null) {
            this.rfield = this.owner.getReflectClass().getDeclaredField(this.getName());
        }
        return this.rfield;
    }

    public void setSourceName(String string) {
        this.sourceName = string;
    }

    public String getSourceName() {
        if (this.sourceName == null) {
            this.sourceName = this.getName().intern();
        }
        return this.sourceName;
    }

    public static Field searchField(Field field, String string) {
        while (field != null) {
            if (field.getSourceName() == string) {
                return field;
            }
            field = field.next;
        }
        return null;
    }

    public final Field getNext() {
        return this.next;
    }

    public final void setConstantValue(Object object, ClassType classType) {
        CpoolEntry cpoolEntry;
        ConstantPool constantPool = classType.getConstants();
        char c = this.getType().getSignature().charAt(0);
        switch (c) {
            case 'Z': {
                cpoolEntry = constantPool.addInt(PrimType.booleanValue(object) ? 1 : 0);
                break;
            }
            case 'C': {
                if (object instanceof Character) {
                    cpoolEntry = constantPool.addInt(((Character)object).charValue());
                    break;
                }
            }
            case 'B': 
            case 'I': 
            case 'S': {
                cpoolEntry = constantPool.addInt(((Number)object).intValue());
                break;
            }
            case 'J': {
                cpoolEntry = constantPool.addLong(((Number)object).longValue());
                break;
            }
            case 'F': {
                cpoolEntry = constantPool.addFloat(((Number)object).floatValue());
                break;
            }
            case 'D': {
                cpoolEntry = constantPool.addDouble(((Number)object).doubleValue());
                break;
            }
            default: {
                cpoolEntry = constantPool.addString(object.toString());
            }
        }
        ConstantValueAttr constantValueAttr = new ConstantValueAttr(cpoolEntry.getIndex());
        constantValueAttr.addToFrontOf(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Field:");
        stringBuffer.append(this.getDeclaringClass().getName());
        stringBuffer.append('.');
        stringBuffer.append(this.name);
        return stringBuffer.toString();
    }

    public Field(ClassType classType) {
        if (classType.last_field == null) {
            classType.fields = this;
        } else {
            classType.last_field.next = this;
        }
        classType.last_field = this;
        ++classType.fields_count;
        this.owner = classType;
    }
}

