/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.cag;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.Input;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.Transform;

public abstract class CAGProcessor
implements SceneGraphProcessor {
    private Graphics2D _graphics;
    private AffineTransform _transform;
    private Area _area = null;

    protected CAGProcessor(Graphics2D graphics2D) {
        this._graphics = graphics2D;
        this._transform = new AffineTransform();
    }

    protected CAGProcessor(Graphics2D graphics2D, AffineTransform affineTransform) {
        this._graphics = graphics2D;
        this._transform = new AffineTransform(affineTransform);
    }

    public Area getArea() {
        return this._area == null ? new Area() : this._area;
    }

    public void process(Primitive primitive) {
        Area area = new Area(primitive.getShape(this._graphics));
        area.transform(this._transform);
        if (this._area == null) {
            this._area = area;
        } else {
            this.accumulateArea(this._area, area);
        }
    }

    public void process(Transform transform) {
        AffineTransform affineTransform = new AffineTransform(this._transform);
        this._transform.concatenate(transform.getTransform());
        transform.getTransformedGraph().accept(this);
        this._transform = affineTransform;
    }

    public void process(Input input) {
        input.getSensitiveGraph().accept(this);
    }

    public void process(Style style) {
        style.getStyledGraph().accept(this);
    }

    public void process(CompositeNode compositeNode) {
        int n = 0;
        while (n < compositeNode.getVisibleSubgraphCount()) {
            compositeNode.getVisibleSubgraph(n).accept(this);
            ++n;
        }
    }

    protected abstract void accumulateArea(Area var1, Area var2);
}

