require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ALTIVEC_H)) {
    eval 'sub _ALTIVEC_H () {1;}' unless defined(&_ALTIVEC_H);
    if(!defined(&__VEC__) || !defined(&__ALTIVEC__)) {
	die("Use\ the\ \"\-maltivec\"\ flag\ to\ enable\ PowerPC\ AltiVec\ support");
    }
    if(!defined(&__APPLE_ALTIVEC__)) {
	eval 'sub vector () { &__vector;}' unless defined(&vector);
	eval 'sub pixel () { &__pixel;}' unless defined(&pixel);
	eval 'sub bool () { &__bool;}' unless defined(&bool);
    }
    eval 'sub __CR6_EQ () {0;}' unless defined(&__CR6_EQ);
    eval 'sub __CR6_EQ_REV () {1;}' unless defined(&__CR6_EQ_REV);
    eval 'sub __CR6_LT () {2;}' unless defined(&__CR6_LT);
    eval 'sub __CR6_LT_REV () {3;}' unless defined(&__CR6_LT_REV);
    eval 'sub vec_vaddcuw () { &vec_addc;}' unless defined(&vec_vaddcuw);
    eval 'sub vec_vand () { &vec_and;}' unless defined(&vec_vand);
    eval 'sub vec_vandc () { &vec_andc;}' unless defined(&vec_vandc);
    eval 'sub vec_vrfip () { &vec_ceil;}' unless defined(&vec_vrfip);
    eval 'sub vec_vcmpbfp () { &vec_cmpb;}' unless defined(&vec_vcmpbfp);
    eval 'sub vec_vcmpgefp () { &vec_cmpge;}' unless defined(&vec_vcmpgefp);
    eval 'sub vec_vctsxs () { &vec_cts;}' unless defined(&vec_vctsxs);
    eval 'sub vec_vctuxs () { &vec_ctu;}' unless defined(&vec_vctuxs);
    eval 'sub vec_vexptefp () { &vec_expte;}' unless defined(&vec_vexptefp);
    eval 'sub vec_vrfim () { &vec_floor;}' unless defined(&vec_vrfim);
    eval 'sub vec_lvx () { &vec_ld;}' unless defined(&vec_lvx);
    eval 'sub vec_lvxl () { &vec_ldl;}' unless defined(&vec_lvxl);
    eval 'sub vec_vlogefp () { &vec_loge;}' unless defined(&vec_vlogefp);
    eval 'sub vec_vmaddfp () { &vec_madd;}' unless defined(&vec_vmaddfp);
    eval 'sub vec_vmhaddshs () { &vec_madds;}' unless defined(&vec_vmhaddshs);
    eval 'sub vec_vmladduhm () { &vec_mladd;}' unless defined(&vec_vmladduhm);
    eval 'sub vec_vmhraddshs () { &vec_mradds;}' unless defined(&vec_vmhraddshs);
    eval 'sub vec_vnmsubfp () { &vec_nmsub;}' unless defined(&vec_vnmsubfp);
    eval 'sub vec_vnor () { &vec_nor;}' unless defined(&vec_vnor);
    eval 'sub vec_vor () { &vec_or;}' unless defined(&vec_vor);
    eval 'sub vec_vpkpx () { &vec_packpx;}' unless defined(&vec_vpkpx);
    eval 'sub vec_vperm () { &vec_perm;}' unless defined(&vec_vperm);
    eval 'sub vec_vrefp () { &vec_re;}' unless defined(&vec_vrefp);
    eval 'sub vec_vrfin () { &vec_round;}' unless defined(&vec_vrfin);
    eval 'sub vec_vrsqrtefp () { &vec_rsqrte;}' unless defined(&vec_vrsqrtefp);
    eval 'sub vec_vsel () { &vec_sel;}' unless defined(&vec_vsel);
    eval 'sub vec_vsldoi () { &vec_sld;}' unless defined(&vec_vsldoi);
    eval 'sub vec_vsl () { &vec_sll;}' unless defined(&vec_vsl);
    eval 'sub vec_vslo () { &vec_slo;}' unless defined(&vec_vslo);
    eval 'sub vec_vspltisb () { &vec_splat_s8;}' unless defined(&vec_vspltisb);
    eval 'sub vec_vspltish () { &vec_splat_s16;}' unless defined(&vec_vspltish);
    eval 'sub vec_vspltisw () { &vec_splat_s32;}' unless defined(&vec_vspltisw);
    eval 'sub vec_vsr () { &vec_srl;}' unless defined(&vec_vsr);
    eval 'sub vec_vsro () { &vec_sro;}' unless defined(&vec_vsro);
    eval 'sub vec_stvx () { &vec_st;}' unless defined(&vec_stvx);
    eval 'sub vec_stvxl () { &vec_stl;}' unless defined(&vec_stvxl);
    eval 'sub vec_vsubcuw () { &vec_subc;}' unless defined(&vec_vsubcuw);
    eval 'sub vec_vsum2sws () { &vec_sum2s;}' unless defined(&vec_vsum2sws);
    eval 'sub vec_vsumsws () { &vec_sums;}' unless defined(&vec_vsumsws);
    eval 'sub vec_vrfiz () { &vec_trunc;}' unless defined(&vec_vrfiz);
    eval 'sub vec_vxor () { &vec_xor;}' unless defined(&vec_vxor);
    eval 'sub vec_vaddfp () { &__builtin_vec_vaddfp;}' unless defined(&vec_vaddfp);
    eval 'sub vec_addc () { &__builtin_vec_addc;}' unless defined(&vec_addc);
    eval 'sub vec_adde () { &__builtin_vec_adde;}' unless defined(&vec_adde);
    eval 'sub vec_addec () { &__builtin_vec_addec;}' unless defined(&vec_addec);
    eval 'sub vec_vaddsws () { &__builtin_vec_vaddsws;}' unless defined(&vec_vaddsws);
    eval 'sub vec_vaddshs () { &__builtin_vec_vaddshs;}' unless defined(&vec_vaddshs);
    eval 'sub vec_vaddsbs () { &__builtin_vec_vaddsbs;}' unless defined(&vec_vaddsbs);
    eval 'sub vec_vavgsw () { &__builtin_vec_vavgsw;}' unless defined(&vec_vavgsw);
    eval 'sub vec_vavguw () { &__builtin_vec_vavguw;}' unless defined(&vec_vavguw);
    eval 'sub vec_vavgsh () { &__builtin_vec_vavgsh;}' unless defined(&vec_vavgsh);
    eval 'sub vec_vavguh () { &__builtin_vec_vavguh;}' unless defined(&vec_vavguh);
    eval 'sub vec_vavgsb () { &__builtin_vec_vavgsb;}' unless defined(&vec_vavgsb);
    eval 'sub vec_vavgub () { &__builtin_vec_vavgub;}' unless defined(&vec_vavgub);
    eval 'sub vec_ceil () { &__builtin_vec_ceil;}' unless defined(&vec_ceil);
    eval 'sub vec_cmpb () { &__builtin_vec_cmpb;}' unless defined(&vec_cmpb);
    eval 'sub vec_vcmpeqfp () { &__builtin_vec_vcmpeqfp;}' unless defined(&vec_vcmpeqfp);
    eval 'sub vec_cmpge () { &__builtin_vec_cmpge;}' unless defined(&vec_cmpge);
    eval 'sub vec_vcmpgtfp () { &__builtin_vec_vcmpgtfp;}' unless defined(&vec_vcmpgtfp);
    eval 'sub vec_vcmpgtsw () { &__builtin_vec_vcmpgtsw;}' unless defined(&vec_vcmpgtsw);
    eval 'sub vec_vcmpgtuw () { &__builtin_vec_vcmpgtuw;}' unless defined(&vec_vcmpgtuw);
    eval 'sub vec_vcmpgtsh () { &__builtin_vec_vcmpgtsh;}' unless defined(&vec_vcmpgtsh);
    eval 'sub vec_vcmpgtuh () { &__builtin_vec_vcmpgtuh;}' unless defined(&vec_vcmpgtuh);
    eval 'sub vec_vcmpgtsb () { &__builtin_vec_vcmpgtsb;}' unless defined(&vec_vcmpgtsb);
    eval 'sub vec_vcmpgtub () { &__builtin_vec_vcmpgtub;}' unless defined(&vec_vcmpgtub);
    eval 'sub vec_vcfsx () { &__builtin_vec_vcfsx;}' unless defined(&vec_vcfsx);
    eval 'sub vec_vcfux () { &__builtin_vec_vcfux;}' unless defined(&vec_vcfux);
    eval 'sub vec_cts () { &__builtin_vec_cts;}' unless defined(&vec_cts);
    eval 'sub vec_ctu () { &__builtin_vec_ctu;}' unless defined(&vec_ctu);
    eval 'sub vec_cpsgn () { &__builtin_vec_copysign;}' unless defined(&vec_cpsgn);
    eval 'sub vec_double () { &__builtin_vec_double;}' unless defined(&vec_double);
    eval 'sub vec_expte () { &__builtin_vec_expte;}' unless defined(&vec_expte);
    eval 'sub vec_floor () { &__builtin_vec_floor;}' unless defined(&vec_floor);
    eval 'sub vec_loge () { &__builtin_vec_loge;}' unless defined(&vec_loge);
    eval 'sub vec_madd () { &__builtin_vec_madd;}' unless defined(&vec_madd);
    eval 'sub vec_madds () { &__builtin_vec_madds;}' unless defined(&vec_madds);
    eval 'sub vec_mtvscr () { &__builtin_vec_mtvscr;}' unless defined(&vec_mtvscr);
    eval 'sub vec_vmaxfp () { &__builtin_vec_vmaxfp;}' unless defined(&vec_vmaxfp);
    eval 'sub vec_vmaxsw () { &__builtin_vec_vmaxsw;}' unless defined(&vec_vmaxsw);
    eval 'sub vec_vmaxsh () { &__builtin_vec_vmaxsh;}' unless defined(&vec_vmaxsh);
    eval 'sub vec_vmaxsb () { &__builtin_vec_vmaxsb;}' unless defined(&vec_vmaxsb);
    eval 'sub vec_vminfp () { &__builtin_vec_vminfp;}' unless defined(&vec_vminfp);
    eval 'sub vec_vminsw () { &__builtin_vec_vminsw;}' unless defined(&vec_vminsw);
    eval 'sub vec_vminsh () { &__builtin_vec_vminsh;}' unless defined(&vec_vminsh);
    eval 'sub vec_vminsb () { &__builtin_vec_vminsb;}' unless defined(&vec_vminsb);
    eval 'sub vec_mradds () { &__builtin_vec_mradds;}' unless defined(&vec_mradds);
    eval 'sub vec_vmsumshm () { &__builtin_vec_vmsumshm;}' unless defined(&vec_vmsumshm);
    eval 'sub vec_vmsumuhm () { &__builtin_vec_vmsumuhm;}' unless defined(&vec_vmsumuhm);
    eval 'sub vec_vmsummbm () { &__builtin_vec_vmsummbm;}' unless defined(&vec_vmsummbm);
    eval 'sub vec_vmsumubm () { &__builtin_vec_vmsumubm;}' unless defined(&vec_vmsumubm);
    eval 'sub vec_vmsumshs () { &__builtin_vec_vmsumshs;}' unless defined(&vec_vmsumshs);
    eval 'sub vec_vmsumuhs () { &__builtin_vec_vmsumuhs;}' unless defined(&vec_vmsumuhs);
    eval 'sub vec_vmulesb () { &__builtin_vec_vmulesb;}' unless defined(&vec_vmulesb);
    eval 'sub vec_vmulesh () { &__builtin_vec_vmulesh;}' unless defined(&vec_vmulesh);
    eval 'sub vec_vmuleuh () { &__builtin_vec_vmuleuh;}' unless defined(&vec_vmuleuh);
    eval 'sub vec_vmuleub () { &__builtin_vec_vmuleub;}' unless defined(&vec_vmuleub);
    eval 'sub vec_vmulosh () { &__builtin_vec_vmulosh;}' unless defined(&vec_vmulosh);
    eval 'sub vec_vmulouh () { &__builtin_vec_vmulouh;}' unless defined(&vec_vmulouh);
    eval 'sub vec_vmulosb () { &__builtin_vec_vmulosb;}' unless defined(&vec_vmulosb);
    eval 'sub vec_vmuloub () { &__builtin_vec_vmuloub;}' unless defined(&vec_vmuloub);
    eval 'sub vec_nmsub () { &__builtin_vec_nmsub;}' unless defined(&vec_nmsub);
    eval 'sub vec_packpx () { &__builtin_vec_packpx;}' unless defined(&vec_packpx);
    eval 'sub vec_vpkswss () { &__builtin_vec_vpkswss;}' unless defined(&vec_vpkswss);
    eval 'sub vec_vpkuwus () { &__builtin_vec_vpkuwus;}' unless defined(&vec_vpkuwus);
    eval 'sub vec_vpkshss () { &__builtin_vec_vpkshss;}' unless defined(&vec_vpkshss);
    eval 'sub vec_vpkuhus () { &__builtin_vec_vpkuhus;}' unless defined(&vec_vpkuhus);
    eval 'sub vec_vpkswus () { &__builtin_vec_vpkswus;}' unless defined(&vec_vpkswus);
    eval 'sub vec_vpkshus () { &__builtin_vec_vpkshus;}' unless defined(&vec_vpkshus);
    eval 'sub vec_re () { &__builtin_vec_re;}' unless defined(&vec_re);
    eval 'sub vec_round () { &__builtin_vec_round;}' unless defined(&vec_round);
    eval 'sub vec_recipdiv () { &__builtin_vec_recipdiv;}' unless defined(&vec_recipdiv);
    eval 'sub vec_rlmi () { &__builtin_vec_rlmi;}' unless defined(&vec_rlmi);
    eval 'sub vec_vrlnm () { &__builtin_vec_rlnm;}' unless defined(&vec_vrlnm);
    eval 'sub vec_rlnm {
        my($a,$b,$c) = @_;
	    eval q(( &__builtin_vec_rlnm(($a),(($b)<<8)|($c))));
    }' unless defined(&vec_rlnm);
    eval 'sub vec_rsqrt () { &__builtin_vec_rsqrt;}' unless defined(&vec_rsqrt);
    eval 'sub vec_rsqrte () { &__builtin_vec_rsqrte;}' unless defined(&vec_rsqrte);
    eval 'sub vec_vsubfp () { &__builtin_vec_vsubfp;}' unless defined(&vec_vsubfp);
    eval 'sub vec_subc () { &__builtin_vec_subc;}' unless defined(&vec_subc);
    eval 'sub vec_vsubsws () { &__builtin_vec_vsubsws;}' unless defined(&vec_vsubsws);
    eval 'sub vec_vsubshs () { &__builtin_vec_vsubshs;}' unless defined(&vec_vsubshs);
    eval 'sub vec_vsubsbs () { &__builtin_vec_vsubsbs;}' unless defined(&vec_vsubsbs);
    eval 'sub vec_sum4s () { &__builtin_vec_sum4s;}' unless defined(&vec_sum4s);
    eval 'sub vec_vsum4shs () { &__builtin_vec_vsum4shs;}' unless defined(&vec_vsum4shs);
    eval 'sub vec_vsum4sbs () { &__builtin_vec_vsum4sbs;}' unless defined(&vec_vsum4sbs);
    eval 'sub vec_vsum4ubs () { &__builtin_vec_vsum4ubs;}' unless defined(&vec_vsum4ubs);
    eval 'sub vec_sum2s () { &__builtin_vec_sum2s;}' unless defined(&vec_sum2s);
    eval 'sub vec_sums () { &__builtin_vec_sums;}' unless defined(&vec_sums);
    eval 'sub vec_trunc () { &__builtin_vec_trunc;}' unless defined(&vec_trunc);
    eval 'sub vec_vupkhpx () { &__builtin_vec_vupkhpx;}' unless defined(&vec_vupkhpx);
    eval 'sub vec_vupkhsh () { &__builtin_vec_vupkhsh;}' unless defined(&vec_vupkhsh);
    eval 'sub vec_vupkhsb () { &__builtin_vec_vupkhsb;}' unless defined(&vec_vupkhsb);
    eval 'sub vec_vupklpx () { &__builtin_vec_vupklpx;}' unless defined(&vec_vupklpx);
    eval 'sub vec_vupklsh () { &__builtin_vec_vupklsh;}' unless defined(&vec_vupklsh);
    eval 'sub vec_vupklsb () { &__builtin_vec_vupklsb;}' unless defined(&vec_vupklsb);
    eval 'sub vec_abs () { &__builtin_vec_abs;}' unless defined(&vec_abs);
    eval 'sub vec_nabs () { &__builtin_vec_nabs;}' unless defined(&vec_nabs);
    eval 'sub vec_abss () { &__builtin_vec_abss;}' unless defined(&vec_abss);
    eval 'sub vec_add () { &__builtin_vec_add;}' unless defined(&vec_add);
    eval 'sub vec_adds () { &__builtin_vec_adds;}' unless defined(&vec_adds);
    eval 'sub vec_and () { &__builtin_vec_and;}' unless defined(&vec_and);
    eval 'sub vec_andc () { &__builtin_vec_andc;}' unless defined(&vec_andc);
    eval 'sub vec_avg () { &__builtin_vec_avg;}' unless defined(&vec_avg);
    eval 'sub vec_cmpeq () { &__builtin_vec_cmpeq;}' unless defined(&vec_cmpeq);
    eval 'sub vec_cmpne () { &__builtin_vec_cmpne;}' unless defined(&vec_cmpne);
    eval 'sub vec_cmpgt () { &__builtin_vec_cmpgt;}' unless defined(&vec_cmpgt);
    eval 'sub vec_ctf () { &__builtin_vec_ctf;}' unless defined(&vec_ctf);
    eval 'sub vec_dst () { &__builtin_vec_dst;}' unless defined(&vec_dst);
    eval 'sub vec_dstst () { &__builtin_vec_dstst;}' unless defined(&vec_dstst);
    eval 'sub vec_dststt () { &__builtin_vec_dststt;}' unless defined(&vec_dststt);
    eval 'sub vec_dstt () { &__builtin_vec_dstt;}' unless defined(&vec_dstt);
    eval 'sub vec_ld () { &__builtin_vec_ld;}' unless defined(&vec_ld);
    eval 'sub vec_lde () { &__builtin_vec_lde;}' unless defined(&vec_lde);
    eval 'sub vec_ldl () { &__builtin_vec_ldl;}' unless defined(&vec_ldl);
    eval 'sub vec_lvebx () { &__builtin_vec_lvebx;}' unless defined(&vec_lvebx);
    eval 'sub vec_lvehx () { &__builtin_vec_lvehx;}' unless defined(&vec_lvehx);
    eval 'sub vec_lvewx () { &__builtin_vec_lvewx;}' unless defined(&vec_lvewx);
    eval 'sub vec_pmsum_be () { &__builtin_vec_vpmsum;}' unless defined(&vec_pmsum_be);
    eval 'sub vec_shasigma_be () { &__builtin_crypto_vshasigma;}' unless defined(&vec_shasigma_be);
    if(defined(&__PPU__)) {
	eval 'sub vec_lvlx () { &__builtin_vec_lvlx;}' unless defined(&vec_lvlx);
	eval 'sub vec_lvlxl () { &__builtin_vec_lvlxl;}' unless defined(&vec_lvlxl);
	eval 'sub vec_lvrx () { &__builtin_vec_lvrx;}' unless defined(&vec_lvrx);
	eval 'sub vec_lvrxl () { &__builtin_vec_lvrxl;}' unless defined(&vec_lvrxl);
    }
    eval 'sub vec_lvsl () { &__builtin_vec_lvsl;}' unless defined(&vec_lvsl);
    eval 'sub vec_lvsr () { &__builtin_vec_lvsr;}' unless defined(&vec_lvsr);
    eval 'sub vec_max () { &__builtin_vec_max;}' unless defined(&vec_max);
    eval 'sub vec_mergee () { &__builtin_vec_vmrgew;}' unless defined(&vec_mergee);
    eval 'sub vec_mergeh () { &__builtin_vec_mergeh;}' unless defined(&vec_mergeh);
    eval 'sub vec_mergel () { &__builtin_vec_mergel;}' unless defined(&vec_mergel);
    eval 'sub vec_mergeo () { &__builtin_vec_vmrgow;}' unless defined(&vec_mergeo);
    eval 'sub vec_min () { &__builtin_vec_min;}' unless defined(&vec_min);
    eval 'sub vec_mladd () { &__builtin_vec_mladd;}' unless defined(&vec_mladd);
    eval 'sub vec_msum () { &__builtin_vec_msum;}' unless defined(&vec_msum);
    eval 'sub vec_msums () { &__builtin_vec_msums;}' unless defined(&vec_msums);
    eval 'sub vec_mul () { &__builtin_vec_mul;}' unless defined(&vec_mul);
    eval 'sub vec_mule () { &__builtin_vec_mule;}' unless defined(&vec_mule);
    eval 'sub vec_mulo () { &__builtin_vec_mulo;}' unless defined(&vec_mulo);
    eval 'sub vec_nor () { &__builtin_vec_nor;}' unless defined(&vec_nor);
    eval 'sub vec_or () { &__builtin_vec_or;}' unless defined(&vec_or);
    eval 'sub vec_pack () { &__builtin_vec_pack;}' unless defined(&vec_pack);
    eval 'sub vec_packs () { &__builtin_vec_packs;}' unless defined(&vec_packs);
    eval 'sub vec_packsu () { &__builtin_vec_packsu;}' unless defined(&vec_packsu);
    eval 'sub vec_perm () { &__builtin_vec_perm;}' unless defined(&vec_perm);
    eval 'sub vec_rl () { &__builtin_vec_rl;}' unless defined(&vec_rl);
    eval 'sub vec_sel () { &__builtin_vec_sel;}' unless defined(&vec_sel);
    eval 'sub vec_sl () { &__builtin_vec_sl;}' unless defined(&vec_sl);
    eval 'sub vec_sld () { &__builtin_vec_sld;}' unless defined(&vec_sld);
    eval 'sub vec_sll () { &__builtin_vec_sll;}' unless defined(&vec_sll);
    eval 'sub vec_slo () { &__builtin_vec_slo;}' unless defined(&vec_slo);
    eval 'sub vec_splat () { &__builtin_vec_splat;}' unless defined(&vec_splat);
    eval 'sub vec_sr () { &__builtin_vec_sr;}' unless defined(&vec_sr);
    eval 'sub vec_sra () { &__builtin_vec_sra;}' unless defined(&vec_sra);
    eval 'sub vec_srl () { &__builtin_vec_srl;}' unless defined(&vec_srl);
    eval 'sub vec_sro () { &__builtin_vec_sro;}' unless defined(&vec_sro);
    eval 'sub vec_st () { &__builtin_vec_st;}' unless defined(&vec_st);
    eval 'sub vec_ste () { &__builtin_vec_ste;}' unless defined(&vec_ste);
    eval 'sub vec_stl () { &__builtin_vec_stl;}' unless defined(&vec_stl);
    eval 'sub vec_stvebx () { &__builtin_vec_stvebx;}' unless defined(&vec_stvebx);
    eval 'sub vec_stvehx () { &__builtin_vec_stvehx;}' unless defined(&vec_stvehx);
    eval 'sub vec_stvewx () { &__builtin_vec_stvewx;}' unless defined(&vec_stvewx);
    if(defined(&__PPU__)) {
	eval 'sub vec_stvlx () { &__builtin_vec_stvlx;}' unless defined(&vec_stvlx);
	eval 'sub vec_stvlxl () { &__builtin_vec_stvlxl;}' unless defined(&vec_stvlxl);
	eval 'sub vec_stvrx () { &__builtin_vec_stvrx;}' unless defined(&vec_stvrx);
	eval 'sub vec_stvrxl () { &__builtin_vec_stvrxl;}' unless defined(&vec_stvrxl);
    }
    eval 'sub vec_sub () { &__builtin_vec_sub;}' unless defined(&vec_sub);
    eval 'sub vec_subs () { &__builtin_vec_subs;}' unless defined(&vec_subs);
    eval 'sub vec_sum () { &__builtin_vec_sum;}' unless defined(&vec_sum);
    eval 'sub vec_unpackh () { &__builtin_vec_unpackh;}' unless defined(&vec_unpackh);
    eval 'sub vec_unpackl () { &__builtin_vec_unpackl;}' unless defined(&vec_unpackl);
    eval 'sub vec_vaddubm () { &__builtin_vec_vaddubm;}' unless defined(&vec_vaddubm);
    eval 'sub vec_vaddubs () { &__builtin_vec_vaddubs;}' unless defined(&vec_vaddubs);
    eval 'sub vec_vadduhm () { &__builtin_vec_vadduhm;}' unless defined(&vec_vadduhm);
    eval 'sub vec_vadduhs () { &__builtin_vec_vadduhs;}' unless defined(&vec_vadduhs);
    eval 'sub vec_vadduwm () { &__builtin_vec_vadduwm;}' unless defined(&vec_vadduwm);
    eval 'sub vec_vadduws () { &__builtin_vec_vadduws;}' unless defined(&vec_vadduws);
    eval 'sub vec_vcmpequb () { &__builtin_vec_vcmpequb;}' unless defined(&vec_vcmpequb);
    eval 'sub vec_vcmpequh () { &__builtin_vec_vcmpequh;}' unless defined(&vec_vcmpequh);
    eval 'sub vec_vcmpequw () { &__builtin_vec_vcmpequw;}' unless defined(&vec_vcmpequw);
    eval 'sub vec_vmaxub () { &__builtin_vec_vmaxub;}' unless defined(&vec_vmaxub);
    eval 'sub vec_vmaxuh () { &__builtin_vec_vmaxuh;}' unless defined(&vec_vmaxuh);
    eval 'sub vec_vmaxuw () { &__builtin_vec_vmaxuw;}' unless defined(&vec_vmaxuw);
    eval 'sub vec_vminub () { &__builtin_vec_vminub;}' unless defined(&vec_vminub);
    eval 'sub vec_vminuh () { &__builtin_vec_vminuh;}' unless defined(&vec_vminuh);
    eval 'sub vec_vminuw () { &__builtin_vec_vminuw;}' unless defined(&vec_vminuw);
    eval 'sub vec_vmrghb () { &__builtin_vec_vmrghb;}' unless defined(&vec_vmrghb);
    eval 'sub vec_vmrghh () { &__builtin_vec_vmrghh;}' unless defined(&vec_vmrghh);
    eval 'sub vec_vmrghw () { &__builtin_vec_vmrghw;}' unless defined(&vec_vmrghw);
    eval 'sub vec_vmrglb () { &__builtin_vec_vmrglb;}' unless defined(&vec_vmrglb);
    eval 'sub vec_vmrglh () { &__builtin_vec_vmrglh;}' unless defined(&vec_vmrglh);
    eval 'sub vec_vmrglw () { &__builtin_vec_vmrglw;}' unless defined(&vec_vmrglw);
    eval 'sub vec_vpkuhum () { &__builtin_vec_vpkuhum;}' unless defined(&vec_vpkuhum);
    eval 'sub vec_vpkuwum () { &__builtin_vec_vpkuwum;}' unless defined(&vec_vpkuwum);
    eval 'sub vec_vrlb () { &__builtin_vec_vrlb;}' unless defined(&vec_vrlb);
    eval 'sub vec_vrlh () { &__builtin_vec_vrlh;}' unless defined(&vec_vrlh);
    eval 'sub vec_vrlw () { &__builtin_vec_vrlw;}' unless defined(&vec_vrlw);
    eval 'sub vec_vslb () { &__builtin_vec_vslb;}' unless defined(&vec_vslb);
    eval 'sub vec_vslh () { &__builtin_vec_vslh;}' unless defined(&vec_vslh);
    eval 'sub vec_vslw () { &__builtin_vec_vslw;}' unless defined(&vec_vslw);
    eval 'sub vec_vspltb () { &__builtin_vec_vspltb;}' unless defined(&vec_vspltb);
    eval 'sub vec_vsplth () { &__builtin_vec_vsplth;}' unless defined(&vec_vsplth);
    eval 'sub vec_vspltw () { &__builtin_vec_vspltw;}' unless defined(&vec_vspltw);
    eval 'sub vec_vsrab () { &__builtin_vec_vsrab;}' unless defined(&vec_vsrab);
    eval 'sub vec_vsrah () { &__builtin_vec_vsrah;}' unless defined(&vec_vsrah);
    eval 'sub vec_vsraw () { &__builtin_vec_vsraw;}' unless defined(&vec_vsraw);
    eval 'sub vec_vsrb () { &__builtin_vec_vsrb;}' unless defined(&vec_vsrb);
    eval 'sub vec_vsrh () { &__builtin_vec_vsrh;}' unless defined(&vec_vsrh);
    eval 'sub vec_vsrw () { &__builtin_vec_vsrw;}' unless defined(&vec_vsrw);
    eval 'sub vec_vsububs () { &__builtin_vec_vsububs;}' unless defined(&vec_vsububs);
    eval 'sub vec_vsububm () { &__builtin_vec_vsububm;}' unless defined(&vec_vsububm);
    eval 'sub vec_vsubuhm () { &__builtin_vec_vsubuhm;}' unless defined(&vec_vsubuhm);
    eval 'sub vec_vsubuhs () { &__builtin_vec_vsubuhs;}' unless defined(&vec_vsubuhs);
    eval 'sub vec_vsubuwm () { &__builtin_vec_vsubuwm;}' unless defined(&vec_vsubuwm);
    eval 'sub vec_vsubuws () { &__builtin_vec_vsubuws;}' unless defined(&vec_vsubuws);
    eval 'sub vec_xor () { &__builtin_vec_xor;}' unless defined(&vec_xor);
    eval 'sub vec_extract () { &__builtin_vec_extract;}' unless defined(&vec_extract);
    eval 'sub vec_insert () { &__builtin_vec_insert;}' unless defined(&vec_insert);
    eval 'sub vec_splats () { &__builtin_vec_splats;}' unless defined(&vec_splats);
    eval 'sub vec_promote () { &__builtin_vec_promote;}' unless defined(&vec_promote);
    if(defined(&__VSX__)) {
	eval 'sub vec_div () { &__builtin_vec_div;}' unless defined(&vec_div);
	eval 'sub vec_mul () { &__builtin_vec_mul;}' unless defined(&vec_mul);
	eval 'sub vec_msub () { &__builtin_vec_msub;}' unless defined(&vec_msub);
	eval 'sub vec_nmadd () { &__builtin_vec_nmadd;}' unless defined(&vec_nmadd);
	eval 'sub vec_nearbyint () { &__builtin_vec_nearbyint;}' unless defined(&vec_nearbyint);
	eval 'sub vec_rint () { &__builtin_vec_rint;}' unless defined(&vec_rint);
	eval 'sub vec_sqrt () { &__builtin_vec_sqrt;}' unless defined(&vec_sqrt);
	eval 'sub vec_vsx_ld () { &__builtin_vec_vsx_ld;}' unless defined(&vec_vsx_ld);
	eval 'sub vec_vsx_st () { &__builtin_vec_vsx_st;}' unless defined(&vec_vsx_st);
	eval 'sub vec_xl () { &__builtin_vec_vsx_ld;}' unless defined(&vec_xl);
	eval 'sub vec_xst () { &__builtin_vec_vsx_st;}' unless defined(&vec_xst);
	eval 'sub vec_xxsldwi () { &__builtin_vsx_xxsldwi;}' unless defined(&vec_xxsldwi);
	eval 'sub vec_xxpermdi () { &__builtin_vsx_xxpermdi;}' unless defined(&vec_xxpermdi);
    }
    if(defined(&_ARCH_PWR8)) {
	eval 'sub vec_eqv () { &__builtin_vec_eqv;}' unless defined(&vec_eqv);
	eval 'sub vec_nand () { &__builtin_vec_nand;}' unless defined(&vec_nand);
	eval 'sub vec_orc () { &__builtin_vec_orc;}' unless defined(&vec_orc);
	eval 'sub vec_vaddcuq () { &__builtin_vec_vaddcuq;}' unless defined(&vec_vaddcuq);
	eval 'sub vec_vaddudm () { &__builtin_vec_vaddudm;}' unless defined(&vec_vaddudm);
	eval 'sub vec_vadduqm () { &__builtin_vec_vadduqm;}' unless defined(&vec_vadduqm);
	eval 'sub vec_vbpermq () { &__builtin_vec_vbpermq;}' unless defined(&vec_vbpermq);
	eval 'sub vec_bperm () { &__builtin_vec_vbperm_api;}' unless defined(&vec_bperm);
	eval 'sub vec_vclz () { &__builtin_vec_vclz;}' unless defined(&vec_vclz);
	eval 'sub vec_cntlz () { &__builtin_vec_vclz;}' unless defined(&vec_cntlz);
	eval 'sub vec_vclzb () { &__builtin_vec_vclzb;}' unless defined(&vec_vclzb);
	eval 'sub vec_vclzd () { &__builtin_vec_vclzd;}' unless defined(&vec_vclzd);
	eval 'sub vec_vclzh () { &__builtin_vec_vclzh;}' unless defined(&vec_vclzh);
	eval 'sub vec_vclzw () { &__builtin_vec_vclzw;}' unless defined(&vec_vclzw);
	eval 'sub vec_vaddecuq () { &__builtin_vec_vaddecuq;}' unless defined(&vec_vaddecuq);
	eval 'sub vec_vaddeuqm () { &__builtin_vec_vaddeuqm;}' unless defined(&vec_vaddeuqm);
	eval 'sub vec_vsubecuq () { &__builtin_vec_vsubecuq;}' unless defined(&vec_vsubecuq);
	eval 'sub vec_vsubeuqm () { &__builtin_vec_vsubeuqm;}' unless defined(&vec_vsubeuqm);
	eval 'sub vec_vgbbd () { &__builtin_vec_vgbbd;}' unless defined(&vec_vgbbd);
	eval 'sub vec_gb () { &__builtin_vec_vgbbd;}' unless defined(&vec_gb);
	eval 'sub vec_vmaxsd () { &__builtin_vec_vmaxsd;}' unless defined(&vec_vmaxsd);
	eval 'sub vec_vmaxud () { &__builtin_vec_vmaxud;}' unless defined(&vec_vmaxud);
	eval 'sub vec_vminsd () { &__builtin_vec_vminsd;}' unless defined(&vec_vminsd);
	eval 'sub vec_vminud () { &__builtin_vec_vminud;}' unless defined(&vec_vminud);
	eval 'sub vec_vmrgew () { &__builtin_vec_vmrgew;}' unless defined(&vec_vmrgew);
	eval 'sub vec_vmrgow () { &__builtin_vec_vmrgow;}' unless defined(&vec_vmrgow);
	eval 'sub vec_vpksdss () { &__builtin_vec_vpksdss;}' unless defined(&vec_vpksdss);
	eval 'sub vec_vpksdus () { &__builtin_vec_vpksdus;}' unless defined(&vec_vpksdus);
	eval 'sub vec_vpkudum () { &__builtin_vec_vpkudum;}' unless defined(&vec_vpkudum);
	eval 'sub vec_vpkudus () { &__builtin_vec_vpkudus;}' unless defined(&vec_vpkudus);
	eval 'sub vec_vpopcnt () { &__builtin_vec_vpopcnt;}' unless defined(&vec_vpopcnt);
	eval 'sub vec_vpopcntb () { &__builtin_vec_vpopcntb;}' unless defined(&vec_vpopcntb);
	eval 'sub vec_vpopcntd () { &__builtin_vec_vpopcntd;}' unless defined(&vec_vpopcntd);
	eval 'sub vec_vpopcnth () { &__builtin_vec_vpopcnth;}' unless defined(&vec_vpopcnth);
	eval 'sub vec_vpopcntw () { &__builtin_vec_vpopcntw;}' unless defined(&vec_vpopcntw);
	eval 'sub vec_vrld () { &__builtin_vec_vrld;}' unless defined(&vec_vrld);
	eval 'sub vec_vsld () { &__builtin_vec_vsld;}' unless defined(&vec_vsld);
	eval 'sub vec_vsrad () { &__builtin_vec_vsrad;}' unless defined(&vec_vsrad);
	eval 'sub vec_vsrd () { &__builtin_vec_vsrd;}' unless defined(&vec_vsrd);
	eval 'sub vec_vsubcuq () { &__builtin_vec_vsubcuq;}' unless defined(&vec_vsubcuq);
	eval 'sub vec_vsubudm () { &__builtin_vec_vsubudm;}' unless defined(&vec_vsubudm);
	eval 'sub vec_vsubuqm () { &__builtin_vec_vsubuqm;}' unless defined(&vec_vsubuqm);
	eval 'sub vec_vupkhsw () { &__builtin_vec_vupkhsw;}' unless defined(&vec_vupkhsw);
	eval 'sub vec_vupklsw () { &__builtin_vec_vupklsw;}' unless defined(&vec_vupklsw);
    }
    if(defined(&__POWER9_VECTOR__)) {
	eval 'sub vec_vctz () { &__builtin_vec_vctz;}' unless defined(&vec_vctz);
	eval 'sub vec_cnttz () { &__builtin_vec_vctz;}' unless defined(&vec_cnttz);
	eval 'sub vec_vctzb () { &__builtin_vec_vctzb;}' unless defined(&vec_vctzb);
	eval 'sub vec_vctzd () { &__builtin_vec_vctzd;}' unless defined(&vec_vctzd);
	eval 'sub vec_vctzh () { &__builtin_vec_vctzh;}' unless defined(&vec_vctzh);
	eval 'sub vec_vctzw () { &__builtin_vec_vctzw;}' unless defined(&vec_vctzw);
	eval 'sub vec_extract4b () { &__builtin_vec_extract4b;}' unless defined(&vec_extract4b);
	eval 'sub vec_insert4b () { &__builtin_vec_insert4b;}' unless defined(&vec_insert4b);
	eval 'sub vec_vprtyb () { &__builtin_vec_vprtyb;}' unless defined(&vec_vprtyb);
	eval 'sub vec_vprtybd () { &__builtin_vec_vprtybd;}' unless defined(&vec_vprtybd);
	eval 'sub vec_vprtybw () { &__builtin_vec_vprtybw;}' unless defined(&vec_vprtybw);
	if(defined(&_ARCH_PPC64)) {
	    eval 'sub vec_vprtybq () { &__builtin_vec_vprtybq;}' unless defined(&vec_vprtybq);
	}
	eval 'sub vec_absd () { &__builtin_vec_vadu;}' unless defined(&vec_absd);
	eval 'sub vec_absdb () { &__builtin_vec_vadub;}' unless defined(&vec_absdb);
	eval 'sub vec_absdh () { &__builtin_vec_vaduh;}' unless defined(&vec_absdh);
	eval 'sub vec_absdw () { &__builtin_vec_vaduw;}' unless defined(&vec_absdw);
	eval 'sub vec_slv () { &__builtin_vec_vslv;}' unless defined(&vec_slv);
	eval 'sub vec_srv () { &__builtin_vec_vsrv;}' unless defined(&vec_srv);
	eval 'sub vec_extract_exp () { &__builtin_vec_extract_exp;}' unless defined(&vec_extract_exp);
	eval 'sub vec_extract_sig () { &__builtin_vec_extract_sig;}' unless defined(&vec_extract_sig);
	eval 'sub vec_insert_exp () { &__builtin_vec_insert_exp;}' unless defined(&vec_insert_exp);
	eval 'sub vec_test_data_class () { &__builtin_vec_test_data_class;}' unless defined(&vec_test_data_class);
	eval 'sub scalar_extract_exp () { &__builtin_vec_scalar_extract_exp;}' unless defined(&scalar_extract_exp);
	eval 'sub scalar_extract_sig () { &__builtin_vec_scalar_extract_sig;}' unless defined(&scalar_extract_sig);
	eval 'sub scalar_insert_exp () { &__builtin_vec_scalar_insert_exp;}' unless defined(&scalar_insert_exp);
	eval 'sub scalar_test_data_class () { &__builtin_vec_scalar_test_data_class;}' unless defined(&scalar_test_data_class);
	eval 'sub scalar_test_neg () { &__builtin_vec_scalar_test_neg;}' unless defined(&scalar_test_neg);
	eval 'sub scalar_cmp_exp_gt () { &__builtin_vec_scalar_cmp_exp_gt;}' unless defined(&scalar_cmp_exp_gt);
	eval 'sub scalar_cmp_exp_lt () { &__builtin_vec_scalar_cmp_exp_lt;}' unless defined(&scalar_cmp_exp_lt);
	eval 'sub scalar_cmp_exp_eq () { &__builtin_vec_scalar_cmp_exp_eq;}' unless defined(&scalar_cmp_exp_eq);
	eval 'sub scalar_cmp_exp_unordered () { &__builtin_vec_scalar_cmp_exp_unordered;}' unless defined(&scalar_cmp_exp_unordered);
	if(defined(&_ARCH_PPC64)) {
	    eval 'sub vec_xl_len () { &__builtin_vec_lxvl;}' unless defined(&vec_xl_len);
	    eval 'sub vec_xst_len () { &__builtin_vec_stxvl;}' unless defined(&vec_xst_len);
	}
	eval 'sub vec_cmpnez () { &__builtin_vec_vcmpnez;}' unless defined(&vec_cmpnez);
	eval 'sub vec_cntlz_lsbb () { &__builtin_vec_vclzlsbb;}' unless defined(&vec_cntlz_lsbb);
	eval 'sub vec_cnttz_lsbb () { &__builtin_vec_vctzlsbb;}' unless defined(&vec_cnttz_lsbb);
	eval 'sub vec_xlx () { &__builtin_vec_vextulx;}' unless defined(&vec_xlx);
	eval 'sub vec_xrx () { &__builtin_vec_vexturx;}' unless defined(&vec_xrx);
	eval 'sub vec_revb () { &__builtin_vec_revb;}' unless defined(&vec_revb);
    }
    if(defined(&__cplusplus__)) {
	eval 'sub __altivec_unary_pred {
	    my($NAME, $CALL) = @_;
    	    eval q( &template < &class  &T> \'int\' $NAME ( &T  &a1) {  &return $CALL; });
	}' unless defined(&__altivec_unary_pred);
	eval 'sub __altivec_scalar_pred {
	    my($NAME, $CALL) = @_;
    	    eval q( &template < &class  &T,  &class  &U> \'int\' $NAME ( &T  &a1,  &U  &a2) {  &return $CALL; });
	}' unless defined(&__altivec_scalar_pred);
	eval 'sub __altivec_binary_pred {
	    my($NAME, $CALL) = @_;
    	    eval q( &template < &class  &T,  &class  &U>  &typename  &__altivec_bool_ret < &vec_step ( &T)>:: &__ret $NAME ( &T  &a1,  &U  &a2) {  &return $CALL; });
	}' unless defined(&__altivec_binary_pred);
	unless(defined(&__POWER9_VECTOR__)) {
	} else {
	}
	undef(&__altivec_scalar_pred) if defined(&__altivec_scalar_pred);
	undef(&__altivec_unary_pred) if defined(&__altivec_unary_pred);
	undef(&__altivec_binary_pred) if defined(&__altivec_binary_pred);
    } else {
	eval 'sub vec_cmplt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_cmpgt (($a2), ($a1)));
	}' unless defined(&vec_cmplt);
	eval 'sub vec_cmple {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_cmpge (($a2), ($a1)));
	}' unless defined(&vec_cmple);
	eval 'sub vec_all_in {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpbfp_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_in);
	eval 'sub vec_any_out {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_altivec_vcmpbfp_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_out);
	eval 'sub vec_all_nan {
	    my($a1) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ, ($a1), ($a1)));
	}' unless defined(&vec_all_nan);
	eval 'sub vec_any_nan {
	    my($a1) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT_REV, ($a1), ($a1)));
	}' unless defined(&vec_any_nan);
	eval 'sub vec_all_numeric {
	    my($a1) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT, ($a1), ($a1)));
	}' unless defined(&vec_all_numeric);
	eval 'sub vec_any_numeric {
	    my($a1) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ_REV, ($a1), ($a1)));
	}' unless defined(&vec_any_numeric);
	eval 'sub vec_all_eq {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT, ($a1), ($a2)));
	}' unless defined(&vec_all_eq);
	if(defined(&__POWER9_VECTOR__)) {
	    eval 'sub vec_all_nez {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpnez_p ( &__CR6_LT, ($a1), ($a2)));
	    }' unless defined(&vec_all_nez);
	    eval 'sub vec_any_eqz {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpnez_p ( &__CR6_LT_REV, ($a1), ($a2)));
	    }' unless defined(&vec_any_eqz);
	    eval 'sub vec_all_ne {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpne_p (($a1), ($a2)));
	    }' unless defined(&vec_all_ne);
	    eval 'sub vec_any_eq {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpae_p (($a1), ($a2)));
	    }' unless defined(&vec_any_eq);
	} else {
	    eval 'sub vec_all_ne {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ, ($a1), ($a2)));
	    }' unless defined(&vec_all_ne);
	    eval 'sub vec_any_eq {
	        my($a1, $a2) = @_;
    		eval q( &__builtin_vec_vcmpeq_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	    }' unless defined(&vec_any_eq);
	}
	eval 'sub vec_any_ne {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpeq_p ( &__CR6_LT_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_ne);
	eval 'sub vec_all_gt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT, ($a1), ($a2)));
	}' unless defined(&vec_all_gt);
	eval 'sub vec_all_lt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT, ($a2), ($a1)));
	}' unless defined(&vec_all_lt);
	eval 'sub vec_any_gt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_gt);
	eval 'sub vec_any_lt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_lt);
	eval 'sub vec_all_ngt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_ngt);
	eval 'sub vec_all_nlt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_EQ, ($a2), ($a1)));
	}' unless defined(&vec_all_nlt);
	eval 'sub vec_any_ngt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_ngt);
	eval 'sub vec_any_nlt {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpgt_p ( &__CR6_LT_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_nlt);
	eval 'sub vec_all_le {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT, ($a2), ($a1)));
	}' unless defined(&vec_all_le);
	eval 'sub vec_all_ge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT, ($a1), ($a2)));
	}' unless defined(&vec_all_ge);
	eval 'sub vec_any_le {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_le);
	eval 'sub vec_any_ge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_ge);
	eval 'sub vec_all_nge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ, ($a1), ($a2)));
	}' unless defined(&vec_all_nge);
	eval 'sub vec_all_nle {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_EQ, ($a2), ($a1)));
	}' unless defined(&vec_all_nle);
	eval 'sub vec_any_nge {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT_REV, ($a1), ($a2)));
	}' unless defined(&vec_any_nge);
	eval 'sub vec_any_nle {
	    my($a1, $a2) = @_;
    	    eval q( &__builtin_vec_vcmpge_p ( &__CR6_LT_REV, ($a2), ($a1)));
	}' unless defined(&vec_any_nle);
    }
    eval 'sub vec_dss {
        my($x) = @_;
	    eval q( &__builtin_altivec_dss(($x)));
    }' unless defined(&vec_dss);
    eval 'sub vec_dssall () {
        eval q( &__builtin_altivec_dssall ());
    }' unless defined(&vec_dssall);
    eval 'sub vec_mfvscr () {
        eval q((( &__vector \'unsigned short\')  &__builtin_altivec_mfvscr ()));
    }' unless defined(&vec_mfvscr);
    eval 'sub vec_splat_s8 {
        my($x) = @_;
	    eval q( &__builtin_altivec_vspltisb (($x)));
    }' unless defined(&vec_splat_s8);
    eval 'sub vec_splat_s16 {
        my($x) = @_;
	    eval q( &__builtin_altivec_vspltish (($x)));
    }' unless defined(&vec_splat_s16);
    eval 'sub vec_splat_s32 {
        my($x) = @_;
	    eval q( &__builtin_altivec_vspltisw (($x)));
    }' unless defined(&vec_splat_s32);
    eval 'sub vec_splat_u8 {
        my($x) = @_;
	    eval q((( &__vector \'unsigned char\')  &vec_splat_s8 (($x))));
    }' unless defined(&vec_splat_u8);
    eval 'sub vec_splat_u16 {
        my($x) = @_;
	    eval q((( &__vector \'unsigned short\')  &vec_splat_s16 (($x))));
    }' unless defined(&vec_splat_u16);
    eval 'sub vec_splat_u32 {
        my($x) = @_;
	    eval q((( &__vector \'unsigned int\')  &vec_splat_s32 (($x))));
    }' unless defined(&vec_splat_u32);
    eval 'sub vec_step {
        my($x) = @_;
	    eval q( &__builtin_vec_step (* ( &__typeof__ ($x) *) 0));
    }' unless defined(&vec_step);
}
1;
