/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.UnicodeStringParser;
import writer2latex.latex.style.UnicodeTable;
import writer2latex.latex.style.UnicodeTableHandler;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.CSVList;
import writer2latex.util.Config;

public class I18n {
    public static final int ASCII = 0;
    public static final int LATIN1 = 1;
    public static final int LATIN2 = 2;
    public static final int ISO_8859_7 = 3;
    public static final int CP1250 = 4;
    public static final int CP1251 = 5;
    public static final int KOI8_R = 6;
    public static final int UTF8 = 7;
    public static final int OT1_ENC = 1;
    public static final int T1_ENC = 2;
    public static final int T2A_ENC = 4;
    public static final int T3_ENC = 8;
    public static final int LGR_ENC = 16;
    public static final int ANY_ENC = 31;
    private Hashtable tableSet;
    private UnicodeTable table;
    private Stack tableStack;
    private UnicodeStringParser ucparser;
    private String sDefaultLang = null;
    private int nDefaultFontenc = 0;
    private boolean bAlwaysUseDefaultLang = false;
    private boolean bT2A = false;
    private boolean bGreek = false;
    private boolean bPolytonicGreek = false;
    private boolean bGreekMath;
    private String sMajorityLanguage = null;
    private Config config;
    private WriterStyleCollection wsc;

    public static final int readInputenc(String sInputenc) {
        if ("ascii".equals(sInputenc)) {
            return 0;
        }
        if ("latin1".equals(sInputenc)) {
            return 1;
        }
        if ("latin2".equals(sInputenc)) {
            return 2;
        }
        if ("iso-8859-7".equals(sInputenc)) {
            return 3;
        }
        if ("cp1250".equals(sInputenc)) {
            return 4;
        }
        if ("cp1251".equals(sInputenc)) {
            return 5;
        }
        if ("koi8-r".equals(sInputenc)) {
            return 6;
        }
        if ("utf8".equals(sInputenc)) {
            return 7;
        }
        return 0;
    }

    public static final String writeInputenc(int nInputenc) {
        switch (nInputenc) {
            case 0: {
                return "ascii";
            }
            case 1: {
                return "latin1";
            }
            case 2: {
                return "latin2";
            }
            case 3: {
                return "iso-8859-7";
            }
            case 4: {
                return "cp1250";
            }
            case 5: {
                return "cp1251";
            }
            case 6: {
                return "koi8-r";
            }
            case 7: {
                return "utf8";
            }
        }
        return "???";
    }

    public static final String writeJavaEncoding(int nInputenc) {
        switch (nInputenc) {
            case 0: {
                return "ASCII";
            }
            case 1: {
                return "ISO8859_1";
            }
            case 2: {
                return "ISO8859_2";
            }
            case 3: {
                return "ISO8859_7";
            }
            case 4: {
                return "Cp1250";
            }
            case 5: {
                return "Cp1251";
            }
            case 6: {
                return "KOI8_R";
            }
            case 7: {
                return "UTF-8";
            }
        }
        return "???";
    }

    public static final int readFontencs(String sFontencs) {
        if ("ANY".equals(sFontencs = sFontencs.toUpperCase())) {
            return 31;
        }
        int nFontencs = 0;
        int nOT1 = sFontencs.indexOf("OT1");
        int nT1 = sFontencs.indexOf("T1");
        int nT2A = sFontencs.indexOf("T2A");
        int nT3 = sFontencs.indexOf("T3");
        int nLGR = sFontencs.indexOf("LGR");
        if (nOT1 >= 0) {
            ++nFontencs;
        }
        if (nT1 == 0 || nT1 > 0 && nT1 != nOT1 + 1) {
            nFontencs += 2;
        }
        if (nT2A >= 0) {
            nFontencs += 4;
        }
        if (nT3 >= 0) {
            nFontencs += 8;
        }
        if (nLGR >= 0) {
            nFontencs += 16;
        }
        return nFontencs;
    }

    public static final String writeFontenc(int nFontenc) {
        switch (nFontenc) {
            case 1: {
                return "OT1";
            }
            case 2: {
                return "T1";
            }
            case 4: {
                return "T2A";
            }
            case 8: {
                return "T3";
            }
            case 16: {
                return "LGR";
            }
        }
        return null;
    }

    public static final boolean supportsFontenc(int nFontencs, int nFontenc) {
        return (nFontencs & nFontenc) != 0;
    }

    public static final int getFontenc(int nFontencs) {
        if (I18n.supportsFontenc(nFontencs, 2)) {
            return 2;
        }
        if (I18n.supportsFontenc(nFontencs, 4)) {
            return 4;
        }
        if (I18n.supportsFontenc(nFontencs, 8)) {
            return 8;
        }
        if (I18n.supportsFontenc(nFontencs, 16)) {
            return 16;
        }
        return 0;
    }

    public static final int getFontenc(String sLang) {
        if ("el".equals(sLang)) {
            return 16;
        }
        if ("ru".equals(sLang)) {
            return 4;
        }
        if ("uk".equals(sLang)) {
            return 4;
        }
        if ("bg".equals(sLang)) {
            return 4;
        }
        if ("sr".equals(sLang)) {
            return 4;
        }
        return 2;
    }

    public static final String getFontencCs(int nFontenc) {
        switch (nFontenc) {
            case 2: {
                return "\\textlatin";
            }
            case 4: {
                return "\\textcyrillic";
            }
            case 8: {
                return "\\textipa";
            }
            case 16: {
                return "\\textgreek";
            }
        }
        return null;
    }

    public static final String getBabelLanguage(String sLanguage) {
        if ("en".equals(sLanguage)) {
            return "english";
        }
        if ("bg".equals(sLanguage)) {
            return "bulgarian";
        }
        if ("cs".equals(sLanguage)) {
            return "czech";
        }
        if ("da".equals(sLanguage)) {
            return "danish";
        }
        if ("de".equals(sLanguage)) {
            return "german";
        }
        if ("el".equals(sLanguage)) {
            return "greek";
        }
        if ("es".equals(sLanguage)) {
            return "spanish";
        }
        if ("fi".equals(sLanguage)) {
            return "finnish";
        }
        if ("fr".equals(sLanguage)) {
            return "french";
        }
        if ("ga".equals(sLanguage)) {
            return "irish";
        }
        if ("hr".equals(sLanguage)) {
            return "croatian";
        }
        if ("hu".equals(sLanguage)) {
            return "magyar";
        }
        if ("is".equals(sLanguage)) {
            return "icelandic";
        }
        if ("it".equals(sLanguage)) {
            return "italian";
        }
        if ("nl".equals(sLanguage)) {
            return "dutch";
        }
        if ("no".equals(sLanguage)) {
            return "norsk";
        }
        if ("pl".equals(sLanguage)) {
            return "polish";
        }
        if ("pt".equals(sLanguage)) {
            return "portuges";
        }
        if ("ro".equals(sLanguage)) {
            return "romanian";
        }
        if ("ru".equals(sLanguage)) {
            return "russian";
        }
        if ("sk".equals(sLanguage)) {
            return "slovak";
        }
        if ("sl".equals(sLanguage)) {
            return "slovene";
        }
        if ("sr".equals(sLanguage)) {
            return "serbian";
        }
        if ("sv".equals(sLanguage)) {
            return "swedish";
        }
        if ("uk".equals(sLanguage)) {
            return "ukrainian";
        }
        return null;
    }

    public I18n(WriterStyleCollection wsc, Config config, ConverterPalette palette) {
        this.wsc = wsc;
        this.config = config;
        String sSymbols = "ascii";
        if (config.getInputencoding() != 0) {
            sSymbols = sSymbols + "|" + I18n.writeInputenc(config.getInputencoding());
        }
        if (config.useWasysym()) {
            sSymbols = sSymbols + "|wasysym";
        }
        if (config.useBbding()) {
            sSymbols = sSymbols + "|bbding";
        }
        if (config.useIfsym()) {
            sSymbols = sSymbols + "|ifsym";
        }
        if (config.usePifont()) {
            sSymbols = sSymbols + "|dingbats";
        }
        if (config.useEurosym()) {
            sSymbols = sSymbols + "|eurosym";
        }
        if (config.useTipa()) {
            sSymbols = sSymbols + "tipa";
        }
        this.readSymbols(sSymbols);
        this.bGreekMath = config.greekMath();
        this.bAlwaysUseDefaultLang = !config.multilingual();
        this.ucparser = new UnicodeStringParser();
    }

    public I18n(String sSymbols) {
        this.readSymbols(sSymbols);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.config.getInputencoding() == 7) {
            pack.append("\\usepackage[dirty,autogenerated]{ucs}").nl();
        }
        pack.append("\\usepackage[").append(I18n.writeInputenc(this.config.getInputencoding())).append("]{inputenc}").nl();
        CSVList fontencs = new CSVList(',');
        if (this.bT2A) {
            fontencs.addValue("T2A");
        }
        if (this.bGreek) {
            fontencs.addValue("LGR");
        }
        if (this.config.useTipa()) {
            fontencs.addValue("T3");
        }
        fontencs.addValue("T1");
        pack.append("\\usepackage[").append(fontencs.toString()).append("]{fontenc}").nl();
        this.convertLanguageUsage(pack);
        if (this.config.useTipa()) {
            pack.append("\\usepackage[noenc]{tipa}").nl().append("\\usepackage{tipx}").nl();
        }
        if (this.config.useBbding()) {
            pack.append("\\usepackage{bbding}").nl().append("\\let\\bbCross\\Cross\\let\\Cross\\undefined").nl().append("\\let\\bbSquare\\Square\\let\\Square\\undefined").nl().append("\\let\\bbTrianbleUp\\TriangleUp\\let\\TriangleUp\\undefined").nl().append("\\let\\bbTrianlgeDown\\TriangleDown\\let\\TriangleDown\\undefined").nl();
        }
        if (this.config.useIfsym()) {
            pack.append("\\usepackage[geometry,weather,misc,clock]{ifsym}").nl();
        }
        if (this.config.usePifont()) {
            pack.append("\\usepackage{pifont}").nl();
        }
        if (this.config.useEurosym()) {
            pack.append("\\usepackage{eurosym}").nl();
        }
        if (this.config.useWasysym()) {
            pack.append("\\usepackage{amsmath,wasysym,amssymb,amsfonts,textcomp}").nl();
        } else {
            pack.append("\\usepackage{amsmath,amssymb,amsfonts,textcomp}").nl();
        }
    }

    public void setDefaultLanguage(String sDefaultLang) {
        this.sDefaultLang = sDefaultLang;
        this.nDefaultFontenc = I18n.getFontenc(sDefaultLang);
    }

    public void applyLanguage(StyleWithProperties style, boolean bDecl, boolean bInherit, BeforeAfter ba) {
        if (this.bAlwaysUseDefaultLang) {
            return;
        }
        if (style == null) {
            return;
        }
        String sLang = I18n.getBabelLanguage(style.getProperty("fo:language", bInherit));
        if (sLang == null) {
            return;
        }
        if (bDecl) {
            ba.add("\\selectlanguage{" + sLang + "}", "");
        } else {
            ba.add("\\foreignlanguage{" + sLang + "}{", "}");
        }
    }

    public String getMajorityLanguage() {
        Hashtable<String, Integer> langs = new Hashtable<String, Integer>();
        String sDefaultLang = null;
        StyleWithProperties style = this.wsc.getDefaultParStyle();
        if (style != null) {
            sDefaultLang = style.getProperty("fo:language");
        }
        Enumeration enumeration = this.wsc.getParStyles().getStylesEnumeration();
        while (enumeration.hasMoreElements()) {
            style = (StyleWithProperties)enumeration.nextElement();
            String sLang = style.getProperty("fo:language");
            if (sLang == null) {
                sLang = sDefaultLang;
            }
            if (sLang == null) continue;
            int nCount = 1;
            if (langs.containsKey(sLang)) {
                nCount = (Integer)langs.get(sLang) + 1;
            }
            langs.put(sLang, new Integer(nCount));
        }
        int nMaxCount = 0;
        String sMajorityLanguage = null;
        enumeration = langs.keys();
        while (enumeration.hasMoreElements()) {
            String sLang = (String)enumeration.nextElement();
            int nCount = (Integer)langs.get(sLang);
            if (nCount <= nMaxCount) continue;
            nMaxCount = nCount;
            sMajorityLanguage = sLang;
        }
        this.sMajorityLanguage = sMajorityLanguage;
        return sMajorityLanguage;
    }

    private void convertLanguageUsage(LaTeXDocumentPortion ldp) {
        String sLang;
        Vector<String> languages = new Vector<String>();
        String sDefaultLanguage = null;
        if (this.config.multilingual()) {
            StyleWithProperties style;
            Enumeration enumeration = this.wsc.getTextStyles().getStylesEnumeration();
            while (enumeration.hasMoreElements()) {
                style = (StyleWithProperties)enumeration.nextElement();
                sLang = I18n.getBabelLanguage(style.getProperty("fo:language"));
                if (sLang == null || languages.contains(sLang)) continue;
                languages.add(sLang);
            }
            enumeration = this.wsc.getParStyles().getStylesEnumeration();
            while (enumeration.hasMoreElements()) {
                style = (StyleWithProperties)enumeration.nextElement();
                sLang = I18n.getBabelLanguage(style.getProperty("fo:language"));
                if (sLang == null || languages.contains(sLang)) continue;
                languages.add(sLang);
            }
            style = this.wsc.getDefaultParStyle();
            if (style != null) {
                sDefaultLanguage = I18n.getBabelLanguage(style.getProperty("fo:language"));
            }
        } else {
            sDefaultLanguage = I18n.getBabelLanguage(this.sMajorityLanguage == null ? this.getMajorityLanguage() : this.sMajorityLanguage);
        }
        if (this.greek() && !languages.contains("greek")) {
            languages.add("greek");
        }
        if (this.cyrillic() && !languages.contains("ukrainian") && !languages.contains("ukrainian") && !languages.contains("ukrainian")) {
            languages.add("russian");
        }
        CSVList babelopt = new CSVList(",");
        Enumeration langenum = languages.elements();
        while (langenum.hasMoreElements()) {
            sLang = (String)langenum.nextElement();
            if (sLang.equals(sDefaultLanguage)) continue;
            if ("greek".equals(sLang) && this.polytonicGreek()) {
                sLang = "polutonikogreek";
            }
            babelopt.addValue(sLang);
        }
        if (sDefaultLanguage != null) {
            if ("greek".equals(sDefaultLanguage) && this.polytonicGreek()) {
                babelopt.addValue("polutonikogreek");
            } else {
                babelopt.addValue(sDefaultLanguage);
            }
        }
        if (!babelopt.isEmpty()) {
            ldp.append("\\usepackage[").append(babelopt.toString()).append("]{babel}").nl();
        }
    }

    private void readSymbols(String sSymbols) {
        this.tableSet = new Hashtable();
        UnicodeTableHandler handler = new UnicodeTableHandler(this.tableSet, sSymbols);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        InputStream is = this.getClass().getResourceAsStream("symbols.xml");
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            System.out.println("Oops - Unable to read symbols.xml");
            t.printStackTrace();
        }
        this.tableStack = new Stack();
        this.tableStack.push((UnicodeTable)this.tableSet.get("root"));
        this.table = (UnicodeTable)this.tableSet.get("root");
    }

    public boolean cyrillic() {
        return this.bT2A;
    }

    public boolean greek() {
        return this.bGreek;
    }

    public boolean polytonicGreek() {
        return this.bPolytonicGreek;
    }

    private boolean greekMath(char c, int nFontenc) {
        return this.bGreekMath && nFontenc != 16 && this.table.getFontencs(c) == 16;
    }

    private void setFlags(char c, int nFontenc) {
        if (c >= '\u1f00' && c <= '\u1fff') {
            this.bPolytonicGreek = true;
        }
        if (nFontenc == 16) {
            this.bGreek = true;
        }
        if (nFontenc == 4) {
            this.bT2A = true;
        }
    }

    private String notFound(char c, int nFontenc) {
        String sErrorMsg = "[" + Integer.toHexString(c).toUpperCase() + "?]";
        if (nFontenc == 2) {
            return sErrorMsg;
        }
        return "\\textlatin{" + sErrorMsg + "}";
    }

    private String convertMathChar(char c, int nFontenc) {
        if (this.table.hasMathChar(c)) {
            return this.table.getMathChar(c);
        }
        if (this.table.hasTextChar(c)) {
            int nFontencs = this.table.getFontencs(c);
            if (I18n.supportsFontenc(nFontencs, nFontenc)) {
                this.setFlags(c, nFontenc);
                if (this.table.getCharType(c) == 1) {
                    return "\\text{" + this.table.getTextChar(c) + "{}}";
                }
                return "\\text{" + this.table.getTextChar(c) + "}";
            }
            int nFontenc1 = I18n.getFontenc(nFontencs);
            this.setFlags(c, nFontenc1);
            if (this.table.getCharType(c) == 1) {
                return "\\text{" + I18n.getFontencCs(nFontenc1) + "{" + this.table.getTextChar(c) + "{}}}";
            }
            return "\\text{" + I18n.getFontencCs(nFontenc1) + "{" + this.table.getTextChar(c) + "}}";
        }
        return "\\text{" + this.notFound(c, nFontenc) + "}";
    }

    public String convert(char c, boolean bMathMode, String sLang) {
        int nFontenc;
        int n = nFontenc = this.bAlwaysUseDefaultLang ? this.nDefaultFontenc : I18n.getFontenc(sLang);
        if (bMathMode) {
            return this.convertMathChar(c, nFontenc);
        }
        if (this.greekMath(c, nFontenc) || this.table.hasMathChar(c) && !this.table.hasTextChar(c)) {
            return "$" + this.convertMathChar(c, nFontenc) + "$";
        }
        if (this.table.hasTextChar(c)) {
            int nFontencs = this.table.getFontencs(c);
            if (I18n.supportsFontenc(nFontencs, nFontenc)) {
                this.setFlags(c, nFontenc);
                if (this.table.getCharType(c) == 1) {
                    return this.table.getTextChar(c) + "{}";
                }
                return this.table.getTextChar(c);
            }
            int nFontenc1 = I18n.getFontenc(nFontencs);
            this.setFlags(c, nFontenc1);
            if (this.table.getCharType(c) == 1) {
                return I18n.getFontencCs(nFontenc1) + "{" + this.table.getTextChar(c) + "{}}";
            }
            return I18n.getFontencCs(nFontenc1) + "{" + this.table.getTextChar(c) + "}";
        }
        return this.notFound(c, nFontenc);
    }

    public String convert(String s, boolean bMathMode, String sLang) {
        int nFontenc;
        int nCurFontenc = nFontenc = this.bAlwaysUseDefaultLang ? this.nDefaultFontenc : I18n.getFontenc(sLang);
        this.ucparser.reset(this.table, s);
        StringBuffer buf = new StringBuffer();
        while (this.ucparser.next()) {
            char c = this.ucparser.getChar();
            if (bMathMode) {
                buf.append(this.convertMathChar(c, nFontenc));
                continue;
            }
            if (this.greekMath(c, nFontenc) || this.table.hasMathChar(c) && !this.table.hasTextChar(c)) {
                buf.append("$").append(this.convertMathChar(c, nFontenc)).append("$");
                continue;
            }
            if (this.table.hasTextChar(c)) {
                int nFontencs = this.table.getFontencs(c);
                if (I18n.supportsFontenc(nFontencs, nCurFontenc)) {
                    this.setFlags(c, nCurFontenc);
                    if (this.ucparser.hasCombiningChar()) {
                        char cc = this.ucparser.getCombiningChar();
                        if (I18n.supportsFontenc(this.table.getFontencs(cc), nCurFontenc)) {
                            buf.append(this.table.getTextChar(cc)).append("{").append(this.table.getTextChar(c)).append("}");
                            continue;
                        }
                        buf.append(this.table.getTextChar(c));
                        continue;
                    }
                    buf.append(this.table.getTextChar(c));
                    continue;
                }
                int nFontenc1 = I18n.getFontenc(nFontencs);
                this.setFlags(c, nFontenc1);
                if (nCurFontenc != nFontenc) {
                    buf.append("}");
                }
                if (nFontenc1 != nFontenc) {
                    buf.append(I18n.getFontencCs(nFontenc1)).append("{");
                }
                if (this.ucparser.hasCombiningChar()) {
                    char cc = this.ucparser.getCombiningChar();
                    if (I18n.supportsFontenc(this.table.getFontencs(cc), nCurFontenc)) {
                        buf.append(this.table.getTextChar(cc)).append("{").append(this.table.getTextChar(c)).append("}");
                    } else {
                        buf.append(this.table.getTextChar(c));
                    }
                } else {
                    buf.append(this.table.getTextChar(c));
                }
                nCurFontenc = nFontenc1;
                continue;
            }
            buf.append(this.notFound(c, nCurFontenc));
        }
        if (nCurFontenc != nFontenc) {
            buf.append("}");
        }
        return buf.toString();
    }

    public void pushSpecialTable(String sName) {
        if (sName != null) {
            this.table = (UnicodeTable)this.tableSet.get(sName);
            if (this.table == null) {
                this.table = (UnicodeTable)this.tableSet.get("root");
            }
        }
        this.tableStack.push(this.table);
    }

    public void popSpecialTable() {
        this.tableStack.pop();
        this.table = (UnicodeTable)this.tableStack.peek();
    }

    public int getCharCount() {
        return this.table.getCharCount();
    }

    static {
        ASCII = 0;
        LATIN1 = 1;
        LATIN2 = 2;
        ISO_8859_7 = 3;
        CP1250 = 4;
        CP1251 = 5;
        KOI8_R = 6;
        UTF8 = 7;
        OT1_ENC = 1;
        T1_ENC = 2;
        T2A_ENC = 4;
        T3_ENC = 8;
        LGR_ENC = 16;
        ANY_ENC = 31;
    }
}

