/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.wiztools.commons.JavaScript;
import org.wiztools.restclient.ui.EscapableDialog;
import org.wiztools.restclient.ui.UIUtil;

public class URLEncodeDecodeDialog
extends EscapableDialog {
    private static final int JTA_ROWS = 8;
    private static final int JTA_COLS = 35;
    private JTextArea jta_in = new JTextArea(8, 35);
    private JTextArea jta_out = new JTextArea(8, 35);
    private JButton jb_encode = new JButton("Encode");
    private JButton jb_decode = new JButton("Decode");
    private JButton jb_clear_result = new JButton("Clear Result");
    private JButton jb_copy_result = new JButton("Copy Result");

    public URLEncodeDecodeDialog(Frame f) {
        super(f, false);
        this.setTitle("URL Encode/Decode");
        this.jta_out.setEditable(false);
        this.getRootPane().setDefaultButton(this.jb_encode);
        this.jb_encode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLEncodeDecodeDialog.this.encode();
            }
        });
        this.jb_decode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLEncodeDecodeDialog.this.decode();
            }
        });
        this.jb_clear_result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLEncodeDecodeDialog.this.jta_out.setText("");
            }
        });
        this.jb_copy_result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.clipboardCopy(URLEncodeDecodeDialog.this.jta_out.getText());
            }
        });
        JPanel jp_south = new JPanel(new BorderLayout());
        jp_south.add((Component)this.getButtonPanel(), "North");
        jp_south.add((Component)new JScrollPane(this.jta_out), "Center");
        JSplitPane jsp = new JSplitPane(0);
        jsp.setTopComponent(new JScrollPane(this.jta_in));
        jsp.setBottomComponent(jp_south);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)jsp, "Center");
        this.pack();
    }

    private JPanel getButtonPanel() {
        JPanel jp = new JPanel(new FlowLayout(2));
        jp.add(this.jb_encode);
        jp.add(this.jb_decode);
        jp.add(this.jb_clear_result);
        jp.add(this.jb_copy_result);
        return jp;
    }

    private void encode() {
        this.jta_out.setText(JavaScript.encodeURIComponent(this.jta_in.getText()));
    }

    private void decode() {
        this.jta_out.setText(JavaScript.decodeURIComponent(this.jta_in.getText()));
    }

    @Override
    public void doEscape(AWTEvent event) {
        this.setVisible(false);
    }
}

