/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.sablecc.sablecc.Cast;
import org.sablecc.sablecc.MacroExpander;
import org.sablecc.sablecc.ResolveAstIds;
import org.sablecc.sablecc.StringCast;
import org.sablecc.sablecc.TypedLinkedList;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAstAlt;
import org.sablecc.sablecc.node.AAstProd;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.APlusUnOp;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.AQMarkUnOp;
import org.sablecc.sablecc.node.AStarUnOp;
import org.sablecc.sablecc.node.ATokenDef;
import org.sablecc.sablecc.node.Start;

public class GenAnalyses
extends DepthFirstAdapter {
    private MacroExpander macros;
    private ResolveAstIds ast_ids;
    private File pkgDir;
    private String pkgName;
    private List elemList;
    private List altList = new TypedLinkedList(AltInfoCast.instance);
    private List tokenList = new TypedLinkedList(StringCast.instance);
    private String mainProduction;
    ElemInfo info;

    public GenAnalyses(ResolveAstIds ast_ids) {
        this.ast_ids = ast_ids;
        try {
            this.macros = new MacroExpander(new InputStreamReader(this.getClass().getResourceAsStream("analyses.txt")));
        }
        catch (IOException e) {
            throw new RuntimeException("unable to open analyses.txt.");
        }
        this.pkgDir = new File(ast_ids.astIds.pkgDir, "analysis");
        String string = this.pkgName = ast_ids.astIds.pkgName.equals("") ? "analysis" : ast_ids.astIds.pkgName + ".analysis";
        if (!this.pkgDir.exists() && !this.pkgDir.mkdir()) {
            throw new RuntimeException("Unable to create " + this.pkgDir.getAbsolutePath());
        }
    }

    @Override
    public void inAAstProd(AAstProd node) {
        if (this.mainProduction == null) {
            this.mainProduction = (String)this.ast_ids.ast_names.get(node);
        }
    }

    @Override
    public void inATokenDef(ATokenDef node) {
        this.tokenList.add(this.ast_ids.astIds.names.get(node));
    }

    @Override
    public void inAAstAlt(AAstAlt node) {
        this.elemList = new TypedLinkedList(ElemInfoCast.instance);
    }

    @Override
    public void caseAProductions(AProductions node) {
    }

    @Override
    public void inAElem(AElem node) {
        this.info = new ElemInfo();
        this.info.name = (String)this.ast_ids.ast_names.get(node);
        this.info.type = (String)this.ast_ids.ast_elemTypes.get(node);
        this.info.operator = 0;
        if (node.getUnOp() != null) {
            node.getUnOp().apply(new DepthFirstAdapter(){

                @Override
                public void caseAStarUnOp(AStarUnOp node) {
                    GenAnalyses.this.info.operator = 1;
                }

                @Override
                public void caseAQMarkUnOp(AQMarkUnOp node) {
                    GenAnalyses.this.info.operator = 2;
                }

                @Override
                public void caseAPlusUnOp(APlusUnOp node) {
                    GenAnalyses.this.info.operator = 3;
                }
            });
        }
        this.elemList.add(this.info);
        this.info = null;
    }

    @Override
    public void outAAstAlt(AAstAlt node) {
        AltInfo info = new AltInfo();
        info.name = (String)this.ast_ids.ast_names.get(node);
        info.elems.addAll(this.elemList);
        this.elemList = null;
        this.altList.add(info);
    }

    @Override
    public void outStart(Start node) {
        this.createAnalysis();
        this.createAnalysisAdapter();
        if (this.mainProduction != null) {
            this.createDepthFirstAdapter();
            this.createReversedDepthFirstAdapter();
        }
    }

    public void createAnalysis() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "Analysis.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "Analysis.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "AnalysisHeader", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "node" : this.ast_ids.astIds.pkgName + ".node"});
            if (this.mainProduction != null) {
                this.macros.apply(file, "AnalysisStart", null);
                for (AltInfo info : this.altList) {
                    this.macros.apply(file, "AnalysisBody", new String[]{info.name});
                }
                file.newLine();
            }
            Iterator i = this.tokenList.iterator();
            while (i.hasNext()) {
                this.macros.apply(file, "AnalysisBody", new String[]{(String)i.next()});
            }
            this.macros.apply(file, "AnalysisTail", null);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "Analysis.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createAnalysisAdapter() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "AnalysisAdapter.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "AnalysisAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "AnalysisAdapterHeader", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "node" : this.ast_ids.astIds.pkgName + ".node"});
            if (this.mainProduction != null) {
                this.macros.apply(file, "AnalysisAdapterStart", null);
                for (AltInfo info : this.altList) {
                    this.macros.apply(file, "AnalysisAdapterBody", new String[]{info.name});
                }
            }
            Iterator i = this.tokenList.iterator();
            while (i.hasNext()) {
                this.macros.apply(file, "AnalysisAdapterBody", new String[]{(String)i.next()});
            }
            this.macros.apply(file, "AnalysisAdapterTail", null);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "AnalysisAdapter.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createDepthFirstAdapter() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "DepthFirstAdapter.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "DepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "DepthFirstAdapterHeader", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "node" : this.ast_ids.astIds.pkgName + ".node", this.mainProduction});
            for (AltInfo info : this.altList) {
                this.macros.apply(file, "DepthFirstAdapterInOut", new String[]{info.name});
                this.macros.apply(file, "DepthFirstAdapterCaseHeader", new String[]{info.name});
                for (ElemInfo eInfo : info.elems) {
                    switch (eInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(file, "DepthFirstAdapterCaseBodyNode", new String[]{eInfo.name});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(file, "DepthFirstAdapterCaseBodyList", new String[]{eInfo.name, eInfo.type});
                        }
                    }
                }
                this.macros.apply(file, "DepthFirstAdapterCaseTail", new String[]{info.name});
            }
            this.macros.apply(file, "DepthFirstAdapterTail", null);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "DepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void createReversedDepthFirstAdapter() {
        BufferedWriter file;
        try {
            file = new BufferedWriter(new FileWriter(new File(this.pkgDir, "ReversedDepthFirstAdapter.java")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create " + new File(this.pkgDir, "ReversedDepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            this.macros.apply(file, "ReversedDepthFirstAdapterHeader", new String[]{this.pkgName, this.ast_ids.astIds.pkgName.equals("") ? "node" : this.ast_ids.astIds.pkgName + ".node", this.mainProduction});
            for (AltInfo info : this.altList) {
                this.macros.apply(file, "DepthFirstAdapterInOut", new String[]{info.name});
                this.macros.apply(file, "DepthFirstAdapterCaseHeader", new String[]{info.name});
                ListIterator j = info.elems.listIterator(info.elems.size());
                while (j.hasPrevious()) {
                    ElemInfo eInfo = (ElemInfo)j.previous();
                    switch (eInfo.operator) {
                        case 0: 
                        case 2: {
                            this.macros.apply(file, "DepthFirstAdapterCaseBodyNode", new String[]{eInfo.name});
                            break;
                        }
                        case 1: 
                        case 3: {
                            this.macros.apply(file, "ReversedDepthFirstAdapterCaseBodyList", new String[]{eInfo.name, eInfo.type});
                        }
                    }
                }
                this.macros.apply(file, "DepthFirstAdapterCaseTail", new String[]{info.name});
            }
            this.macros.apply(file, "DepthFirstAdapterTail", null);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occured while writing to " + new File(this.pkgDir, "ReversedDepthFirstAdapter.java").getAbsolutePath());
        }
        try {
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class AltInfoCast
    implements Cast {
        static final AltInfoCast instance = new AltInfoCast();

        private AltInfoCast() {
        }

        @Override
        public Object cast(Object o) {
            return (AltInfo)o;
        }
    }

    private static class AltInfo {
        String name;
        final List elems = new TypedLinkedList(ElemInfoCast.instance);

        private AltInfo() {
        }
    }

    private static class ElemInfoCast
    implements Cast {
        static final ElemInfoCast instance = new ElemInfoCast();

        private ElemInfoCast() {
        }

        @Override
        public Object cast(Object o) {
            return (ElemInfo)o;
        }
    }

    private static class ElemInfo {
        static final int NONE = 0;
        static final int STAR = 1;
        static final int QMARK = 2;
        static final int PLUS = 3;
        String name;
        String type;
        int operator;

        private ElemInfo() {
        }
    }
}

