/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import org.fusesource.hawtdispatch.internal.NioDispatchSource;

final class NioAttachment {
    final ArrayList<NioDispatchSource> sources = new ArrayList(2);

    NioAttachment() {
    }

    public void selected(SelectionKey key) {
        int readyOps = key.readyOps();
        for (NioDispatchSource source : this.sources) {
            int ops = source.interestOps & readyOps;
            if (ops == 0) continue;
            source.fire(readyOps);
        }
    }

    public void cancel(SelectionKey key) {
        for (NioDispatchSource source : new ArrayList<NioDispatchSource>(this.sources)) {
            this.sources.remove(source);
            if (!source.canceled.compareAndSet(false, true)) continue;
            source.internal_cancel();
        }
        key.attach(null);
        key.cancel();
    }
}

