/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.util;

import java.util.List;
import org.apache.activemq.apollo.util.Callback;
import org.apache.activemq.apollo.util.Service;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.internal.util.RunnableCountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceStopper {
    private Throwable firstException;

    public void stop(Service service) {
        try {
            if (service != null) {
                RunnableCountDownLatch latch = new RunnableCountDownLatch(1);
                service.stop((Task)latch);
                latch.await();
            }
        }
        catch (Exception e) {
            this.onException(service, e);
        }
    }

    public void run(Callback stopClosure) {
        try {
            stopClosure.execute();
        }
        catch (Throwable e) {
            this.onException(stopClosure, e);
        }
    }

    public void stopServices(List<Service> services) throws Exception {
        RunnableCountDownLatch latch = new RunnableCountDownLatch(services.size());
        for (int i = 0; i < services.size(); ++i) {
            Service service = services.get(i);
            try {
                service.stop((Task)latch);
                continue;
            }
            catch (Exception e) {
                this.onException(service, e);
            }
        }
        if (this.firstException == null) {
            latch.await();
        }
    }

    public void onException(Object owner, Throwable e) {
        this.logError(owner, e);
        if (this.firstException == null) {
            this.firstException = e;
        }
    }

    public void throwFirstException() throws Exception {
        if (this.firstException != null) {
            if (this.firstException instanceof Exception) {
                Exception e = (Exception)this.firstException;
                throw e;
            }
            if (this.firstException instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)this.firstException;
                throw e;
            }
            throw new RuntimeException("Unknown type of exception: " + this.firstException, this.firstException);
        }
    }

    protected void logError(Object service, Throwable e) {
        Logger log = LoggerFactory.getLogger(service.getClass());
        log.error("Could not stop service: " + service + ". Reason: " + e, e);
    }
}

